/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.transaction;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.TransactionException;
import net.sf.hibernate.engine.SessionImplementor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JTATransaction
implements Transaction,
Synchronization {
    private final SessionImplementor session;
    private UserTransaction ut;
    private boolean newTransaction;
    private boolean synchronization;
    private boolean begun;
    static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$transaction$JTATransaction == null ? (class$net$sf$hibernate$transaction$JTATransaction = JTATransaction.class$("net.sf.hibernate.transaction.JTATransaction")) : class$net$sf$hibernate$transaction$JTATransaction));
    static /* synthetic */ Class class$net$sf$hibernate$transaction$JTATransaction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"commit");
        try {
            if (this.session.getFlushMode() != FlushMode.NEVER) {
                this.session.flush();
            }
            try {
                if (this.newTransaction) {
                    this.ut.commit();
                }
            }
            catch (Exception e) {
                log.error((Object)"Commit failed", (Throwable)e);
                throw new TransactionException("Commit failed with exception: ", e);
            }
        }
        finally {
            if (!this.synchronization) {
                this.session.afterTransactionCompletion();
            }
        }
    }

    public void rollback() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"rollback");
        try {
            if (this.newTransaction) {
                this.ut.rollback();
            } else {
                this.ut.setRollbackOnly();
            }
        }
        catch (Exception e) {
            log.error((Object)"Rollback failed", (Throwable)e);
            throw new TransactionException("Rollback failed with exception: ", e);
        }
        finally {
            if (!this.synchronization) {
                this.session.afterTransactionCompletion();
            }
        }
    }

    public JTATransaction(SessionImplementor session) {
        this.session = session;
    }

    public void begin(InitialContext context, String utName, TransactionManager transactionManager) throws HibernateException {
        log.debug((Object)("Looking for UserTransaction under: " + utName));
        try {
            this.ut = (UserTransaction)context.lookup(utName);
        }
        catch (NamingException ne) {
            log.error((Object)"Could not find UserTransaction in JNDI", (Throwable)ne);
            throw new TransactionException("Could not find UserTransaction in JNDI: ", ne);
        }
        if (this.ut == null) {
            throw new AssertionFailure("A naming service lookup returned null");
        }
        log.debug((Object)"Obtained UserTransaction");
        try {
            boolean bl = this.newTransaction = this.ut.getStatus() == 6;
            if (this.newTransaction) {
                log.debug((Object)"beginning new transaction");
                this.ut.begin();
            }
        }
        catch (Exception e) {
            log.error((Object)"Begin failed", (Throwable)e);
            throw new TransactionException("Begin failed with exception: ", e);
        }
        if (transactionManager == null) {
            this.synchronization = false;
        } else {
            try {
                transactionManager.getTransaction().registerSynchronization((Synchronization)this);
            }
            catch (Exception se) {
                log.error((Object)"Could not register Synchronization", (Throwable)se);
                throw new TransactionException("Could not register Synchronization: ", se);
            }
            this.synchronization = true;
        }
        this.begun = true;
    }

    public boolean wasRolledBack() throws TransactionException {
        int status;
        if (!this.begun) {
            return false;
        }
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 1 || status == 9 || status == 4;
    }

    public boolean wasCommitted() throws TransactionException {
        int status;
        if (!this.begun) {
            return false;
        }
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 3;
    }

    public void afterCompletion(int status) {
        log.trace((Object)"transaction completion callback");
        this.session.afterTransactionCompletion();
    }

    public void beforeCompletion() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

