/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.ODMGCollection;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;
import org.odmg.DArray;
import org.odmg.DList;

public class List
extends ODMGCollection
implements java.util.List,
DList,
DArray {
    private java.util.List list;

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        ArrayList<Object> clonedList = new ArrayList<Object>(this.list.size());
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            clonedList.add(persister.getElementType().deepCopy(iter.next()));
        }
        return clonedList;
    }

    public Collection getOrphans(Serializable snapshot) throws HibernateException {
        java.util.List sn = (java.util.List)((Object)snapshot);
        ArrayList result = new ArrayList();
        result.addAll(sn);
        PersistentCollection.identityRemoveAll(result, this.list, this.session);
        return result;
    }

    public boolean equalsSnapshot(Type elementType) throws HibernateException {
        java.util.List sn = (java.util.List)((Object)this.getSnapshot());
        if (sn.size() != this.list.size()) {
            return false;
        }
        Iterator iter = this.list.iterator();
        Iterator sniter = sn.iterator();
        while (iter.hasNext()) {
            if (!elementType.isDirty(iter.next(), sniter.next(), this.session)) continue;
            return false;
        }
        return true;
    }

    public List(SessionImplementor session) {
        super(session);
    }

    public List(SessionImplementor session, java.util.List list) {
        super(session);
        this.list = list;
        this.initialized = true;
        this.directlyAccessible = true;
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.list = new ArrayList();
    }

    public List() {
    }

    public int size() {
        this.read();
        return this.list.size();
    }

    public boolean isEmpty() {
        this.read();
        return this.list.isEmpty();
    }

    public boolean contains(Object object) {
        this.read();
        return this.list.contains(object);
    }

    public Iterator iterator() {
        this.read();
        return new PersistentCollection.IteratorProxy(this.list.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.list.toArray();
    }

    public Object[] toArray(Object[] array) {
        this.read();
        return this.list.toArray(array);
    }

    public boolean add(Object object) {
        if (!this.queueAdd(object)) {
            this.write();
            return this.list.add(object);
        }
        return true;
    }

    public boolean remove(Object arg0) {
        this.write();
        return this.list.remove(arg0);
    }

    public boolean containsAll(Collection arg0) {
        this.read();
        return this.list.containsAll(arg0);
    }

    public boolean addAll(Collection c) {
        if (c.size() == 0) {
            return false;
        }
        if (!this.queueAddAll(c)) {
            this.write();
            return this.list.addAll(c);
        }
        return c.size() > 0;
    }

    public void delayedAddAll(Collection c) {
        this.list.addAll(c);
    }

    public boolean addAll(int index, Collection coll) {
        if (coll.size() > 0) {
            this.write();
            return this.list.addAll(index, coll);
        }
        return false;
    }

    public boolean removeAll(Collection coll) {
        if (coll.size() > 0) {
            this.write();
            return this.list.removeAll(coll);
        }
        return false;
    }

    public boolean retainAll(Collection coll) {
        this.write();
        return this.list.retainAll(coll);
    }

    public void clear() {
        this.write();
        this.list.clear();
    }

    public Object get(int arg0) {
        this.read();
        return this.list.get(arg0);
    }

    public Object set(int arg0, Object arg1) {
        this.write();
        return this.list.set(arg0, arg1);
    }

    public void add(int arg0, Object arg1) {
        this.write();
        this.list.add(arg0, arg1);
    }

    public Object remove(int arg0) {
        this.write();
        return this.list.remove(arg0);
    }

    public int indexOf(Object arg0) {
        this.read();
        return this.list.indexOf(arg0);
    }

    public int lastIndexOf(Object arg0) {
        this.read();
        return this.list.lastIndexOf(arg0);
    }

    public ListIterator listIterator() {
        this.read();
        return new PersistentCollection.ListIteratorProxy(this.list.listIterator());
    }

    public ListIterator listIterator(int arg0) {
        this.read();
        return new PersistentCollection.ListIteratorProxy(this.list.listIterator(arg0));
    }

    public java.util.List subList(int arg0, int arg1) {
        this.read();
        return new PersistentCollection.ListProxy(this.list.subList(arg0, arg1));
    }

    public Iterator elements() {
        return this.list.iterator();
    }

    public boolean empty() {
        return this.list.isEmpty();
    }

    public String toString() {
        this.read();
        return this.list.toString();
    }

    public void writeTo(PreparedStatement st, CollectionPersister persister, Object entry, int i, boolean writeOrder) throws HibernateException, SQLException {
        persister.writeElement(st, entry, writeOrder, this.session);
        persister.writeIndex(st, new Integer(i), writeOrder, this.session);
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, this.session);
        int index = (Integer)persister.readIndex(rs, this.session);
        for (int i = this.list.size(); i <= index; ++i) {
            this.list.add(i, null);
        }
        this.list.set(index, element);
        return element;
    }

    public Iterator entries() {
        return this.list.iterator();
    }

    public List(SessionImplementor session, CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        super(session);
        this.beforeInitialize(persister);
        Serializable[] array = (Serializable[])disassembled;
        for (int i = 0; i < array.length; ++i) {
            this.list.add(persister.getElementType().assemble(array[i], session, owner));
        }
        this.initialized = true;
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = this.list.size();
        Serializable[] result = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            result[i] = persister.getElementType().disassemble(this.list.get(i), this.session);
        }
        return result;
    }

    public Iterator getDeletes(Type elemType) throws HibernateException {
        int end;
        int i;
        ArrayList<Integer> deletes = new ArrayList<Integer>();
        java.util.List sn = (java.util.List)((Object)this.getSnapshot());
        if (sn.size() > this.list.size()) {
            for (i = this.list.size(); i < sn.size(); ++i) {
                deletes.add(new Integer(i));
            }
            end = this.list.size();
        } else {
            end = sn.size();
        }
        for (i = 0; i < end; ++i) {
            if (this.list.get(i) != null || sn.get(i) == null) continue;
            deletes.add(new Integer(i));
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        java.util.List sn = (java.util.List)((Object)this.getSnapshot());
        return this.list.get(i) != null && (i >= sn.size() || sn.get(i) == null);
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        java.util.List sn = (java.util.List)((Object)this.getSnapshot());
        return i < sn.size() && sn.get(i) != null && this.list.get(i) != null && elemType.isDirty(this.list.get(i), sn.get(i), this.session);
    }

    public Object getIndex(Object entry, int i) {
        return new Integer(i);
    }

    public DList concat(DList arglist) {
        this.read();
        ArrayList tempList = new ArrayList(arglist.size() + this.list.size());
        tempList.addAll(this.list);
        tempList.addAll(arglist);
        return new List(this.session, tempList);
    }

    public void resize(int length) {
        this.write();
        ArrayList newlist = new ArrayList(length);
        Iterator iter = this.list.iterator();
        int i = 0;
        while (iter.hasNext() && ++i <= length) {
            newlist.add(iter.next());
        }
        this.list = newlist;
    }

    public boolean equals(Object other) {
        this.read();
        return ((Object)this.list).equals(other);
    }

    public int hashCode() {
        this.read();
        return ((Object)this.list).hashCode();
    }

    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }
}

