/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LazyInitializationException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.engine.CollectionSnapshot;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.LogFactory;

public abstract class PersistentCollection
implements Serializable {
    protected transient SessionImplementor session;
    protected boolean initialized;
    private transient List additions;
    private CollectionSnapshot collectionSnapshot;
    protected transient boolean directlyAccessible;
    static /* synthetic */ Class class$net$sf$hibernate$collection$PersistentCollection;

    public abstract Iterator elements();

    public abstract boolean empty();

    public final void read() {
        this.initialize(false);
    }

    private final boolean isConnectedToSession() {
        return this.session != null && this.session.isOpen();
    }

    protected final void write() {
        this.initialize(true);
        if (this.isConnectedToSession()) {
            this.session.dirty(this);
        } else {
            this.collectionSnapshot.setDirty();
        }
    }

    private boolean mayQueueAdd() {
        return !this.initialized && this.isConnectedToSession() && this.session.isInverseCollection(this);
    }

    protected final boolean queueAdd(Object element) {
        if (this.mayQueueAdd()) {
            if (this.additions == null) {
                this.additions = new ArrayList(10);
            }
            this.additions.add(element);
            this.session.dirty(this);
            return true;
        }
        return false;
    }

    protected final boolean queueAddAll(Collection coll) {
        if (this.mayQueueAdd()) {
            if (this.additions == null) {
                this.additions = new ArrayList(20);
            }
            this.additions.addAll(coll);
            return true;
        }
        return false;
    }

    public void delayedAddAll(Collection coll) {
        throw new AssertionFailure("Collection does not support delayed initialization");
    }

    public PersistentCollection() {
    }

    protected PersistentCollection(SessionImplementor session) {
        this.session = session;
    }

    public Object getInitialValue(boolean lazy) throws HibernateException {
        if (!lazy) {
            this.session.initialize(this, false);
            this.initialized = true;
        }
        return this;
    }

    public Object getCachedValue() {
        this.initialized = true;
        return this;
    }

    public void beginRead() {
    }

    public void endRead() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void initialize(boolean writing) {
        if (this.initialized) return;
        if (!this.isConnectedToSession()) throw new LazyInitializationException("Failed to lazily initialize a collection - no Session");
        try {
            this.session.initialize(this, writing);
            this.initialized = true;
            if (this.additions == null) return;
            this.delayedAddAll(this.additions);
            this.additions = null;
            return;
        }
        catch (Exception e) {
            LogFactory.getLog((Class)(class$net$sf$hibernate$collection$PersistentCollection == null ? (class$net$sf$hibernate$collection$PersistentCollection = PersistentCollection.class$("net.sf.hibernate.collection.PersistentCollection")) : class$net$sf$hibernate$collection$PersistentCollection)).error((Object)"Failed to lazily initialize a collection", (Throwable)e);
            throw new LazyInitializationException("Failed to lazily initialize a collection", e);
        }
    }

    public final boolean unsetSession(SessionImplementor session) {
        if (session == this.session) {
            this.session = null;
            return true;
        }
        return false;
    }

    public final boolean setSession(SessionImplementor session) throws HibernateException {
        if (session == this.session) {
            return false;
        }
        if (this.isConnectedToSession()) {
            throw new HibernateException("Illegal attempt to associate a collection with two open sessions");
        }
        this.session = session;
        return true;
    }

    public boolean isDirectlyAccessible() {
        return this.directlyAccessible;
    }

    public abstract Iterator entries();

    public abstract Object readFrom(ResultSet var1, CollectionPersister var2, Object var3) throws HibernateException, SQLException;

    public abstract void writeTo(PreparedStatement var1, CollectionPersister var2, Object var3, int var4, boolean var5) throws HibernateException, SQLException;

    public abstract Object getIndex(Object var1, int var2);

    public abstract void beforeInitialize(CollectionPersister var1);

    public abstract boolean equalsSnapshot(Type var1) throws HibernateException;

    protected abstract Serializable snapshot(CollectionPersister var1) throws HibernateException;

    public abstract Serializable disassemble(CollectionPersister var1) throws HibernateException;

    public boolean needsRecreate(CollectionPersister persister) throws HibernateException {
        return false;
    }

    public final Serializable getSnapshot(CollectionPersister persister) throws HibernateException {
        return persister == null ? null : this.snapshot(persister);
    }

    public final void forceLoad() {
        this.read();
    }

    public abstract boolean entryExists(Object var1, int var2);

    public abstract boolean needsInserting(Object var1, int var2, Type var3) throws HibernateException;

    public abstract boolean needsUpdating(Object var1, int var2, Type var3) throws HibernateException;

    public abstract Iterator getDeletes(Type var1) throws HibernateException;

    protected final Serializable getSnapshot() {
        return this.session.getSnapshot(this);
    }

    public final boolean wasInitialized() {
        return this.initialized;
    }

    public final boolean hasQueuedAdds() {
        return this.additions != null;
    }

    public final Iterator queuedAddsIterator() {
        return this.additions.iterator();
    }

    public CollectionSnapshot getCollectionSnapshot() {
        return this.collectionSnapshot;
    }

    public void setCollectionSnapshot(CollectionSnapshot collectionSnapshot) {
        this.collectionSnapshot = collectionSnapshot;
    }

    public void preInsert(CollectionPersister persister, Object entry, int i) throws HibernateException {
    }

    public abstract Collection getOrphans(Serializable var1) throws HibernateException;

    public static void identityRemoveAll(List list, Collection collection, SessionImplementor session) throws HibernateException {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            PersistentCollection.identityRemove(list, iter.next(), session);
        }
    }

    public static void identityRemove(Collection list, Object object, SessionImplementor session) throws HibernateException {
        if (session.isSaved(object)) {
            Serializable idOfCurrent = session.getEntityIdentifierIfNotUnsaved(object);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Serializable idOfOld = session.getEntityIdentifierIfNotUnsaved(iter.next());
                if (!idOfCurrent.equals(idOfOld)) continue;
                iter.remove();
                break;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class ListProxy
    implements List {
        private final List list;

        ListProxy(List list) {
            this.list = list;
        }

        public void add(int arg0, Object arg1) {
            PersistentCollection.this.write();
            this.list.add(arg0, arg1);
        }

        public boolean add(Object arg0) {
            PersistentCollection.this.write();
            return this.list.add(arg0);
        }

        public boolean addAll(Collection arg0) {
            PersistentCollection.this.write();
            return this.list.addAll(arg0);
        }

        public boolean addAll(int arg0, Collection arg1) {
            PersistentCollection.this.write();
            return this.list.addAll(arg0, arg1);
        }

        public void clear() {
            PersistentCollection.this.write();
            this.list.clear();
        }

        public boolean contains(Object arg0) {
            return this.list.contains(arg0);
        }

        public boolean containsAll(Collection arg0) {
            return this.list.containsAll(arg0);
        }

        public Object get(int arg0) {
            return this.list.get(arg0);
        }

        public int indexOf(Object arg0) {
            return this.list.indexOf(arg0);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Iterator iterator() {
            return new IteratorProxy(this.list.iterator());
        }

        public int lastIndexOf(Object arg0) {
            return this.list.lastIndexOf(arg0);
        }

        public ListIterator listIterator() {
            return new ListIteratorProxy(this.list.listIterator());
        }

        public ListIterator listIterator(int arg0) {
            return new ListIteratorProxy(this.list.listIterator(arg0));
        }

        public Object remove(int arg0) {
            PersistentCollection.this.write();
            return this.list.remove(arg0);
        }

        public boolean remove(Object arg0) {
            PersistentCollection.this.write();
            return this.list.remove(arg0);
        }

        public boolean removeAll(Collection arg0) {
            PersistentCollection.this.write();
            return this.list.removeAll(arg0);
        }

        public boolean retainAll(Collection arg0) {
            PersistentCollection.this.write();
            return this.list.retainAll(arg0);
        }

        public Object set(int arg0, Object arg1) {
            PersistentCollection.this.write();
            return this.list.set(arg0, arg1);
        }

        public int size() {
            return this.list.size();
        }

        public List subList(int arg0, int arg1) {
            return this.list.subList(arg0, arg1);
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public Object[] toArray(Object[] arg0) {
            return this.list.toArray(arg0);
        }
    }

    class SetProxy
    implements Set {
        protected final Collection set;

        SetProxy(Collection set) {
            this.set = set;
        }

        public boolean add(Object arg0) {
            PersistentCollection.this.write();
            return this.set.add(arg0);
        }

        public boolean addAll(Collection arg0) {
            PersistentCollection.this.write();
            return this.set.addAll(arg0);
        }

        public void clear() {
            PersistentCollection.this.write();
            this.set.clear();
        }

        public boolean contains(Object arg0) {
            return this.set.contains(arg0);
        }

        public boolean containsAll(Collection arg0) {
            return this.set.containsAll(arg0);
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public Iterator iterator() {
            return new IteratorProxy(this.set.iterator());
        }

        public boolean remove(Object arg0) {
            PersistentCollection.this.write();
            return this.set.remove(arg0);
        }

        public boolean removeAll(Collection arg0) {
            PersistentCollection.this.write();
            return this.set.removeAll(arg0);
        }

        public boolean retainAll(Collection arg0) {
            PersistentCollection.this.write();
            return this.set.retainAll(arg0);
        }

        public int size() {
            return this.set.size();
        }

        public Object[] toArray() {
            return this.set.toArray();
        }

        public Object[] toArray(Object[] arg0) {
            return this.set.toArray(arg0);
        }
    }

    final class ListIteratorProxy
    implements ListIterator {
        private final ListIterator iter;

        ListIteratorProxy(ListIterator iter) {
            this.iter = iter;
        }

        public void add(Object o) {
            PersistentCollection.this.write();
            this.iter.add(o);
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        public Object next() {
            return this.iter.next();
        }

        public int nextIndex() {
            return this.iter.nextIndex();
        }

        public Object previous() {
            return this.iter.previous();
        }

        public int previousIndex() {
            return this.iter.previousIndex();
        }

        public void remove() {
            PersistentCollection.this.write();
            this.iter.remove();
        }

        public void set(Object o) {
            PersistentCollection.this.write();
            this.iter.set(o);
        }
    }

    final class IteratorProxy
    implements Iterator {
        private final Iterator iter;

        IteratorProxy(Iterator iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return this.iter.next();
        }

        public void remove() {
            PersistentCollection.this.write();
            this.iter.remove();
        }
    }
}

