/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.sql.CaseFragment;
import net.sf.hibernate.sql.HSQLCaseFragment;

public class HSQLDialect
extends Dialect {
    public HSQLDialect() {
        this.register(-5, "BIGINT");
        this.register(-2, "BINARY");
        this.register(-7, "BIT");
        this.register(1, "CHAR(1)");
        this.register(91, "DATE");
        this.register(3, "DECIMAL");
        this.register(8, "DOUBLE");
        this.register(6, "FLOAT");
        this.register(4, "INTEGER");
        this.register(-4, "LONGVARBINARY");
        this.register(-1, "LONGVARCHAR");
        this.register(5, "SMALLINT");
        this.register(-6, "TINYINT");
        this.register(92, "TIME");
        this.register(93, "TIMESTAMP");
        this.register(12, "VARCHAR($l)");
        this.register(-3, "VARBINARY($l)");
        this.register(2, "NUMERIC");
        this.register(2004, "LONGVARBINARY");
        this.register(2005, "LONGVARCHAR");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "false");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentityColumnString() {
        return "NOT NULL IDENTITY";
    }

    public String getIdentitySelectString() {
        return "call IDENTITY()";
    }

    public String getIdentityInsertString() {
        return "null";
    }

    public boolean supportsForUpdate() {
        return false;
    }

    public boolean supportsUnique() {
        return false;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql) {
        StringBuffer pagingSelect = new StringBuffer(100);
        pagingSelect.append(sql);
        pagingSelect.insert(6, " limit ? ?");
        return pagingSelect.toString();
    }

    public CaseFragment createCaseFragment() {
        return new HSQLCaseFragment();
    }

    public boolean bindLimitParametersFirst() {
        return true;
    }
}

