/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.QueryFunctionStandard;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.hql.QueryFunctionInfo;
import net.sf.hibernate.type.Type;

public class Oracle9Dialect
extends Dialect {
    private final Map aggregateFunctions = new HashMap();

    public Oracle9Dialect() {
        this.register(-7, "NUMBER(1,0)");
        this.register(-5, "NUMBER(19,0)");
        this.register(5, "NUMBER(5,0)");
        this.register(-6, "NUMBER(3,0)");
        this.register(4, "NUMBER(10,0)");
        this.register(1, "CHAR(1)");
        this.register(12, "VARCHAR2($l)");
        this.register(6, "FLOAT");
        this.register(8, "DOUBLE PRECISION");
        this.register(91, "DATE");
        this.register(92, "DATE");
        this.register(93, "DATE");
        this.register(-3, "RAW($l)");
        this.register(2, "NUMBER(19, $l)");
        this.register(2004, "BLOB");
        this.register(2005, "CLOB");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.aggregateFunctions.putAll(super.getAggregateFunctions());
        this.aggregateFunctions.put("trunc", new QueryFunctionStandard());
        this.aggregateFunctions.put("round", new QueryFunctionStandard());
        this.aggregateFunctions.put("abs", new QueryFunctionStandard(Hibernate.INTEGER));
        this.aggregateFunctions.put("sign", new QueryFunctionStandard(Hibernate.INTEGER));
        this.aggregateFunctions.put("ceil", new QueryFunctionStandard(Hibernate.INTEGER));
        this.aggregateFunctions.put("floor", new QueryFunctionStandard(Hibernate.INTEGER));
        this.aggregateFunctions.put("sqrt", new QueryFunctionStandard());
        this.aggregateFunctions.put("exp", new QueryFunctionStandard());
        this.aggregateFunctions.put("ln", new QueryFunctionStandard());
        this.aggregateFunctions.put("sin", new QueryFunctionStandard());
        this.aggregateFunctions.put("sinh", new QueryFunctionStandard());
        this.aggregateFunctions.put("cos", new QueryFunctionStandard());
        this.aggregateFunctions.put("cosh", new QueryFunctionStandard());
        this.aggregateFunctions.put("tan", new QueryFunctionStandard());
        this.aggregateFunctions.put("tanh", new QueryFunctionStandard());
        this.aggregateFunctions.put("stddev", new QueryFunctionStandard());
        this.aggregateFunctions.put("variance", new QueryFunctionStandard());
        this.aggregateFunctions.put("sysdate", new QueryFunctionInfo(){

            public Type queryFunctionType(Type columnType, Mapping mapping) throws QueryException {
                return Hibernate.DATE;
            }

            public boolean isFunctionArgs() {
                return false;
            }

            public boolean isFunctionNoArgsUseParenthesis() {
                return false;
            }
        });
        this.aggregateFunctions.put("lastday", new QueryFunctionStandard(Hibernate.DATE));
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    public boolean supportsForUpdateNowait() {
        return true;
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql) {
        StringBuffer pagingSelect = new StringBuffer(100);
        pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        pagingSelect.append(sql);
        pagingSelect.append(" ) row_ where rownum <= ?) where rownum_ > ?");
        return pagingSelect.toString();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean supportsForUpdateOf() {
        return true;
    }

    public Map getAggregateFunctions() {
        return this.aggregateFunctions;
    }

    public boolean useMaxForLimit() {
        return true;
    }
}

