/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.util.StringHelper;

public class BetweenExpression
extends Expression {
    private final String propertyName;
    private final Object lo;
    private final Object hi;

    BetweenExpression(String propertyName, Object lo, Object hi) {
        this.propertyName = propertyName;
        this.lo = lo;
        this.hi = hi;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias) throws HibernateException {
        return StringHelper.join(" and ", StringHelper.suffix(BetweenExpression.getColumns(sessionFactory, persistentClass, this.propertyName, alias), " between ? and ?"));
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass) throws HibernateException {
        return new TypedValue[]{BetweenExpression.getTypedValue(sessionFactory, persistentClass, this.propertyName, this.lo), BetweenExpression.getTypedValue(sessionFactory, persistentClass, this.propertyName, this.hi)};
    }

    public String toString() {
        return this.propertyName + " between " + this.lo + " and " + this.hi;
    }
}

