/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.util.StringHelper;

public abstract class Junction
extends Expression {
    private List expressions = new ArrayList();

    public Junction add(Expression expression) {
        this.expressions.add(expression);
        return this;
    }

    abstract String getOp();

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass) throws HibernateException {
        ArrayList<TypedValue> typedValues = new ArrayList<TypedValue>();
        Iterator iter = this.expressions.iterator();
        while (iter.hasNext()) {
            TypedValue[] subvalues = ((Expression)iter.next()).getTypedValues(sessionFactory, persistentClass);
            for (int i = 0; i < subvalues.length; ++i) {
                typedValues.add(subvalues[i]);
            }
        }
        return typedValues.toArray(new TypedValue[typedValues.size()]);
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias) throws HibernateException {
        if (this.expressions.size() == 0) {
            return "1=1";
        }
        StringBuffer buffer = new StringBuffer().append('(');
        Iterator iter = this.expressions.iterator();
        while (iter.hasNext()) {
            buffer.append(((Expression)iter.next()).toSqlString(sessionFactory, persistentClass, alias));
            if (!iter.hasNext()) continue;
            buffer.append(this.getOp());
        }
        return buffer.append(')').toString();
    }

    public String toString() {
        return '(' + StringHelper.join(this.getOp(), this.expressions.iterator()) + ')';
    }
}

