/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.BatcherImpl;
import net.sf.hibernate.util.JDBCExceptionReporter;

public class BatchingBatcher
extends BatcherImpl {
    private int batchSize;

    public BatchingBatcher(SessionImplementor session) {
        super(session);
    }

    public void addToBatch(int expectedRowCount) throws SQLException, HibernateException {
        log.trace((Object)"Adding to batch");
        PreparedStatement batchUpdate = this.getStatement();
        batchUpdate.addBatch();
        ++this.batchSize;
        if (this.batchSize == this.getFactory().getJdbcBatchSize()) {
            this.doExecuteBatch(batchUpdate);
        }
    }

    protected void doExecuteBatch(PreparedStatement ps) throws SQLException, HibernateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing batch size: " + this.batchSize));
        }
        try {
            if (this.batchSize != 0) {
                int[] results = ps.executeBatch();
                for (int i = 0; i < this.batchSize; ++i) {
                    if (results[i] != -3) continue;
                    throw new HibernateException("Batch update failed");
                }
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
        catch (RuntimeException re) {
            log.error((Object)"Exception executing batch: ", (Throwable)re);
            throw re;
        }
        finally {
            this.batchSize = 0;
        }
    }
}

