/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.util.List;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.loader.OuterJoinLoader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.Select;

public abstract class AbstractEntityLoader
extends OuterJoinLoader {
    protected final Loadable persister;
    protected String alias;

    public AbstractEntityLoader(Loadable persister, SessionFactoryImplementor factory) {
        super(factory.getDialect());
        this.persister = persister;
        this.alias = AbstractEntityLoader.alias(persister.getClassName(), 0);
    }

    protected void renderStatement(String condition, SessionFactoryImplementor factory) throws MappingException {
        this.renderStatement(condition, "", factory);
    }

    protected void renderStatement(String condition, String orderBy, SessionFactoryImplementor factory) throws MappingException {
        List associations = this.walkTree(this.persister, this.alias, factory);
        int joins = associations.size();
        this.suffixes = new String[joins + 1];
        for (int i = 0; i <= joins; ++i) {
            this.suffixes[i] = joins == 0 ? "" : Integer.toString(i) + '_';
        }
        JoinFragment ojf = this.outerJoins(associations);
        this.sql = new Select().setSelectClause((joins == 0 ? "" : this.selectString(associations) + ", ") + AbstractEntityLoader.selectString(this.persister, this.alias, this.suffixes[joins])).setFromClause(this.persister.fromTableFragment(this.alias) + this.persister.fromJoinFragment(this.alias, true, true)).setWhereClause(condition).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString() + (this.useQueryWhereFragment() ? ((Queryable)this.persister).queryWhereFragment(this.alias, true, true) : this.persister.whereJoinFragment(this.alias, true, true))).setOrderByClause(orderBy).toStatementString();
        this.classPersisters = new Loadable[joins + 1];
        this.lockModeArray = this.createLockModeArray(joins + 1, LockMode.NONE);
        for (int i = 0; i < joins; ++i) {
            this.classPersisters[i] = ((OuterJoinLoader.OuterJoinableAssociation)associations.get((int)i)).subpersister;
        }
        this.classPersisters[joins] = this.persister;
    }

    protected boolean useQueryWhereFragment() {
        return false;
    }
}

