/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.WrongClassException;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.Key;
import net.sf.hibernate.engine.RowSelection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.sql.Alias;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.VersionType;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Loader {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$loader$Loader == null ? (class$net$sf$hibernate$loader$Loader = Loader.class$("net.sf.hibernate.loader.Loader")) : class$net$sf$hibernate$loader$Loader));
    private String[][] suffixedKeyColumns;
    private String[][] suffixedVersionColumNames;
    private String[][][] suffixedPropertyColumns;
    private String[] suffixedDiscriminatorColumn;
    static /* synthetic */ Class class$net$sf$hibernate$loader$Loader;

    protected abstract String getSQLString();

    public abstract Loadable[] getPersisters();

    protected abstract String[] getSuffixes();

    protected abstract CollectionPersister getCollectionPersister();

    protected int getCollectionOwner() {
        return -1;
    }

    protected abstract LockMode[] getLockModes(Map var1);

    protected String applyLocks(String sql, Map lockModes, Dialect dialect) throws HibernateException {
        return sql;
    }

    protected boolean upgradeLocks() {
        return false;
    }

    private final List doFind(SessionImplementor session, Object[] values, Type[] types, Object optionalObject, Serializable optionalID, PersistentCollection optionalCollection, Object optionalCollectionOwner, boolean returnProxies, RowSelection selection, Map namedParams, Map lockModes) throws SQLException, HibernateException {
        returnProxies = returnProxies && Environment.jvmSupportsProxies();
        int maxRows = selection == null || selection.getMaxRows() == null ? Integer.MAX_VALUE : selection.getMaxRows();
        Loadable[] persisters = this.getPersisters();
        int cols = persisters.length;
        CollectionPersister collectionPersister = this.getCollectionPersister();
        int collectionOwner = this.getCollectionOwner();
        boolean returnsEntities = cols > 0;
        String[] suffixes = this.getSuffixes();
        LockMode[] lockModeArray = this.getLockModes(lockModes);
        boolean singleCollection = collectionPersister != null && optionalCollection != null;
        boolean multipleCollections = collectionPersister != null && optionalCollection == null && collectionOwner >= 0;
        ArrayList hydratedObjects = returnsEntities ? new ArrayList() : null;
        Key optionalObjectKey = optionalObject != null ? new Key(optionalID, session.getPersister(optionalObject)) : null;
        ArrayList<Object> results = new ArrayList<Object>();
        PreparedStatement st = this.prepareQueryStatement(this.applyLocks(this.getSQLString(), lockModes, session.getFactory().getDialect()), values, types, namedParams, selection, false, session);
        ResultSet rs = this.getResultSet(st, selection, session);
        try {
            int count;
            if (singleCollection) {
                optionalCollection.beginRead();
            }
            Key[] keys = new Key[cols];
            if (log.isTraceEnabled()) {
                log.trace((Object)"processing result set");
            }
            for (count = 0; count < maxRows && rs.next(); ++count) {
                for (int i = 0; i < cols; ++i) {
                    keys[i] = this.getKeyFromResultSet(i, persisters[i], i == cols - 1 ? optionalID : null, rs, session);
                }
                Object[] row = this.getRow(rs, persisters, suffixes, keys, optionalObject, optionalObjectKey, lockModeArray, hydratedObjects, session);
                if (returnProxies) {
                    for (int i = 0; i < cols; ++i) {
                        row[i] = session.proxyFor(persisters[i], keys[i], row[i]);
                    }
                }
                if (multipleCollections) {
                    Key ownerKey = keys[collectionOwner];
                    if (ownerKey != null) {
                        PersistentCollection rowCollection = session.getLoadingCollection(collectionPersister, ownerKey.getIdentifier());
                        Serializable collectionRowKey = (Serializable)collectionPersister.readKey(rs, session);
                        if (collectionRowKey != null) {
                            rowCollection.readFrom(rs, this.getCollectionPersister(), row[collectionOwner]);
                        }
                    }
                } else if (singleCollection) {
                    optionalCollection.readFrom(rs, this.getCollectionPersister(), optionalCollectionOwner);
                }
                results.add(this.getResultColumnOrRow(row, rs, session));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("done processing result set (" + count + " rows)"));
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
        finally {
            this.closeQueryStatement(st, rs, session);
        }
        if (returnsEntities) {
            int hydratedObjectsSize = hydratedObjects.size();
            if (log.isTraceEnabled()) {
                log.trace((Object)("total objects hydrated: " + hydratedObjectsSize));
            }
            for (int i = 0; i < hydratedObjectsSize; ++i) {
                session.initializeEntity(hydratedObjects.get(i));
            }
        }
        if (multipleCollections) {
            session.endLoadingCollections();
        }
        if (singleCollection) {
            optionalCollection.endRead();
        }
        return results;
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        return row;
    }

    private Key getKeyFromResultSet(int i, Loadable persister, Serializable id, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        if (id == null) {
            id = (Serializable)persister.getIdentifierType().nullSafeGet(rs, this.suffixedKeyColumns[i], session, null);
        }
        return id == null ? null : new Key(id, persister);
    }

    private void checkVersion(int i, Loadable persister, String suffix, Serializable id, Object version, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Object currentVersion;
        VersionType versionType;
        if (version != null && !(versionType = persister.getVersionType()).equals(version, currentVersion = versionType.nullSafeGet(rs, this.suffixedVersionColumNames[i], session, null))) {
            throw new StaleObjectStateException(persister.getMappedClass(), id);
        }
    }

    private Object[] getRow(ResultSet rs, Loadable[] persisters, String[] suffixes, Key[] keys, Object optionalObject, Key optionalObjectKey, LockMode[] lockModes, List hydratedObjects, SessionImplementor session) throws HibernateException, SQLException {
        int cols = persisters.length;
        if (log.isDebugEnabled()) {
            log.debug((Object)("result row: " + StringHelper.toString(keys)));
        }
        Object[] rowResults = new Object[cols];
        for (int i = 0; i < cols; ++i) {
            Object object = null;
            Key key = keys[i];
            if (keys[i] != null) {
                object = session.getEntity(key);
                if (object != null) {
                    this.instanceAlreadyLoaded(rs, i, persisters[i], suffixes[i], key, object, lockModes[i], session);
                } else {
                    object = this.instanceNotYetLoaded(rs, i, persisters[i], suffixes[i], key, lockModes[i], optionalObjectKey, optionalObject, hydratedObjects, session);
                }
            }
            rowResults[i] = object;
        }
        return rowResults;
    }

    private void instanceAlreadyLoaded(ResultSet rs, int i, Loadable persister, String suffix, Key key, Object object, LockMode lockMode, SessionImplementor session) throws HibernateException, SQLException {
        if (!persister.getMappedClass().isAssignableFrom(object.getClass())) {
            throw new WrongClassException("loaded object was of wrong class", key.getIdentifier(), persister.getMappedClass());
        }
        if (LockMode.NONE != lockMode && this.upgradeLocks() && persister.isVersioned() && session.getLockMode(object).lessThan(lockMode)) {
            this.checkVersion(i, persister, suffix, key.getIdentifier(), session.getVersion(object), rs, session);
            session.setLockMode(object, lockMode);
        }
    }

    private Object instanceNotYetLoaded(ResultSet rs, int i, Loadable persister, String suffix, Key key, LockMode lockMode, Key optionalObjectKey, Object optionalObject, List hydratedObjects, SessionImplementor session) throws HibernateException, SQLException {
        Class instanceClass = this.getInstanceClass(rs, i, persister, suffix, key.getIdentifier(), session);
        Object object = optionalObjectKey != null && key.equals(optionalObjectKey) ? optionalObject : session.instantiate(instanceClass, key.getIdentifier());
        LockMode acquiredLockMode = lockMode == LockMode.NONE ? LockMode.READ : lockMode;
        this.loadFromResultSet(rs, i, object, key, suffix, acquiredLockMode, persister, session);
        hydratedObjects.add(object);
        return object;
    }

    private void loadFromResultSet(ResultSet rs, int i, Object object, Key key, String suffix, LockMode lockMode, Loadable rootPersister, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Initializing object from ResultSet: " + key));
        }
        session.addUninitializedEntity(key, object, lockMode);
        Loadable persister = (Loadable)session.getPersister(object);
        String[][] cols = persister == rootPersister ? this.suffixedPropertyColumns[i] : this.getPropertyAliases(suffix, persister);
        Serializable id = key.getIdentifier();
        Object[] values = this.hydrate(rs, id, object, persister, session, cols);
        session.postHydrate(persister, id, values, object, lockMode);
    }

    private Class getInstanceClass(ResultSet rs, int i, Loadable persister, String suffix, Serializable id, SessionImplementor session) throws HibernateException, SQLException {
        Class topClass = persister.getMappedClass();
        if (persister.hasSubclasses()) {
            Object discriminatorValue = persister.getDiscriminatorType().nullSafeGet(rs, this.suffixedDiscriminatorColumn[i], session, null);
            Class result = persister.getSubclassForDiscriminatorValue(discriminatorValue);
            if (result == null) {
                throw new WrongClassException("Discriminator: " + discriminatorValue, id, topClass);
            }
            return result;
        }
        return topClass;
    }

    private Object[] hydrate(ResultSet rs, Serializable id, Object object, Loadable persister, SessionImplementor session, String[][] suffixedPropertyColumns) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Hydrating entity: " + persister.getClassName() + '#' + id));
        }
        Type[] types = persister.getPropertyTypes();
        Object[] values = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            values[i] = types[i].hydrate(rs, suffixedPropertyColumns[i], session, object);
        }
        return values;
    }

    protected final void advance(ResultSet rs, RowSelection selection, SessionImplementor session) throws SQLException {
        int firstRow = Loader.getFirstRow(selection);
        if (firstRow != 0) {
            if (session.getFactory().useScrollableResultSets()) {
                rs.absolute(firstRow);
            } else {
                for (int m = 0; m < firstRow; ++m) {
                    rs.next();
                }
            }
        }
    }

    private static int getFirstRow(RowSelection selection) {
        if (selection == null || selection.getFirstRow() == null) {
            return 0;
        }
        return selection.getFirstRow();
    }

    private static boolean useLimit(RowSelection selection, Dialect dialect) {
        return dialect.supportsLimit() && selection != null && selection.getMaxRows() != null && (dialect.preferLimit() || Loader.getFirstRow(selection) != 0);
    }

    protected final PreparedStatement prepareQueryStatement(String sql, Object[] values, Type[] types, Map namedParams, RowSelection selection, boolean scroll, SessionImplementor session) throws SQLException, HibernateException {
        boolean scrollable;
        Dialect dialect = session.getFactory().getDialect();
        boolean useLimit = Loader.useLimit(selection, dialect);
        boolean bl = scrollable = session.getFactory().useScrollableResultSets() && (scroll || !useLimit && Loader.getFirstRow(selection) != 0);
        if (useLimit) {
            sql = dialect.getLimitString(sql);
        }
        PreparedStatement st = session.getBatcher().prepareQueryStatement(sql, scrollable);
        try {
            int col = 1;
            if (useLimit && dialect.bindLimitParametersFirst()) {
                this.bindLimitParameters(st, col, selection, session);
                col += 2;
            }
            for (int i = 0; i < values.length; ++i) {
                types[i].nullSafeSet(st, values[i], col, session);
                col += types[i].getColumnSpan(session.getFactory());
            }
            col += this.bindNamedParameters(st, namedParams, col, session);
            if (useLimit && !dialect.bindLimitParametersFirst()) {
                this.bindLimitParameters(st, col, selection, session);
            }
            if (!useLimit) {
                this.setMaxRows(st, selection);
            }
            if (selection != null && selection.getTimeout() != null) {
                st.setQueryTimeout(selection.getTimeout());
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            this.closeQueryStatement(st, null, session);
            throw sqle;
        }
        catch (HibernateException he) {
            this.closeQueryStatement(st, null, session);
            throw he;
        }
        return st;
    }

    private void bindLimitParameters(PreparedStatement st, int index, RowSelection selection, SessionImplementor session) throws SQLException {
        boolean reverse;
        int firstRow = selection == null || selection.getFirstRow() == null ? 0 : selection.getFirstRow();
        int lastRow = selection.getMaxRows();
        Dialect dialect = session.getFactory().getDialect();
        if (dialect.useMaxForLimit()) {
            lastRow += firstRow;
        }
        st.setInt(index + ((reverse = dialect.bindLimitParametersInReverseOrder()) ? 1 : 0), firstRow);
        st.setInt(index + (reverse ? 0 : 1), lastRow);
    }

    protected final void setMaxRows(PreparedStatement st, RowSelection selection) throws SQLException {
        if (selection != null && selection.getMaxRows() != null) {
            st.setMaxRows(selection.getMaxRows() + (selection.getFirstRow() == null ? 0 : selection.getFirstRow()));
        }
    }

    protected final ResultSet getResultSet(PreparedStatement st, RowSelection selection, SessionImplementor session) throws SQLException, HibernateException {
        ResultSet rs = null;
        try {
            rs = session.getBatcher().getResultSet(st);
            if (!Loader.useLimit(selection, session.getFactory().getDialect())) {
                this.advance(rs, selection, session);
            }
            return rs;
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            this.closeQueryStatement(st, rs, session);
            throw sqle;
        }
    }

    protected final void closeQueryStatement(PreparedStatement st, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        session.getBatcher().closeQueryStatement(st, rs);
    }

    protected int bindNamedParameters(PreparedStatement st, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        return 0;
    }

    protected final List loadEntity(SessionImplementor session, Object[] values, Type[] types, Object optionalObject, Serializable optionalID, boolean returnProxies) throws SQLException, HibernateException {
        return this.doFind(session, values, types, optionalObject, optionalID, null, null, returnProxies, null, null, null);
    }

    protected final List loadCollection(SessionImplementor session, Serializable id, Type type, Object owner, PersistentCollection collection) throws SQLException, HibernateException {
        return this.doFind(session, new Object[]{id}, new Type[]{type}, null, null, collection, owner, true, null, null, null);
    }

    protected List find(SessionImplementor session, Object[] values, Type[] types, boolean returnProxies, RowSelection selection, Map namedParams, Map lockModes) throws SQLException, HibernateException {
        return this.doFind(session, values, types, null, null, null, null, returnProxies, selection, namedParams, lockModes);
    }

    protected void postInstantiate() {
        Loadable[] persisters = this.getPersisters();
        String[] suffixes = this.getSuffixes();
        this.suffixedKeyColumns = new String[persisters.length][];
        this.suffixedPropertyColumns = new String[persisters.length][][];
        this.suffixedVersionColumNames = new String[persisters.length][];
        this.suffixedDiscriminatorColumn = new String[persisters.length];
        for (int i = 0; i < persisters.length; ++i) {
            this.suffixedKeyColumns[i] = this.getKeyAliases(suffixes[i], persisters[i]);
            this.suffixedPropertyColumns[i] = this.getPropertyAliases(suffixes[i], persisters[i]);
            this.suffixedDiscriminatorColumn[i] = this.getDiscriminatorAliases(suffixes[i], persisters[i]);
            if (!persisters[i].isVersioned()) continue;
            this.suffixedVersionColumNames[i] = this.suffixedPropertyColumns[i][persisters[i].getVersionProperty()];
        }
    }

    private String[] getKeyAliases(String suffix, Loadable persister) {
        return new Alias(suffix).toUnquotedAliasStrings(persister.getIdentifierColumnNames());
    }

    private String[][] getPropertyAliases(String suffix, Loadable persister) {
        int size = persister.getPropertyNames().length;
        String[][] result = new String[size][];
        for (int i = 0; i < size; ++i) {
            result[i] = new Alias(suffix).toUnquotedAliasStrings(persister.getPropertyColumnNames(i));
        }
        return result;
    }

    private String getDiscriminatorAliases(String suffix, Loadable persister) {
        return persister.hasSubclasses() ? new Alias(suffix).toUnquotedAliasString(persister.getDiscriminatorColumnName()) : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

