/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.loader.Loader;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.sql.Alias;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.OneToOneType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.StringHelper;

public abstract class OuterJoinLoader
extends Loader {
    public static final int EAGER = 1;
    public static final int AUTO = 0;
    public static final int LAZY = -1;
    protected static final Type[] NO_TYPES = new Type[0];
    protected static final String[][] NO_STRINGARRAYS = new String[0][];
    protected static final String[] NO_STRINGS = new String[0];
    protected static final Loadable[] NO_PERSISTERS = new Loadable[0];
    protected Loadable[] classPersisters;
    protected LockMode[] lockModeArray;
    protected String sql;
    protected String[] suffixes;
    private Dialect dialect;

    public OuterJoinLoader(Dialect dialect) {
        this.dialect = dialect;
    }

    protected boolean enableJoinedFetch(boolean mappingDefault, String path, String table, String[] foreignKeyColumns) {
        return mappingDefault;
    }

    public final List walkTree(Loadable persister, String alias, SessionFactoryImplementor session) throws MappingException {
        ArrayList associations = new ArrayList();
        this.walkClassTree(persister, alias, associations, new HashSet(), "", session);
        return associations;
    }

    protected final List walkCollectionTree(CollectionPersister persister, String alias, SessionFactoryImplementor session) throws MappingException {
        ArrayList associations = new ArrayList();
        if (session.enableJoinedFetch()) {
            Type type = persister.getElementType();
            if (type.isEntityType()) {
                EntityType etype = (EntityType)type;
                if (this.autoEager(persister.enableJoinedFetch(), etype, session)) {
                    String[] columns = StringHelper.prefix(persister.getElementColumnNames(), alias + '.');
                    this.walkAssociationTree(etype, columns, persister, alias, associations, new HashSet(), "", session);
                }
            } else if (type.isComponentType()) {
                this.walkCompositeElementTree((AbstractComponentType)type, persister.getElementColumnNames(), persister, alias, associations, new HashSet(), "", session);
            }
        }
        return associations;
    }

    private final void walkAssociationTree(EntityType etype, Loadable persister, int propertyNumber, String alias, List associations, Set classPersisters, String path, SessionFactoryImplementor session) throws MappingException {
        String[] columns;
        boolean autoEager = this.autoEager(persister.enableJoinedFetch(propertyNumber), etype, session);
        if (etype.isOneToOne()) {
            if (persister.isDefinedOnSubclass(propertyNumber)) {
                return;
            }
            columns = StringHelper.prefix(persister.getIdentifierColumnNames(), alias + '.');
        } else {
            columns = persister.toColumns(alias, propertyNumber);
        }
        String subpath = this.subPath(path, persister.getSubclassPropertyName(propertyNumber));
        boolean enable = this.enableJoinedFetch(autoEager, subpath, persister.getSubclassPropertyTableName(propertyNumber), persister.getSubclassPropertyColumnNames(propertyNumber));
        if (enable) {
            this.walkAssociationTree(etype, columns, persister, alias, associations, classPersisters, subpath, session);
        }
    }

    private final void walkClassTree(Loadable persister, String alias, List associations, Set classPersisters, String path, SessionFactoryImplementor session) throws MappingException {
        if (!session.enableJoinedFetch()) {
            return;
        }
        int n = persister.countSubclassProperties();
        for (int i = 0; i < n; ++i) {
            Type type = persister.getSubclassPropertyType(i);
            if (type.isEntityType()) {
                this.walkAssociationTree((EntityType)type, persister, i, alias, associations, classPersisters, path, session);
                continue;
            }
            if (!type.isComponentType()) continue;
            String subpath = this.subPath(path, persister.getSubclassPropertyName(i));
            String[] columns = persister.getSubclassPropertyColumnNames(i);
            String[] aliasedColumns = persister.toColumns(alias, i);
            this.walkComponentTree((AbstractComponentType)type, i, columns, aliasedColumns, persister, alias, associations, classPersisters, subpath, session);
        }
    }

    private void walkComponentTree(AbstractComponentType act, int propertyNumber, String[] cols, String[] aliasedCols, Loadable persister, String alias, List associations, Set classPersisters, String path, SessionFactoryImplementor session) throws MappingException {
        if (!session.enableJoinedFetch()) {
            return;
        }
        Type[] types = act.getSubtypes();
        String[] propertyNames = act.getPropertyNames();
        int begin = 0;
        for (int i = 0; i < types.length; ++i) {
            int length = types[i].getColumnSpan(session);
            String[] range = ArrayHelper.slice(cols, begin, length);
            String[] aliasedRange = ArrayHelper.slice(aliasedCols, begin, length);
            if (types[i].isEntityType()) {
                EntityType etype = (EntityType)types[i];
                if (etype.isOneToOne()) continue;
                String subpath = this.subPath(path, propertyNames[i]);
                boolean autoEager = this.autoEager(act.enableJoinedFetch(i), etype, session);
                boolean enable = this.enableJoinedFetch(autoEager, subpath, persister.getSubclassPropertyTableName(propertyNumber), range);
                if (enable) {
                    this.walkAssociationTree(etype, aliasedRange, persister, alias, associations, classPersisters, subpath, session);
                }
            } else if (types[i].isComponentType()) {
                String subpath = this.subPath(path, propertyNames[i]);
                this.walkComponentTree((AbstractComponentType)types[i], propertyNumber, range, aliasedRange, persister, alias, associations, classPersisters, subpath, session);
            }
            begin += length;
        }
    }

    private void walkCompositeElementTree(AbstractComponentType act, String[] cols, CollectionPersister persister, String alias, List associations, Set classPersisters, String path, SessionFactoryImplementor session) throws MappingException {
        if (!session.enableJoinedFetch()) {
            return;
        }
        Type[] types = act.getSubtypes();
        String[] propertyNames = act.getPropertyNames();
        int begin = 0;
        for (int i = 0; i < types.length; ++i) {
            int length = types[i].getColumnSpan(session);
            String[] range = ArrayHelper.slice(cols, begin, length);
            if (types[i].isEntityType()) {
                EntityType etype = (EntityType)types[i];
                String subpath = this.subPath(path, propertyNames[i]);
                boolean autoEager = this.autoEager(act.enableJoinedFetch(i), etype, session);
                boolean enable = this.enableJoinedFetch(autoEager, subpath, persister.getQualifiedTableName(), range);
                if (enable) {
                    String[] columns = StringHelper.prefix(range, alias + '.');
                    this.walkAssociationTree(etype, columns, persister, alias, associations, classPersisters, subpath, session);
                }
            } else if (types[i].isComponentType()) {
                String subpath = this.subPath(path, propertyNames[i]);
                this.walkCompositeElementTree((AbstractComponentType)types[i], range, persister, alias, associations, classPersisters, subpath, session);
            }
            begin += length;
        }
    }

    protected boolean autoEager(int config, EntityType type, SessionFactoryImplementor session) throws MappingException {
        if (config == 1) {
            return true;
        }
        if (config == -1) {
            return false;
        }
        ClassPersister persister = session.getPersister(type.getPersistentClass());
        return !persister.hasProxy() || type.isOneToOne() && ((OneToOneType)type).isNullable();
    }

    private void walkAssociationTree(EntityType type, String[] columns, Object persister, String alias, List associations, Set classPersisters, String path, SessionFactoryImplementor session) throws MappingException {
        Loadable subpersister = (Loadable)session.getPersister(type.getPersistentClass());
        if (!classPersisters.contains(subpersister)) {
            String subalias;
            OuterJoinableAssociation assoc = new OuterJoinableAssociation();
            associations.add(assoc);
            classPersisters.add(persister);
            assoc.subpersister = subpersister;
            assoc.foreignKeyColumns = columns;
            assoc.subalias = subalias = OuterJoinLoader.alias(subpersister.getClassName(), associations.size());
            this.walkClassTree(subpersister, subalias, associations, classPersisters, path, session);
        }
    }

    public final String getSQLString() {
        return this.sql;
    }

    public final Loadable[] getPersisters() {
        return this.classPersisters;
    }

    public final String selectString(List associations) {
        StringBuffer buf = new StringBuffer(associations.size() * 100);
        for (int i = 0; i < associations.size(); ++i) {
            OuterJoinableAssociation join = (OuterJoinableAssociation)associations.get(i);
            OuterJoinLoader.appendSelectString(buf, join.subpersister, join.subalias, this.getSuffixes()[i]);
            if (i >= associations.size() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    protected static final String selectString(Loadable persister, String alias, String suffix) {
        StringBuffer buf = new StringBuffer(30);
        OuterJoinLoader.appendSelectString(buf, persister, alias, suffix);
        return buf.toString();
    }

    private static final void appendSelectString(StringBuffer buf, Loadable persister, String alias, String suffix) {
        buf.append(persister.identifierSelectFragment(alias, suffix)).append(persister.propertySelectFragment(alias, suffix));
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }

    protected static String alias(String tableName, int n) {
        tableName = StringHelper.unqualify(tableName);
        return new Alias(10, Integer.toString(n) + '_').toAliasString(tableName.toLowerCase());
    }

    protected CollectionPersister getCollectionPersister() {
        return null;
    }

    public void setSuffixes(String[] suffixes) {
        this.suffixes = suffixes;
    }

    public final JoinFragment outerJoins(List associations) {
        JoinFragment outerjoin = this.dialect.createOuterJoinFragment();
        Iterator iter = associations.iterator();
        while (iter.hasNext()) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)iter.next();
            outerjoin.addJoin(oj.subpersister.getTableName(), oj.subalias, oj.foreignKeyColumns, oj.subpersister.getIdentifierColumnNames(), 1);
            outerjoin.addJoins(oj.subpersister.fromJoinFragment(oj.subalias, false, true), oj.subpersister.whereJoinFragment(oj.subalias, false, true));
        }
        return outerjoin;
    }

    protected LockMode[] getLockModes(Map lockModes) {
        return this.lockModeArray;
    }

    protected LockMode[] createLockModeArray(int length, LockMode lockMode) {
        Object[] array = new LockMode[length];
        Arrays.fill(array, lockMode);
        return array;
    }

    private String subPath(String path, String property) {
        if (path == null || path.length() == 0) {
            return property;
        }
        return path + '.' + property;
    }

    public static final class OuterJoinableAssociation {
        Loadable subpersister;
        String[] foreignKeyColumns;
        String subalias;
    }
}

