/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.Iterator;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.mapping.Component;
import net.sf.hibernate.mapping.Formula;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.Stringable;

public class Property
extends Stringable {
    private String name;
    private Value value;
    private String cascade;
    private boolean updateable;
    private boolean insertable;

    public Property(Value value) {
        this.value = value;
    }

    public Type getType() {
        return this.value.getType();
    }

    public int getColumnSpan() {
        return this.value.getColumnSpan();
    }

    public Iterator getColumnIterator() {
        return this.value.getColumnIterator();
    }

    public String getName() {
        return this.name;
    }

    public boolean isUpdateable() {
        return this.updateable && !this.isFormula();
    }

    public boolean isComposite() {
        return this.value instanceof Component;
    }

    public Value getValue() {
        return this.value;
    }

    public Cascades.CascadeStyle getCascadeStyle() throws MappingException {
        Type type = this.value.getType();
        if (type.isComponentType() && !type.isObjectType()) {
            AbstractComponentType actype = (AbstractComponentType)type;
            int length = actype.getSubtypes().length;
            for (int i = 0; i < length; ++i) {
                if (actype.cascade(i) == Cascades.STYLE_NONE) continue;
                return Cascades.STYLE_ALL;
            }
            return Cascades.STYLE_NONE;
        }
        if (this.cascade.equals("all")) {
            return Cascades.STYLE_ALL;
        }
        if (this.cascade.equals("all-delete-orphan")) {
            return Cascades.STYLE_ALL_GC;
        }
        if (this.cascade.equals("none")) {
            return Cascades.STYLE_NONE;
        }
        if (this.cascade.equals("save-update")) {
            return Cascades.STYLE_SAVE_UPDATE;
        }
        if (this.cascade.equals("delete")) {
            return Cascades.STYLE_ONLY_DELETE;
        }
        throw new MappingException("Unsupported cascade style: " + this.cascade);
    }

    public String getCascade() {
        return this.cascade;
    }

    public void setCascade(String cascade) {
        this.cascade = cascade;
    }

    public void setUpdateable(boolean mutable) {
        this.updateable = mutable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public boolean isInsertable() {
        return this.insertable && !this.isFormula();
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public Formula getFormula() {
        return this.value.getFormula();
    }

    public boolean isFormula() {
        return this.getFormula() != null;
    }
}

