/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.persister;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.engine.Versioning;
import net.sf.hibernate.id.IdentifierGeneratorFactory;
import net.sf.hibernate.loader.EntityLoader;
import net.sf.hibernate.loader.SimpleEntityLoader;
import net.sf.hibernate.loader.UniqueEntityLoader;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.Subclass;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.persister.AbstractEntityPersister;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.sql.Delete;
import net.sf.hibernate.sql.InFragment;
import net.sf.hibernate.sql.Insert;
import net.sf.hibernate.sql.SelectFragment;
import net.sf.hibernate.sql.SimpleSelect;
import net.sf.hibernate.sql.Update;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.DiscriminatorType;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityPersister
extends AbstractEntityPersister
implements Queryable {
    private final SessionFactoryImplementor factory;
    private final String qualifiedTableName;
    private final String[] tableNames;
    private final boolean hasUpdateableColumns;
    private final Class[] subclassClosure;
    private final String sqlDeleteString;
    private final String sqlInsertString;
    private final String sqlUpdateString;
    private final String sqlIdentityInsertString;
    private final int[] propertyColumnSpans;
    private final boolean[] propertyDefinedOnSubclass;
    private final String[][] propertyColumnNames;
    private final String[][] propertyColumnAliases;
    private final String[] subclassColumnClosure;
    private final String[] subclassFormulaTemplateClosure;
    private final String[] subclassFormulaClosure;
    private final String[] subclassColumnAliasClosure;
    private final String[] subclassFormulaAliasClosure;
    private final String[][] subclassPropertyColumnNameClosure;
    private final String[] subclassPropertyNameClosure;
    private final Type[] subclassPropertyTypeClosure;
    private final int[] subclassPropertyEnableJoinedFetch;
    private final HashMap subclassesByDiscriminatorValue = new HashMap();
    private final boolean forceDiscriminator;
    private final String discriminatorColumnName;
    private final DiscriminatorType discriminatorType;
    private final String discriminatorSQLString;
    private final Map loaders = new HashMap();
    private final Map lockers = new HashMap();
    private static final String[] STRING_ARRAY = new String[0];
    private static final Type[] TYPE_ARRAY = new Type[0];
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$persister$EntityPersister == null ? (class$net$sf$hibernate$persister$EntityPersister = EntityPersister.class$("net.sf.hibernate.persister.EntityPersister")) : class$net$sf$hibernate$persister$EntityPersister));
    static /* synthetic */ Class class$net$sf$hibernate$persister$EntityPersister;

    public void postInstantiate(SessionFactoryImplementor factory) throws MappingException {
        this.initPropertyPaths(factory);
        HashMap<String, Type> mods = new HashMap<String, Type>();
        Iterator iter = this.typesByPropertyPath.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            Type type = (Type)e.getValue();
            if (!type.isEntityType()) continue;
            String path = (String)e.getKey();
            String[] columns = (String[])this.columnNamesByPropertyPath.get(path);
            if (columns.length == 0) {
                columns = this.getIdentifierColumnNames();
            }
            EntityType etype = (EntityType)type;
            Type idType = factory.getIdentifierType(etype.getPersistentClass());
            String idpath = path + '.' + "id";
            mods.put(idpath, idType);
            this.columnNamesByPropertyPath.put(idpath, columns);
            if (!idType.isComponentType() && !idType.isObjectType()) continue;
            AbstractComponentType actype = (AbstractComponentType)idType;
            String[] props = actype.getPropertyNames();
            Type[] subtypes = actype.getSubtypes();
            if (actype.getColumnSpan(factory) != columns.length) {
                throw new MappingException("broken mapping for: " + this.getClassName() + '.' + path);
            }
            int j = 0;
            for (int i = 0; i < props.length; ++i) {
                String subidpath = idpath + '.' + props[i];
                String[] componentColumns = new String[subtypes[i].getColumnSpan(factory)];
                for (int k = 0; k < componentColumns.length; ++k) {
                    componentColumns[k] = columns[j++];
                }
                this.columnNamesByPropertyPath.put(subidpath, componentColumns);
                mods.put(subidpath, actype.getSubtypes()[i]);
            }
        }
        this.typesByPropertyPath.putAll(mods);
        EntityLoader loader = new EntityLoader(this, factory);
        this.loaders.put(LockMode.NONE, loader);
        this.loaders.put(LockMode.READ, loader);
        String selectForUpdate = factory.getDialect().supportsForUpdate() ? this.generateSelectForUpdateString() : this.generateSelectString();
        this.loaders.put(LockMode.UPGRADE, new SimpleEntityLoader(this, selectForUpdate, LockMode.UPGRADE));
        String selectForUpdateNowait = factory.getDialect().supportsForUpdateNowait() ? this.generateSelectForUpdateNowaitString() : selectForUpdate;
        this.loaders.put(LockMode.UPGRADE_NOWAIT, new SimpleEntityLoader(this, selectForUpdateNowait, LockMode.UPGRADE_NOWAIT));
    }

    public boolean isDefinedOnSubclass(int i) {
        return this.propertyDefinedOnSubclass[i];
    }

    public String getDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    public int enableJoinedFetch(int i) {
        return this.subclassPropertyEnableJoinedFetch[i];
    }

    public Type getSubclassPropertyType(int i) {
        return this.subclassPropertyTypeClosure[i];
    }

    public String getSubclassPropertyName(int i) {
        return this.subclassPropertyNameClosure[i];
    }

    public int countSubclassProperties() {
        return this.subclassPropertyTypeClosure.length;
    }

    public String getTableName() {
        return this.qualifiedTableName;
    }

    public String[] getSubclassPropertyColumnNames(int i) {
        return this.subclassPropertyColumnNameClosure[i];
    }

    public String[] getPropertyColumnNames(int i) {
        return this.propertyColumnAliases[i];
    }

    public DiscriminatorType getDiscriminatorType() {
        return this.discriminatorType;
    }

    public String getDiscriminatorSQLString() {
        return this.discriminatorSQLString;
    }

    public Class[] getSubclassClosure() {
        return this.subclassClosure;
    }

    public Class getSubclassForDiscriminatorValue(Object value) {
        if (value == null) {
            return (Class)this.subclassesByDiscriminatorValue.get(ObjectUtils.NULL);
        }
        return (Class)this.subclassesByDiscriminatorValue.get(value);
    }

    public Serializable getIdentifierSpace() {
        return this.qualifiedTableName;
    }

    public Serializable[] getPropertySpaces() {
        return this.tableNames;
    }

    protected final String getSQLDeleteString() {
        return this.sqlDeleteString;
    }

    protected final String getSQLInsertString() {
        return this.sqlInsertString;
    }

    protected final String getSQLIdentityInsertString() {
        return this.sqlIdentityInsertString;
    }

    protected final String getSQLUpdateString() {
        return this.sqlUpdateString;
    }

    protected String generateDeleteString() {
        return new Delete().setTableName(this.getTableName()).setPrimaryKeyColumnNames(this.getIdentifierColumnNames()).setVersionColumnName(this.getVersionColumnName()).toStatementString();
    }

    protected String generateInsertString(boolean identityInsert, boolean[] includeProperty) {
        Insert insert = new Insert(this.getDialect()).setTableName(this.getTableName());
        for (int i = 0; i < this.hydrateSpan; ++i) {
            if (!includeProperty[i]) continue;
            insert.addColumns(this.propertyColumnNames[i]);
        }
        if (this.isPolymorphic()) {
            insert.addColumn(this.getDiscriminatorColumnName(), this.discriminatorSQLString);
        }
        if (!identityInsert) {
            insert.addColumns(this.getIdentifierColumnNames());
        } else {
            insert.addIdentityColumn(this.getIdentifierColumnNames()[0]);
        }
        return insert.toStatementString();
    }

    protected String generateSelectForUpdateString() {
        return this.generateSelectString() + " for update";
    }

    protected String generateSelectForUpdateNowaitString() {
        return this.generateSelectString() + " for update nowait";
    }

    protected String generateSelectString() {
        SimpleSelect select = new SimpleSelect().setTableName(this.getTableName()).addColumns(this.getIdentifierColumnNames()).addColumns(this.subclassColumnClosure, this.subclassColumnAliasClosure).addColumns(this.subclassFormulaClosure, this.subclassFormulaAliasClosure);
        if (this.hasSubclasses()) {
            select.addColumn(this.getDiscriminatorColumnName());
        }
        return select.addCondition(this.getIdentifierColumnNames(), "=?").toStatementString();
    }

    protected String generateUpdateString(boolean[] includeProperty) {
        Update update = new Update().setTableName(this.getTableName()).setPrimaryKeyColumnNames(this.getIdentifierColumnNames()).setVersionColumnName(this.getVersionColumnName());
        for (int i = 0; i < this.hydrateSpan; ++i) {
            if (!includeProperty[i]) continue;
            update.addColumns(this.propertyColumnNames[i]);
        }
        return update.toStatementString();
    }

    protected String generateLockString() {
        SimpleSelect select = new SimpleSelect().setTableName(this.getTableName()).addColumn(this.getIdentifierColumnNames()[0]).addCondition(this.getIdentifierColumnNames(), "=?");
        if (this.isVersioned()) {
            select.addWhereToken("and").addCondition(this.getVersionColumnName(), "=?");
        }
        return select.toStatementString();
    }

    protected int dehydrate(Serializable id, Object[] fields, boolean[] includeProperty, PreparedStatement st, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Dehydrating entity: " + this.getClassName() + '#' + id));
        }
        int index = 1;
        for (int j = 0; j < this.hydrateSpan; ++j) {
            if (!includeProperty[j]) continue;
            this.getPropertyTypes()[j].nullSafeSet(st, fields[j], index, session);
            index += this.propertyColumnSpans[j];
        }
        if (id != null) {
            this.getIdentifierType().nullSafeSet(st, id, index, session);
            index += this.getIdentifierColumnNames().length;
        }
        return index;
    }

    public Object load(Serializable id, Object optionalObject, LockMode lockMode, SessionImplementor session) throws HibernateException, SQLException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Materializing entity: " + this.getClassName() + '#' + id));
        }
        return ((UniqueEntityLoader)this.loaders.get(lockMode)).load(session, id, optionalObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Serializable id, Object version, Object object, LockMode lockMode, SessionImplementor session) throws HibernateException, SQLException {
        if (lockMode != LockMode.NONE) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Locking entity: " + this.getClassName() + '#' + id));
                if (this.isVersioned()) {
                    log.trace((Object)("Version: " + version));
                }
            }
            PreparedStatement st = session.getBatcher().prepareStatement((String)this.lockers.get(lockMode));
            try {
                this.getIdentifierType().nullSafeSet(st, id, 1, session);
                if (this.isVersioned()) {
                    this.getVersionType().nullSafeSet(st, version, this.getIdentifierColumnNames().length + 1, session);
                }
                ResultSet rs = st.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new StaleObjectStateException(this.getMappedClass(), id);
                    }
                }
                finally {
                    rs.close();
                }
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            finally {
                session.getBatcher().closeStatement(st);
            }
        }
    }

    public Serializable insert(Object[] fields, Object object, SessionImplementor session) throws SQLException, HibernateException {
        if (this.useDynamicInsert()) {
            boolean[] notNull = this.getNotNullInsertableColumns(fields);
            return this.insert(fields, notNull, this.generateInsertString(true, notNull), object, session);
        }
        return this.insert(fields, this.getPropertyInsertability(), this.getSQLIdentityInsertString(), object, session);
    }

    public void insert(Serializable id, Object[] fields, Object object, SessionImplementor session) throws SQLException, HibernateException {
        if (this.useDynamicInsert()) {
            boolean[] notNull = this.getNotNullInsertableColumns(fields);
            this.insert(id, fields, notNull, this.generateInsertString(false, notNull), object, session);
        } else {
            this.insert(id, fields, this.getPropertyInsertability(), this.getSQLInsertString(), object, session);
        }
    }

    public void insert(Serializable id, Object[] fields, boolean[] notNull, String sql, Object object, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserting entity: " + this.getClassName() + '#' + id));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + Versioning.getVersion(fields, this)));
            }
        }
        PreparedStatement statement = session.getBatcher().prepareBatchStatement(sql);
        try {
            this.dehydrate(id, fields, notNull, statement, session);
            session.getBatcher().addToBatch(1);
        }
        catch (SQLException sqle) {
            session.getBatcher().abortBatch(sqle);
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable insert(Object[] fields, boolean[] notNull, String sql, Object object, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserting entity: " + this.getClassName() + " (native id)"));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + Versioning.getVersion(fields, this)));
            }
        }
        PreparedStatement statement = session.getBatcher().prepareStatement(sql);
        try {
            this.dehydrate(null, fields, notNull, statement, session);
            statement.executeUpdate();
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
        finally {
            session.getBatcher().closeStatement(statement);
        }
        PreparedStatement idselect = session.getBatcher().prepareStatement(this.sqlIdentitySelect());
        try {
            Number id;
            ResultSet rs = idselect.executeQuery();
            try {
                if (!rs.next()) {
                    throw new HibernateException("The database returned no natively generated identity value");
                }
                id = IdentifierGeneratorFactory.get(rs, this.getIdentifierType().getReturnedClass());
            }
            finally {
                rs.close();
            }
            log.debug((Object)("Natively generated identity: " + id));
            Number number = id;
            return number;
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
        finally {
            session.getBatcher().closeStatement(idselect);
        }
    }

    public void delete(Serializable id, Object version, Object object, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deleting entity: " + this.getClassName() + '#' + id));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + version));
            }
        }
        PreparedStatement statement = this.isVersioned() ? session.getBatcher().prepareStatement(this.getSQLDeleteString()) : session.getBatcher().prepareBatchStatement(this.getSQLDeleteString());
        try {
            this.getIdentifierType().nullSafeSet(statement, id, 1, session);
            if (this.isVersioned()) {
                this.getVersionType().nullSafeSet(statement, version, this.getIdentifierColumnNames().length + 1, session);
                this.check(statement.executeUpdate(), id);
            } else {
                session.getBatcher().addToBatch(1);
            }
        }
        catch (SQLException sqle) {
            if (!this.isVersioned()) {
                session.getBatcher().abortBatch(sqle);
            } else {
                JDBCExceptionReporter.logExceptions(sqle);
            }
            throw sqle;
        }
        finally {
            if (this.isVersioned()) {
                session.getBatcher().closeStatement(statement);
            }
        }
    }

    public void update(Serializable id, Object[] fields, int[] dirtyFields, Object oldVersion, Object object, SessionImplementor session) throws SQLException, HibernateException {
        if (this.useDynamicUpdate() && dirtyFields != null) {
            boolean[] propsToUpdate = new boolean[this.hydrateSpan];
            for (int i = 0; i < this.hydrateSpan; ++i) {
                boolean dirty = false;
                for (int j = 0; j < dirtyFields.length; ++j) {
                    if (dirtyFields[j] != i) continue;
                    dirty = true;
                }
                propsToUpdate[i] = dirty || this.getVersionProperty() == i;
            }
            this.update(id, fields, propsToUpdate, oldVersion, object, this.generateUpdateString(propsToUpdate), session);
        } else {
            this.update(id, fields, this.getPropertyUpdateability(), oldVersion, object, this.getSQLUpdateString(), session);
        }
    }

    protected void update(Serializable id, Object[] fields, boolean[] includeProperty, Object oldVersion, Object object, String sql, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Updating entity: " + this.getClassName() + '#' + id));
            if (this.isVersioned()) {
                log.trace((Object)("Existing version: " + oldVersion + " -> New version: " + fields[this.getVersionProperty()]));
            }
        }
        if (!this.hasUpdateableColumns) {
            return;
        }
        PreparedStatement statement = this.isVersioned() ? session.getBatcher().prepareStatement(sql) : session.getBatcher().prepareBatchStatement(sql);
        try {
            int versionParam = this.dehydrate(id, fields, includeProperty, statement, session);
            if (this.isVersioned()) {
                this.getVersionType().nullSafeSet(statement, oldVersion, versionParam, session);
                this.check(statement.executeUpdate(), id);
            } else {
                session.getBatcher().addToBatch(1);
            }
        }
        catch (SQLException sqle) {
            if (!this.isVersioned()) {
                session.getBatcher().abortBatch(sqle);
            } else {
                JDBCExceptionReporter.logExceptions(sqle);
            }
            throw sqle;
        }
        finally {
            if (this.isVersioned()) {
                session.getBatcher().closeStatement(statement);
            }
        }
    }

    public EntityPersister(PersistentClass model, SessionFactoryImplementor factory) throws MappingException {
        super(model, factory);
        Object discriminatorValue;
        Class mappedClass = model.getPersistentClass();
        this.factory = factory;
        Table table = model.getRootTable();
        this.qualifiedTableName = table.getQualifiedName(this.getDialect(), factory.getDefaultSchema());
        this.tableNames = new String[]{this.qualifiedTableName};
        HashSet<String> distinctColumns = new HashSet<String>();
        if (model.isPolymorphic()) {
            Value d = model.getDiscriminator();
            if (d == null) {
                throw new MappingException("discriminator mapping required for polymorphic persistence");
            }
            this.forceDiscriminator = model.isForceDiscriminator();
            this.discriminatorColumnName = ((Column)d.getColumnIterator().next()).getQuotedName(this.getDialect());
            try {
                this.discriminatorType = (DiscriminatorType)model.getDiscriminator().getType();
                if ("null".equals(model.getDiscriminatorValue())) {
                    discriminatorValue = null;
                    this.discriminatorSQLString = "null";
                } else {
                    discriminatorValue = this.discriminatorType.stringToObject(model.getDiscriminatorValue());
                    this.discriminatorSQLString = this.discriminatorType.objectToSQLString(discriminatorValue);
                }
            }
            catch (ClassCastException cce) {
                throw new MappingException("Illegal discriminator type: " + model.getDiscriminator().getType().getClass().getName());
            }
            catch (Exception e) {
                throw new MappingException("Could not format discriminator value to SQL string", e);
            }
            distinctColumns.add(this.discriminatorColumnName);
        } else {
            this.forceDiscriminator = false;
            this.discriminatorColumnName = null;
            this.discriminatorType = null;
            discriminatorValue = null;
            this.discriminatorSQLString = null;
        }
        this.checkColumnDuplication(distinctColumns, model.getKey().getColumnIterator());
        this.propertyColumnNames = new String[this.hydrateSpan][];
        this.propertyColumnAliases = new String[this.hydrateSpan][];
        this.propertyColumnSpans = new int[this.hydrateSpan];
        HashSet<Property> thisClassProperties = new HashSet<Property>();
        Iterator iter = model.getPropertyClosureIterator();
        int i = 0;
        boolean foundColumn = false;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            thisClassProperties.add(prop);
            if (prop.isFormula()) {
                this.propertyColumnAliases[i] = new String[]{prop.getFormula().getAlias()};
                this.propertyColumnSpans[i] = 1;
            } else {
                int span;
                this.propertyColumnSpans[i] = span = prop.getColumnSpan();
                String[] colNames = new String[span];
                String[] colAliases = new String[span];
                Iterator colIter = prop.getColumnIterator();
                int j = 0;
                while (colIter.hasNext()) {
                    Column col = (Column)colIter.next();
                    colAliases[j] = col.getAlias();
                    colNames[j] = col.getQuotedName(this.getDialect());
                    ++j;
                    if (!prop.isUpdateable()) continue;
                    foundColumn = true;
                }
                this.propertyColumnNames[i] = colNames;
                this.propertyColumnAliases[i] = colAliases;
            }
            ++i;
            if (!prop.isUpdateable() && !prop.isInsertable()) continue;
            this.checkColumnDuplication(distinctColumns, prop.getColumnIterator());
        }
        this.hasUpdateableColumns = foundColumn;
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> formulas = new ArrayList<String>();
        ArrayList<String> formulaTemplates = new ArrayList<String>();
        ArrayList<Type> types = new ArrayList<Type>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String[]> propColumns = new ArrayList<String[]>();
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<String> formulaAliases = new ArrayList<String>();
        ArrayList<Integer> joinedFetchesList = new ArrayList<Integer>();
        ArrayList<Boolean> definedBySubclass = new ArrayList<Boolean>();
        iter = model.getSubclassPropertyClosureIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            names.add(prop.getName());
            definedBySubclass.add(new Boolean(!thisClassProperties.contains(prop)));
            if (prop.isFormula()) {
                formulas.add(prop.getFormula().getFormula());
                formulaTemplates.add(prop.getFormula().getTemplate(this.getDialect()));
                propColumns.add(new String[0]);
                formulaAliases.add(prop.getFormula().getAlias());
                types.add(prop.getType());
            } else {
                Iterator colIter = prop.getColumnIterator();
                String[] cols = new String[prop.getColumnSpan()];
                types.add(prop.getType());
                int l = 0;
                while (colIter.hasNext()) {
                    Column col = (Column)colIter.next();
                    columns.add(col.getQuotedName(this.getDialect()));
                    aliases.add(col.getAlias());
                    cols[l++] = col.getQuotedName(this.getDialect());
                }
                propColumns.add(cols);
            }
            joinedFetchesList.add(new Integer(prop.getValue().getOuterJoinFetchSetting()));
        }
        this.subclassColumnClosure = columns.toArray(STRING_ARRAY);
        this.subclassFormulaClosure = formulas.toArray(STRING_ARRAY);
        this.subclassFormulaTemplateClosure = formulaTemplates.toArray(STRING_ARRAY);
        this.subclassPropertyTypeClosure = types.toArray(TYPE_ARRAY);
        this.subclassColumnAliasClosure = aliases.toArray(STRING_ARRAY);
        this.subclassFormulaAliasClosure = formulaAliases.toArray(STRING_ARRAY);
        this.subclassPropertyNameClosure = names.toArray(STRING_ARRAY);
        this.subclassPropertyColumnNameClosure = (String[][])propColumns.toArray((T[])new String[propColumns.size()][]);
        this.subclassPropertyEnableJoinedFetch = new int[joinedFetchesList.size()];
        iter = joinedFetchesList.iterator();
        int j = 0;
        while (iter.hasNext()) {
            this.subclassPropertyEnableJoinedFetch[j++] = (Integer)iter.next();
        }
        this.propertyDefinedOnSubclass = new boolean[definedBySubclass.size()];
        iter = definedBySubclass.iterator();
        j = 0;
        while (iter.hasNext()) {
            this.propertyDefinedOnSubclass[j++] = (Boolean)iter.next();
        }
        this.sqlDeleteString = this.generateDeleteString();
        this.sqlInsertString = this.generateInsertString(false, this.getPropertyInsertability());
        this.sqlIdentityInsertString = this.isIdentifierAssignedByInsert() ? this.generateInsertString(true, this.getPropertyInsertability()) : null;
        this.sqlUpdateString = this.generateUpdateString(this.getPropertyUpdateability());
        String lockString = this.generateLockString();
        this.lockers.put(LockMode.READ, lockString);
        String lockExclusiveString = this.getDialect().supportsForUpdate() ? lockString + " for update" : lockString;
        this.lockers.put(LockMode.UPGRADE, lockExclusiveString);
        String lockExclusiveNowaitString = this.getDialect().supportsForUpdateNowait() ? lockString + " for update nowait" : lockExclusiveString;
        this.lockers.put(LockMode.UPGRADE_NOWAIT, lockExclusiveNowaitString);
        int subclassSpan = model.getSubclassSpan() + 1;
        this.subclassClosure = new Class[subclassSpan];
        this.subclassClosure[0] = mappedClass;
        if (model.isPolymorphic()) {
            if (discriminatorValue == null) {
                this.subclassesByDiscriminatorValue.put(ObjectUtils.NULL, mappedClass);
            } else {
                this.subclassesByDiscriminatorValue.put(discriminatorValue, mappedClass);
            }
        }
        if (model.isPolymorphic()) {
            iter = model.getSubclassIterator();
            int k = 1;
            while (iter.hasNext()) {
                Subclass sc = (Subclass)iter.next();
                this.subclassClosure[k++] = sc.getPersistentClass();
                if ("null".equals(sc.getDiscriminatorValue())) {
                    this.subclassesByDiscriminatorValue.put(ObjectUtils.NULL, sc.getPersistentClass());
                    continue;
                }
                try {
                    this.subclassesByDiscriminatorValue.put(this.discriminatorType.stringToObject(sc.getDiscriminatorValue()), sc.getPersistentClass());
                }
                catch (Exception e) {
                    throw new MappingException("Error parsing discriminator value", e);
                }
            }
        }
    }

    private void initPropertyPaths(Mapping mapping) throws MappingException {
        Type[] propertyTypes = this.getPropertyTypes();
        String[] propertyNames = this.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            this.initPropertyPaths(propertyNames[i], propertyTypes[i], this.propertyColumnNames[i], mapping);
        }
        String idProp = this.getIdentifierPropertyName();
        if (idProp != null) {
            this.initPropertyPaths(idProp, this.getIdentifierType(), this.getIdentifierColumnNames(), mapping);
        }
        if (this.hasEmbeddedIdentifier()) {
            this.initPropertyPaths(null, this.getIdentifierType(), this.getIdentifierColumnNames(), mapping);
        }
        this.initPropertyPaths("id", this.getIdentifierType(), this.getIdentifierColumnNames(), mapping);
        if (this.isPolymorphic()) {
            this.typesByPropertyPath.put("class", this.getDiscriminatorType());
            this.columnNamesByPropertyPath.put("class", new String[]{this.getDiscriminatorColumnName()});
        }
    }

    private void initPropertyPaths(String propertyName, Type propertyType, String[] columns, Mapping mapping) throws MappingException {
        if (propertyName != null) {
            this.typesByPropertyPath.put(propertyName, propertyType);
            this.columnNamesByPropertyPath.put(propertyName, columns);
        }
        if (propertyType.isComponentType()) {
            AbstractComponentType compType = (AbstractComponentType)propertyType;
            String[] props = compType.getPropertyNames();
            Type[] types = compType.getSubtypes();
            int count = 0;
            for (int k = 0; k < props.length; ++k) {
                int len = types[k].getColumnSpan(mapping);
                String[] slice = new String[len];
                for (int j = 0; j < len; ++j) {
                    slice[j] = columns[count++];
                }
                String path = propertyName == null ? props[k] : propertyName + '.' + props[k];
                this.initPropertyPaths(path, types[k], slice, mapping);
            }
        }
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public String fromTableFragment(String name) {
        return this.getTableName() + ' ' + name;
    }

    public String queryWhereFragment(String name, boolean innerJoin, boolean includeSubclasses) throws MappingException {
        if (innerJoin && (this.forceDiscriminator || this.isInherited())) {
            InFragment frag = new InFragment().setColumn(name, this.getDiscriminatorColumnName());
            Class[] subclasses = this.getSubclassClosure();
            for (int i = 0; i < subclasses.length; ++i) {
                frag.addValue(((Queryable)this.factory.getPersister(subclasses[i])).getDiscriminatorSQLString());
            }
            StringBuffer buf = new StringBuffer(50).append(" and ").append(frag.toFragmentString());
            if (this.hasWhere()) {
                buf.append(" and ").append(this.getSQLWhereString(name));
            }
            return buf.toString();
        }
        return this.hasWhere() ? " and " + this.getSQLWhereString(name) : "";
    }

    public String[] toColumns(String name, String property) throws QueryException {
        String[] cols = this.getPropertyColumnNames(property);
        if (cols == null) {
            throw new QueryException("unresolved property: " + property);
        }
        if (cols.length == 0) {
            cols = this.getIdentifierColumnNames();
        }
        return StringHelper.prefix(cols, name + '.');
    }

    public String[] toColumns(String name, int i) {
        try {
            return StringHelper.prefix(this.subclassPropertyColumnNameClosure[i], name + '.');
        }
        catch (Exception e) {
            System.out.println(name + i);
            return null;
        }
    }

    public String getSubclassPropertyTableName(int i) {
        return this.qualifiedTableName;
    }

    public String propertySelectFragment(String name, String suffix) {
        SelectFragment frag = new SelectFragment().setSuffix(suffix);
        if (this.hasSubclasses()) {
            frag.addColumn(name, this.getDiscriminatorColumnName());
        }
        return frag.addColumns(name, this.subclassColumnClosure, this.subclassColumnAliasClosure).addFormulas(name, this.subclassFormulaTemplateClosure, this.subclassFormulaAliasClosure).toFragmentString();
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return "";
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

