/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchemaUpdate {
    Log log = LogFactory.getLog(this.getClass());
    private ConnectionProvider cp;
    Configuration configuration;
    Dialect dialect;

    public SchemaUpdate(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaUpdate(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.configuration = cfg;
        this.dialect = Dialect.getDialect(connectionProperties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)connectionProperties);
        this.cp = ConnectionProviderFactory.newConnectionProvider(props);
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            String propFile = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                        continue;
                    }
                    if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                        continue;
                    }
                    if (!args[i].startsWith("--config=")) continue;
                    cfg.configure(args[i].substring(9));
                    continue;
                }
                cfg.addFile(args[i]);
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.load(new FileInputStream(propFile));
                new SchemaUpdate(cfg, props).execute(script);
            } else {
                new SchemaUpdate(cfg).execute(script);
            }
        }
        catch (Exception e) {
            System.err.println("Error updating schema " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void execute(boolean script) throws HibernateException {
        Statement stmt;
        DatabaseMetadata meta;
        Connection connection;
        try {
            connection = this.cp.getConnection();
            connection.commit();
            connection.setAutoCommit(true);
            meta = new DatabaseMetadata(connection, this.dialect);
            stmt = connection.createStatement();
        }
        catch (SQLException sqle) {
            throw new HibernateException("could not get database metadata", sqle);
        }
        boolean jdbc2 = false;
        String[] createSQL = this.configuration.generateSchemaUpdateScript(this.dialect, meta);
        for (int j = 0; j < createSQL.length; ++j) {
            String sql = createSQL[j];
            try {
                if (script) {
                    System.out.println(createSQL[j]);
                }
                if (jdbc2) {
                    stmt.addBatch(sql);
                    continue;
                }
                stmt.executeUpdate(sql);
                continue;
            }
            catch (SQLException e) {
                this.log.error((Object)("Error while executing " + sql), (Throwable)e);
            }
        }
        try {
            if (jdbc2) {
                stmt.executeBatch();
            }
            stmt.close();
            connection.close();
        }
        catch (SQLException sqle) {
            throw new HibernateException("could not complete update", sqle);
        }
    }
}

