/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ArrayHelper {
    public static String[] toStringArray(Object[] objects) {
        int length = objects.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = objects[i].toString();
        }
        return result;
    }

    public static String[] fillArray(String str, int length) {
        Object[] result = new String[length];
        Arrays.fill(result, str);
        return result;
    }

    public static String[] toStringArray(Collection coll) {
        return ArrayHelper.toStringArray(coll.toArray());
    }

    public static int[] toIntArray(Collection coll) {
        Iterator iter = coll.iterator();
        int[] arr = new int[coll.size()];
        int i = 0;
        while (iter.hasNext()) {
            arr[i++] = (Integer)iter.next();
        }
        return arr;
    }

    public static Object[] typecast(Object[] array, Object[] to) {
        return Arrays.asList(array).toArray(to);
    }

    public static List toList(Object array) {
        if (array instanceof Object[]) {
            return Arrays.asList((Object[])array);
        }
        int size = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    public static String[] slice(String[] strings, int begin, int length) {
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = strings[begin + i];
        }
        return result;
    }

    public static Object[] slice(Object[] objects, int begin, int length) {
        Object[] result = new Object[length];
        for (int i = 0; i < length; ++i) {
            result[i] = objects[begin + i];
        }
        return result;
    }

    public static List toList(Iterator iter) {
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static String[] join(String[] x, String[] y) {
        int i;
        String[] result = new String[x.length + y.length];
        for (i = 0; i < x.length; ++i) {
            result[i] = x[i];
        }
        for (i = 0; i < y.length; ++i) {
            result[i + x.length] = y[i];
        }
        return result;
    }

    public static int[] join(int[] x, int[] y) {
        int i;
        int[] result = new int[x.length + y.length];
        for (i = 0; i < x.length; ++i) {
            result[i] = x[i];
        }
        for (i = 0; i < y.length; ++i) {
            result[i + x.length] = y[i];
        }
        return result;
    }

    private ArrayHelper() {
    }
}

