/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.hibernate.Databinder;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.proxy.HibernateProxy;
import net.sf.hibernate.proxy.HibernateProxyHelper;
import net.sf.hibernate.proxy.LazyInitializer;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.BagType;
import net.sf.hibernate.type.ListType;
import net.sf.hibernate.type.MapType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.SetType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XMLDatabinder
implements Databinder {
    private SessionFactoryImplementor factory;
    private List objects = new ArrayList();
    private Set associatedObjects;
    private Set processedObjects;
    private Transformer transform;
    private boolean initializeLazy = false;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$xml$XMLDatabinder == null ? (class$net$sf$hibernate$xml$XMLDatabinder = XMLDatabinder.class$("net.sf.hibernate.xml.XMLDatabinder")) : class$net$sf$hibernate$xml$XMLDatabinder));
    static /* synthetic */ Class class$net$sf$hibernate$xml$XMLDatabinder;

    public XMLDatabinder(SessionFactoryImplementor factory, Transformer transform) {
        this.factory = factory;
        this.transform = transform;
    }

    private ClassPersister getPersister(Class clazz) throws MappingException {
        return this.factory.getPersister(clazz);
    }

    public void setInitializeLazy(boolean initializeLazy) {
        this.initializeLazy = initializeLazy;
    }

    private Document toDocument() throws HibernateException {
        this.associatedObjects = new HashSet();
        this.processedObjects = new HashSet();
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("hibernate-generic");
        root.setAttributeValue("datetime", Hibernate.TIMESTAMP.toXML(new Date(), this.factory));
        Iterator iter = null;
        while (true) {
            iter = this.objects.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                Element objectElem = root.addElement("object");
                if ((object = this.maybeInitializeIfProxy(object, objectElem)) == null) continue;
                String className = object.getClass().getName();
                objectElem.setAttributeValue("class", StringHelper.unqualify(className));
                objectElem.setAttributeValue("package", StringHelper.qualifier(className));
                ClassPersister persister = this.getPersister(object.getClass());
                if (persister.hasIdentifierProperty()) {
                    Type idType = persister.getIdentifierType();
                    String idValue = idType.toXML(persister.getIdentifier(object), this.factory);
                    Element idElem = objectElem.addElement("uid");
                    idElem.setAttributeValue("name", persister.getIdentifierPropertyName());
                    idElem.setAttributeValue("type", idType.getName());
                    idElem.setText(idValue);
                }
                Type[] types = persister.getPropertyTypes();
                Object[] values = persister.getPropertyValues(object);
                String[] names = persister.getPropertyNames();
                for (int i = 0; i < types.length; ++i) {
                    objectElem.add(this.renderProperty(names[i], types[i], values[i], "component", "property", "collection", true));
                }
            }
            if (this.associatedObjects.size() == 0) break;
            this.processedObjects.addAll(this.objects);
            this.objects = new ArrayList(this.associatedObjects);
            this.associatedObjects = new HashSet();
        }
        return doc;
    }

    private Object maybeInitializeIfProxy(Object object, Element element) throws HibernateException {
        if (!(object instanceof HibernateProxy)) {
            return object;
        }
        LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object);
        if (li.isUninitialized() && !this.initializeLazy) {
            element.setAttributeValue("proxy", "uninitialized");
            element.setAttributeValue("uid", li.getIdentifier().toString());
            return null;
        }
        if (li.isUninitialized()) {
            element.setAttributeValue("proxy", "now-initialized");
        } else {
            element.setAttributeValue("proxy", "initialized");
        }
        return li.getImplementation();
    }

    public String toGenericXML() throws HibernateException {
        StringWriter writer = new StringWriter();
        XMLWriter outputter = new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
        try {
            outputter.write(this.toDocument());
        }
        catch (IOException ioe) {
            throw new HibernateException("could not XML to String", ioe);
        }
        return writer.toString();
    }

    private Element renderProperty(String name, Type type, Object value, String componentName, String propertyName, String collectionName, boolean doType) throws HibernateException {
        if (type.isComponentType()) {
            AbstractComponentType componenttype = (AbstractComponentType)type;
            Element componentElem = DocumentHelper.createElement((String)componentName);
            if (name != null) {
                componentElem.setAttributeValue("name", name);
            }
            if (doType) {
                componentElem.setAttributeValue("class", type.getName());
            }
            if (value != null) {
                String[] properties = componenttype.getPropertyNames();
                Object[] subvalues = componenttype.getPropertyValues(value, null);
                Type[] subtypes = componenttype.getSubtypes();
                for (int j = 0; j < properties.length; ++j) {
                    componentElem.add(this.renderProperty(properties[j], subtypes[j], subvalues[j], "component", "property", "collection", true));
                }
            }
            return componentElem;
        }
        if (type.isPersistentCollectionType()) {
            PersistentCollectionType collectiontype = (PersistentCollectionType)type;
            String role = collectiontype.getRole();
            CollectionPersister persister = this.factory.getCollectionPersister(role);
            Element collectionElem = DocumentHelper.createElement((String)collectionName);
            if (name != null) {
                collectionElem.setAttributeValue("name", name);
            }
            if (persister.isArray()) {
                collectionElem.setName("array");
            } else if (doType) {
                collectionElem.setAttributeValue("class", type.getName());
            }
            Type elemType = persister.getElementType();
            collectionElem.setAttributeValue("element-type", elemType.getName());
            if (value != null) {
                if (persister.isArray()) {
                    collectionElem.setAttributeValue("index-type", "integer");
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        Element elemElement = this.renderProperty(null, elemType, Array.get(value, i), "composite-element", "element", "subcollection", false);
                        elemElement.setAttributeValue("index", Integer.toString(i));
                        collectionElem.add(elemElement);
                    }
                } else {
                    PersistentCollection persistentCollection = (PersistentCollection)value;
                    if (persister.isLazy() && !this.initializeLazy && !persistentCollection.wasInitialized()) {
                        collectionElem.setAttributeValue("lazy", "uninitialized");
                    } else {
                        if (persistentCollection.wasInitialized()) {
                            collectionElem.setAttributeValue("lazy", "initialized");
                        } else {
                            collectionElem.setAttributeValue("lazy", "now-initialized");
                        }
                        if (type instanceof ListType) {
                            collectionElem.setAttributeValue("index-type", "integer");
                            Iterator iter = ((List)value).iterator();
                            int i = 0;
                            while (iter.hasNext()) {
                                Element elemElement = this.renderProperty(null, elemType, iter.next(), "composite-element", "element", "subcollection", false);
                                elemElement.setAttributeValue("index", Integer.toString(i++));
                                collectionElem.add(elemElement);
                            }
                        } else if (type instanceof SetType || type instanceof BagType) {
                            Iterator iter = ((Collection)value).iterator();
                            while (iter.hasNext()) {
                                Element elemElement = this.renderProperty(null, elemType, iter.next(), "composite-element", "element", "subcollection", false);
                                collectionElem.add(elemElement);
                            }
                        } else if (type instanceof MapType) {
                            Type indexType = persister.getIndexType();
                            collectionElem.setAttributeValue("index-type", indexType.getName());
                            Iterator iter = ((Map)value).entrySet().iterator();
                            while (iter.hasNext()) {
                                Map.Entry e = iter.next();
                                Object idx = e.getKey();
                                Element elemElement = this.renderProperty(null, elemType, e.getValue(), "composite-element", "element", "subcollection", false);
                                elemElement.setAttributeValue("index", indexType.toXML(idx, this.factory));
                                collectionElem.add(elemElement);
                            }
                        }
                    }
                }
            }
            return collectionElem;
        }
        if (type.isEntityType()) {
            Element referenceElem = DocumentHelper.createElement((String)propertyName);
            if (name != null) {
                referenceElem.setAttributeValue("name", name);
            }
            if ((value = this.maybeInitializeIfProxy(value, referenceElem)) != null) {
                if (this.getPersister(value.getClass()).hasIdentifierPropertyOrEmbeddedCompositeIdentifier()) {
                    referenceElem.setAttributeValue("uid", type.toXML(value, this.factory));
                }
                String className = value.getClass().getName();
                referenceElem.setAttributeValue("class", StringHelper.unqualify(className));
                referenceElem.setAttributeValue("package", StringHelper.qualifier(className));
                if (!this.processedObjects.contains(value) && !this.objects.contains(value)) {
                    this.associatedObjects.add(value);
                }
            }
            if (doType) {
                referenceElem.setAttributeValue("type", type.getName());
            }
            return referenceElem;
        }
        Element propertyElem = DocumentHelper.createElement((String)propertyName);
        if (name != null) {
            propertyElem.setAttributeValue("name", name);
        }
        if (value != null) {
            propertyElem.setText(type.toXML(value, this.factory));
        }
        if (doType) {
            propertyElem.setAttributeValue("type", type.getName());
        }
        return propertyElem;
    }

    public String toXML() throws HibernateException, TransformerException {
        DocumentSource source = new DocumentSource(this.toDocument());
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        this.transform.setErrorListener(new ErrorListener(){

            public void warning(TransformerException te) throws TransformerException {
                log.warn((Object)("problem transforming to Custom XML: " + te.getMessageAndLocation()), (Throwable)te);
            }

            public void error(TransformerException te) throws TransformerException {
                log.error((Object)("problem transforming to Custom XML: " + te.getMessageAndLocation()), (Throwable)te);
            }

            public void fatalError(TransformerException te) throws TransformerException {
                this.error(te);
            }
        });
        this.transform.transform((Source)source, result);
        return writer.toString();
    }

    public org.w3c.dom.Document toDOM() throws HibernateException, TransformerException {
        DocumentSource source = new DocumentSource(this.toDocument());
        DOMResult result = new DOMResult();
        this.transform.transform((Source)source, result);
        return (org.w3c.dom.Document)result.getNode();
    }

    public Databinder bind(Object object) {
        this.objects.add(object);
        return this;
    }

    public Databinder bindAll(Collection objects) {
        objects.addAll(objects);
        return this;
    }

    public org.w3c.dom.Document toGenericDOM() throws HibernateException {
        DOMWriter outputter = new DOMWriter();
        try {
            return outputter.write(this.toDocument());
        }
        catch (DocumentException jde) {
            throw new HibernateException("Could not transform XML to a DOM", jde);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

