/*
 * Decompiled with CFR 0.152.
 */
package middlegen.plugins.hibernate;

import middlegen.Column;
import middlegen.Util;
import middlegen.javax.JavaColumn;
import middlegen.plugins.hibernate.HibernatePlugin;
import middlegen.util.BooleanNode;

public class HibernateColumn
extends JavaColumn {
    private BooleanNode _updateable = BooleanNode.createRoot((boolean)true);
    private BooleanNode _insertable = BooleanNode.createRoot((boolean)true);
    private BooleanNode _incToString = BooleanNode.createRoot((boolean)false);
    private BooleanNode _genProperty = BooleanNode.createRoot((boolean)true);
    private String _getScope;
    private String _setScope;
    private String _fieldScope;
    private String _fieldDescription;
    private String _beanPropertyType;
    private String _columnSpecialty;

    public HibernateColumn(Column column) {
        super(column);
    }

    public void setUpdateable(boolean bl) {
        this.setPrefsValue("updateable", Util.string((boolean)bl));
        this._updateable.setValue(bl);
    }

    public void setInsertable(boolean bl) {
        this.setPrefsValue("insertable", Util.string((boolean)bl));
        this._insertable.setValue(bl);
    }

    public void setIncludeToString(boolean bl) {
        this.setPrefsValue("inctostring", Util.string((boolean)bl));
        this._incToString.setValue(bl);
    }

    public void setGenProperty(boolean bl) {
        this.setPrefsValue("genproperty", Util.string((boolean)bl));
        this._genProperty.setValue(bl);
    }

    public void setFieldGetScope(String string) {
        this.setPrefsValue("getscope", string);
        this._getScope = string;
    }

    public void setFieldSetScope(String string) {
        this.setPrefsValue("setscope", string);
        this._setScope = string;
    }

    public void setFieldScope(String string) {
        this.setPrefsValue("fieldscope", string);
        this._fieldScope = string;
    }

    public void setFieldDescription(String string) {
        this.setPrefsValue("description", string);
        this._fieldDescription = string;
    }

    public void setColumnSpecialty(String string) {
        this.setPrefsValue("columnspecialty", string);
        this._columnSpecialty = string;
    }

    public void setBeanPropertyType(String string) {
        this.setPrefsValue("beanpropertytype", string);
        this._beanPropertyType = string;
    }

    public boolean isUpdateable() {
        return this._updateable.isCompletelyTrue();
    }

    public boolean isInsertable() {
        return this._insertable.isCompletelyTrue();
    }

    public boolean isIncludeToString() {
        return this._incToString.isCompletelyTrue();
    }

    public boolean isGenProperty() {
        return this._genProperty.isCompletelyTrue();
    }

    public BooleanNode getUpdateableNode() {
        return this._updateable;
    }

    public BooleanNode getInsertableNode() {
        return this._insertable;
    }

    public BooleanNode getIncludeToStringNode() {
        return this._incToString;
    }

    public BooleanNode getGenPropertyNode() {
        return this._genProperty;
    }

    public String getFieldScope() {
        return this._fieldScope.trim();
    }

    public String getFieldGetScope() {
        return this._getScope.trim();
    }

    public String getFieldSetScope() {
        return this._setScope.trim();
    }

    public String getFieldDescription() {
        return this._fieldDescription.trim();
    }

    public String getBeanPropertyType() {
        return this._beanPropertyType.trim();
    }

    public String getColumnSpecialty() {
        return this._columnSpecialty.trim();
    }

    public String getParseMethod() {
        if (this.isPrimitive()) {
            return this.getClassForPrimitive() + ".parse" + Util.capitalise((String)this.getJavaType());
        }
        if ("java.lang.String".equals(this.getJavaType())) {
            return "";
        }
        return "new " + this.getJavaType();
    }

    public boolean isSized() {
        return super.getSize() != 0;
    }

    public boolean isSpecialtyProperty() {
        return this._columnSpecialty.equals("property");
    }

    public boolean isSpecialtyVersionProperty() {
        return this._columnSpecialty.equals("version");
    }

    public boolean isSpecialtyTimestampProperty() {
        return this._columnSpecialty.equals("timestamp");
    }

    public boolean isMetaData() {
        return this.isIncludeToString() || this.isFieldScopeName() || this.isFieldGetScopeName() || this.isFieldSetScopeName() || this.isFieldDescriptionName() || this.isBeanPropertyTypeName() || !this.isGenProperty();
    }

    public boolean isFieldScopeName() {
        return this._fieldScope != null && this._fieldScope.trim().length() != 0 && !this._fieldScope.equals("private");
    }

    public boolean isFieldGetScopeName() {
        return this._getScope != null && this._getScope.trim().length() != 0 && !this._getScope.equals("public");
    }

    public boolean isFieldSetScopeName() {
        return this._setScope != null && this._setScope.trim().length() != 0 && !this._setScope.equals("public");
    }

    public boolean isFieldDescriptionName() {
        return this._fieldDescription != null && this._fieldDescription.trim().length() != 0;
    }

    public boolean isBeanPropertyTypeName() {
        return this._beanPropertyType != null && !this._beanPropertyType.equals("unbound");
    }

    protected void init() {
        super.init();
        HibernatePlugin hibernatePlugin = (HibernatePlugin)this.getPlugin();
        this._updateable.setValue(hibernatePlugin.isColumnsUpdateable());
        if (this.getPrefsValue("updateable") != null) {
            this.setUpdateable(Util.bool((String)this.getPrefsValue("updateable")));
        }
        this._insertable.setValue(hibernatePlugin.isColumnsInsertable());
        if (this.getPrefsValue("insertable") != null) {
            this.setInsertable(Util.bool((String)this.getPrefsValue("insertable")));
        }
        this._incToString.setValue(hibernatePlugin.isColumnsIncludeToString());
        if (this.getPrefsValue("inctostring") != null) {
            this.setIncludeToString(Util.bool((String)this.getPrefsValue("inctostring")));
        }
        this._genProperty.setValue(hibernatePlugin.isColumnsGenProperty());
        if (this.getPrefsValue("genproperty") != null) {
            this.setGenProperty(Util.bool((String)this.getPrefsValue("genproperty")));
        }
        this._fieldScope = hibernatePlugin.getFieldScope();
        if (this.getPrefsValue("fieldscope") != null) {
            this.setFieldScope(this.getPrefsValue("fieldscope"));
        }
        this._getScope = hibernatePlugin.getFieldGetScope();
        if (this.getPrefsValue("getscope") != null) {
            this.setFieldGetScope(this.getPrefsValue("getscope"));
        }
        this._setScope = hibernatePlugin.getFieldSetScope();
        if (this.getPrefsValue("setscope") != null) {
            this.setFieldSetScope(this.getPrefsValue("setscope"));
        }
        this._fieldDescription = hibernatePlugin.getFieldDescription();
        if (this.getPrefsValue("description") != null) {
            this.setFieldDescription(this.getPrefsValue("description"));
        }
        this._beanPropertyType = hibernatePlugin.getBeanPropertyType();
        if (this.getPrefsValue("beanpropertytype") != null) {
            this.setBeanPropertyType(this.getPrefsValue("beanpropertytype"));
        }
        this._columnSpecialty = "property";
        if (this.getPrefsValue("columnspecialty") != null) {
            this.setColumnSpecialty(this.getPrefsValue("columnspecialty"));
        }
    }
}

