/*
 * Decompiled with CFR 0.152.
 */
package middlegen.plugins.hibernate.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import middlegen.Table;
import middlegen.plugins.hibernate.HibernateTable;
import middlegen.swing.BooleanNodeCheckBox;
import middlegen.swing.JTableSettingsPanel;

public class JHibernateTableSettingsPanel
extends JTableSettingsPanel {
    private final JLabel _beanKeyGeneratorLabel = new JLabel("  Key generator");
    private final JLabel _beanNameLabel = new JLabel("  Domain class name");
    private final JTextField _beanNameField = new JTextField();
    private final JLabel _schemaNameLabel = new JLabel("  Schema name");
    private final JTextField _schemaNameField = new JTextField();
    private final JLabel _persisterLabel = new JLabel("  Persister");
    private final JTextField _persisterField = new JTextField();
    private final JLabel _classDescriptionLabel = new JLabel("  Class description");
    private final JTextField _classDescriptionField = new JTextField();
    private final JLabel _extendsLabel = new JLabel("  Extends");
    private final JTextField _extendsField = new JTextField();
    private final BooleanNodeCheckBox _implementLifecycleCheckBox = new BooleanNodeCheckBox("Implement the Lifecycle interface", null);
    private final BooleanNodeCheckBox _implementValidatableCheckBox = new BooleanNodeCheckBox("Implement the Validatable interface", null);
    private final BooleanNodeCheckBox _proxyCheckBox = new BooleanNodeCheckBox("Enable proxies", null);
    private final BooleanNodeCheckBox _mutableCheckBox = new BooleanNodeCheckBox("Mutable", null);
    private final BooleanNodeCheckBox _dynamicUpdateCheckBox = new BooleanNodeCheckBox("Dynamic Update", null);
    private final JRadioButton _publicRadioButton = new JRadioButton("public");
    private final JRadioButton _protectedRadioButton = new JRadioButton("protected");
    private final JRadioButton _privateRadioButton = new JRadioButton("private");
    private final JLabel _classScopeLabel = new JLabel("  Class scope");
    private final JLabel _implementsLabel = new JLabel("  Manage external class interfaces");
    private final JTextField _sourceTextField = new JTextField();
    private final DefaultComboBoxModel _implementsComboModel = new DefaultComboBoxModel();
    private final JComboBox _implementsComboBox = new JComboBox(this._implementsComboModel);
    private final JComboBox _beanKeyGeneratorCombo = new JComboBox();
    private final JTextField _beanKeyGeneratorField = new JTextField();
    private final DocumentListener _identityClassListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this.updateTable(JHibernateTableSettingsPanel.this._beanNameField.getText());
        }
    };
    private final DocumentListener _schemaDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this._currentTable.setDatabaseSchema(JHibernateTableSettingsPanel.this._schemaNameField.getText());
        }
    };
    private final DocumentListener _persisterDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this._currentTable.setPersister(JHibernateTableSettingsPanel.this._persisterField.getText());
        }
    };
    private final DocumentListener _classDescriptionDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this._currentTable.setClassDescription(JHibernateTableSettingsPanel.this._classDescriptionField.getText());
        }
    };
    private final DocumentListener _extendsDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this._currentTable.setExtends(JHibernateTableSettingsPanel.this._extendsField.getText());
        }
    };
    private final DocumentListener _keyGeneratorArgListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            JHibernateTableSettingsPanel.this._currentTable.setKeyGeneratorArg(JHibernateTableSettingsPanel.this._beanKeyGeneratorField.getText());
        }
    };
    private final ActionListener toggleBtnMutableAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JHibernateTableSettingsPanel.this._currentTable.setMutable(((BooleanNodeCheckBox)actionEvent.getSource()).isSelected());
        }
    };
    private final ActionListener toggleBtnProxyAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JHibernateTableSettingsPanel.this._currentTable.setProxy(((BooleanNodeCheckBox)actionEvent.getSource()).isSelected());
        }
    };
    private final ActionListener toggleBtnDynamicUpdateAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JHibernateTableSettingsPanel.this._currentTable.setDynamicUpdate(((BooleanNodeCheckBox)actionEvent.getSource()).isSelected());
        }
    };
    private final ActionListener toggleBtnLifecycleAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JHibernateTableSettingsPanel.this._currentTable.setImplementLifecycle(((BooleanNodeCheckBox)actionEvent.getSource()).isSelected());
        }
    };
    private final ActionListener toggleBtnValidatableAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JHibernateTableSettingsPanel.this._currentTable.setImplementValidatable(((BooleanNodeCheckBox)actionEvent.getSource()).isSelected());
        }
    };
    private final ActionListener keyGeneratorComboAction = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JHibernateTableSettingsPanel.this._currentTable.setKeyGenerator((String)JHibernateTableSettingsPanel.this._beanKeyGeneratorCombo.getSelectedItem());
        }
    };
    private HibernateTable _currentTable;

    public JHibernateTableSettingsPanel() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder("Table Mapping Attributes"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Domain Class Meta Attributes"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(0, 2, 4, 2));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(0, 2, 4, 2));
        jPanel3.add(this._beanNameLabel);
        jPanel3.add(this._beanNameField);
        jPanel3.add(this._beanKeyGeneratorLabel);
        jPanel3.add(this.BuildKeyGeneratorPanel());
        jPanel3.add(this._schemaNameLabel);
        jPanel3.add(this._schemaNameField);
        jPanel3.add(this._persisterLabel);
        jPanel3.add(this._persisterField);
        jPanel4.add((Component)this._proxyCheckBox);
        jPanel4.add((Component)this._dynamicUpdateCheckBox);
        jPanel4.add((Component)this._mutableCheckBox);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel5.add(this._classDescriptionLabel);
        jPanel5.add(this._classDescriptionField);
        jPanel5.add(this._extendsLabel);
        jPanel5.add(this._extendsField);
        jPanel6.add(this._classScopeLabel);
        jPanel6.add(this.BuildTableScopePanel());
        jPanel7.add(this._implementsLabel);
        jPanel7.add(this.BuildImplementsPanel());
        jPanel8.add((Component)this._implementLifecycleCheckBox);
        jPanel8.add((Component)this._implementValidatableCheckBox);
        jPanel2.add(jPanel5);
        jPanel2.add(jPanel6);
        jPanel2.add(jPanel7);
        jPanel2.add(jPanel8);
        this.add(jPanel);
        this.add(jPanel2);
        this._schemaNameField.getDocument().addDocumentListener(this._schemaDocumentListener);
        this._persisterField.getDocument().addDocumentListener(this._persisterDocumentListener);
        this._classDescriptionField.getDocument().addDocumentListener(this._classDescriptionDocumentListener);
        this._extendsField.getDocument().addDocumentListener(this._extendsDocumentListener);
        this._beanKeyGeneratorField.getDocument().addDocumentListener(this._keyGeneratorArgListener);
        this._mutableCheckBox.addActionListener(this.toggleBtnMutableAction);
        this._proxyCheckBox.addActionListener(this.toggleBtnProxyAction);
        this._dynamicUpdateCheckBox.addActionListener(this.toggleBtnDynamicUpdateAction);
        this._implementLifecycleCheckBox.addActionListener(this.toggleBtnLifecycleAction);
        this._implementValidatableCheckBox.addActionListener(this.toggleBtnValidatableAction);
        this._beanKeyGeneratorCombo.addActionListener(this.keyGeneratorComboAction);
        this._beanNameField.setEditable(false);
    }

    public void setTable(Table table) {
        this._currentTable = (HibernateTable)table;
        this._implementLifecycleCheckBox.setBooleanNode(this._currentTable.getLifecycleNode());
        this._implementValidatableCheckBox.setBooleanNode(this._currentTable.getValidatableNode());
        this._proxyCheckBox.setBooleanNode(this._currentTable.getProxyNode());
        this._mutableCheckBox.setBooleanNode(this._currentTable.getMutableNode());
        this._dynamicUpdateCheckBox.setBooleanNode(this._currentTable.getDynamicUpdateNode());
        this._beanNameField.setText(this._currentTable.getDestinationClassName());
        this._schemaNameField.setText(this._currentTable.getDatabaseSchema());
        this._persisterField.setText(this._currentTable.getPersister());
        this._classDescriptionField.setText(this._currentTable.getClassDescription());
        this._extendsField.setText(this._currentTable.getExtends());
        this.setKeyGenerator();
        this.setClassScope();
        this.setMultipleImplements();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void setKeyGenerator() {
        String[] stringArray = new String[]{"assigned", "native", "sequence", "identity", "increment", "hilo", "seqhilo", "uuid.hex", "uuid.string", "foreign"};
        String[] stringArray2 = new String[]{"assigned"};
        DefaultComboBoxModel<String> defaultComboBoxModel = null;
        defaultComboBoxModel = this._currentTable.isCompositeKey() ? new DefaultComboBoxModel<String>(stringArray2) : new DefaultComboBoxModel<String>(stringArray);
        this._beanKeyGeneratorCombo.setModel(defaultComboBoxModel);
        this._beanKeyGeneratorField.setEditable(!this._currentTable.isCompositeKey());
        this._beanKeyGeneratorField.setText(this._currentTable.getKeyGeneratorArg());
        this._beanKeyGeneratorCombo.setSelectedItem(this._currentTable.getKeyGenerator());
    }

    private void setClassScope() {
        this._publicRadioButton.setSelected(this._currentTable.getClassScope().equals("public"));
        this._protectedRadioButton.setSelected(this._currentTable.getClassScope().equals("protected"));
        this._privateRadioButton.setSelected(this._currentTable.getClassScope().equals("private"));
    }

    private void setMultipleImplements() {
        this._implementsComboBox.removeAllItems();
        ArrayList arrayList = this._currentTable.getImplements();
        for (int i = 0; i < arrayList.size(); ++i) {
            this._implementsComboBox.addItem(arrayList.get(i));
        }
    }

    private JPanel BuildTableScopePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._publicRadioButton);
        buttonGroup.add(this._protectedRadioButton);
        buttonGroup.add(this._privateRadioButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JHibernateTableSettingsPanel.this._currentTable.setClassScope(actionEvent.getActionCommand());
            }
        };
        this._publicRadioButton.setActionCommand("public");
        this._publicRadioButton.addActionListener(actionListener);
        this._protectedRadioButton.addActionListener(actionListener);
        this._protectedRadioButton.setActionCommand("protected");
        this._privateRadioButton.addActionListener(actionListener);
        this._privateRadioButton.setActionCommand("private");
        jPanel.add(this._publicRadioButton);
        jPanel.add(this._protectedRadioButton);
        jPanel.add(this._privateRadioButton);
        return jPanel;
    }

    private JPanel BuildImplementsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JButton jButton = new JButton("Add");
        JButton jButton2 = new JButton("Remove");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JHibernateTableSettingsPanel.this._sourceTextField.getText().trim();
                if (string.length() > 0) {
                    JHibernateTableSettingsPanel.this._implementsComboBox.addItem(string);
                    JHibernateTableSettingsPanel.this._sourceTextField.setText("");
                    ArrayList arrayList = JHibernateTableSettingsPanel.this._currentTable.getImplements();
                    arrayList.add(string);
                    JHibernateTableSettingsPanel.this._currentTable.setImplements(arrayList);
                }
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JHibernateTableSettingsPanel.this._implementsComboBox.getSelectedIndex();
                if (n >= 0) {
                    JHibernateTableSettingsPanel.this._implementsComboBox.removeItemAt(n);
                    ArrayList arrayList = JHibernateTableSettingsPanel.this._currentTable.getImplements();
                    arrayList.remove(n);
                    JHibernateTableSettingsPanel.this._currentTable.setImplements(arrayList);
                }
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener2);
        Dimension dimension = new Dimension(80, 20);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        Box box = Box.createHorizontalBox();
        Box box2 = Box.createHorizontalBox();
        box.add(this._sourceTextField);
        box.add(jButton);
        box2.add(this._implementsComboBox);
        box2.add(jButton2);
        jPanel.add(box);
        jPanel.add(box2);
        return jPanel;
    }

    private JPanel BuildKeyGeneratorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this._beanKeyGeneratorCombo.setEditable(false);
        Dimension dimension = new Dimension(90, 20);
        this._beanKeyGeneratorCombo.setPreferredSize(dimension);
        Box box = Box.createHorizontalBox();
        box.add(this._beanKeyGeneratorCombo);
        box.add(this._beanKeyGeneratorField);
        jPanel.add(box);
        return jPanel;
    }

    private void updateTable(String string) {
        this._currentTable.setDestinationClassName(string);
    }
}

