/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.concurrent;

import org.logicalcobwebs.concurrent.SynchronizedVariable;

public class SynchronizedDouble
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected double value_;

    public SynchronizedDouble(double initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedDouble(double initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double get() {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double set(double newValue) {
        Object object = this.lock_;
        synchronized (object) {
            double old = this.value_;
            this.value_ = newValue;
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit(double assumedValue, double newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success;
            boolean bl = success = assumedValue == this.value_;
            if (success) {
                this.value_ = newValue;
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double swap(SynchronizedDouble other) {
        if (other == this) {
            return this.get();
        }
        SynchronizedDouble fst = this;
        SynchronizedDouble snd = other;
        if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
            fst = other;
            snd = this;
        }
        Object object = fst.lock_;
        synchronized (object) {
            Object object2 = snd.lock_;
            synchronized (object2) {
                fst.set(snd.set(fst.get()));
                return this.get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double add(double amount) {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ += amount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double subtract(double amount) {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ -= amount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized double multiply(double factor) {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ *= factor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double divide(double factor) {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ /= factor;
        }
    }

    public int compareTo(double other) {
        double val = this.get();
        return val < other ? -1 : (val == other ? 0 : 1);
    }

    public int compareTo(SynchronizedDouble other) {
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        return this.compareTo((SynchronizedDouble)other);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SynchronizedDouble) {
            return this.get() == ((SynchronizedDouble)other).get();
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.get());
        return (int)(bits ^ bits >> 32);
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

