/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.FormatHelper;
import org.logicalcobwebs.proxool.PrototyperController;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxyConnectionIF;

class HouseKeeper {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$HouseKeeper == null ? (class$org$logicalcobwebs$proxool$HouseKeeper = HouseKeeper.class$("org.logicalcobwebs.proxool.HouseKeeper")) : class$org$logicalcobwebs$proxool$HouseKeeper);
    private ConnectionPool connectionPool;
    private long timeLastSwept;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$HouseKeeper;

    public HouseKeeper(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void sweep() throws ProxoolException {
        ConnectionPoolDefinition definition = this.connectionPool.getDefinition();
        Log log = this.connectionPool.getLog();
        Statement testStatement = null;
        try {
            this.connectionPool.acquirePrimaryReadLock();
            Connection connection = null;
            ProxyConnectionIF proxyConnection = null;
            int recentlyStartedActiveConnectionCountTemp = 0;
            int[] verifiedConnectionCountByState = new int[4];
            ProxyConnectionIF[] proxyConnections = this.connectionPool.getProxyConnections();
            int i = 0;
            while (i < proxyConnections.length) {
                block31: {
                    proxyConnection = proxyConnections[i];
                    connection = proxyConnection.getConnection();
                    if (!this.connectionPool.isConnectionPoolUp()) break;
                    if (proxyConnection.setStatus(1, 3)) {
                        String sql;
                        testStatement = connection.createStatement();
                        if (proxyConnection.isReallyClosed()) {
                            proxyConnection.setStatus(3, 0);
                            this.connectionPool.removeProxyConnection(proxyConnection, "it appears to be closed", true, true);
                        }
                        if ((sql = definition.getHouseKeepingTestSql()) != null && sql.length() > 0) {
                            boolean testResult = false;
                            try {
                                testResult = testStatement.execute(sql);
                                if (log.isDebugEnabled() && definition.isVerbose()) {
                                    log.debug(this.connectionPool.displayStatistics() + " - Testing connection " + proxyConnection.getId() + (testResult ? ": OK" : ": FAIL"));
                                }
                            }
                            catch (Throwable throwable) {
                                if (log.isDebugEnabled() && definition.isVerbose()) {
                                    log.debug(this.connectionPool.displayStatistics() + " - Testing connection " + proxyConnection.getId() + (testResult ? ": OK" : ": FAIL"));
                                }
                                throw throwable;
                            }
                        }
                        proxyConnection.setStatus(3, 1);
                        Object var14_15 = null;
                        try {
                            testStatement.close();
                        }
                        catch (Throwable t) {}
                        break block31;
                        {
                            catch (SQLException e) {
                                proxyConnection.setStatus(3, 0);
                                this.connectionPool.removeProxyConnection(proxyConnection, "it has problems: " + e, false, true);
                                var14_15 = null;
                                try {
                                    testStatement.close();
                                }
                                catch (Throwable t) {}
                            }
                        }
                        catch (Throwable throwable) {
                            var14_15 = null;
                            try {
                                testStatement.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                if (proxyConnection.getAge() > (long)definition.getMaximumConnectionLifetime()) {
                    String reason = "age is " + proxyConnection.getAge() + "ms";
                    if (proxyConnection.setStatus(1, 3)) {
                        if (proxyConnection.setStatus(3, 0)) {
                            this.connectionPool.expireProxyConnection(proxyConnection, reason, false);
                        }
                    } else {
                        proxyConnection.markForExpiry(reason);
                        if (log.isDebugEnabled()) {
                            log.debug(this.connectionPool.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " marked for expiry.");
                        }
                    }
                }
                if (proxyConnection.isActive()) {
                    long activeTime = System.currentTimeMillis() - proxyConnection.getTimeLastStartActive();
                    if (activeTime < (long)definition.getRecentlyStartedThreshold()) {
                        ++recentlyStartedActiveConnectionCountTemp;
                    }
                    if (activeTime > (long)definition.getMaximumActiveTime()) {
                        this.connectionPool.removeProxyConnection(proxyConnection, "it has been active for too long", true, true);
                        log.warn("#" + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " was active for " + activeTime + " milliseconds and has been removed automaticaly. The Thread responsible was named '" + proxyConnection.getRequester() + "'.");
                    }
                }
                int n = proxyConnection.getStatus();
                verifiedConnectionCountByState[n] = verifiedConnectionCountByState[n] + 1;
                ++i;
            }
            this.calculateUpState(recentlyStartedActiveConnectionCountTemp);
        }
        catch (Throwable e) {
            log.error("Housekeeping log.error( :", e);
        }
        finally {
            this.connectionPool.releasePrimaryReadLock();
            this.timeLastSwept = System.currentTimeMillis();
            if (definition.isVerbose() && log.isDebugEnabled()) {
                log.debug(this.connectionPool.displayStatistics() + " - House keeping triggerSweep done");
            }
        }
        PrototyperController.triggerSweep(definition.getAlias());
    }

    private long getTimeSinceLastSweep() {
        return System.currentTimeMillis() - this.timeLastSwept;
    }

    protected boolean isSweepDue() {
        if (this.connectionPool.isConnectionPoolUp()) {
            return this.getTimeSinceLastSweep() > (long)this.connectionPool.getDefinition().getHouseKeepingSleepTime();
        }
        LOG.warn("House keeper is still being asked to sweep despite the connection pool being down");
        return false;
    }

    private void calculateUpState(int recentlyStartedActiveConnectionCount) {
        try {
            int calculatedUpState = 0;
            int availableConnectionCount = this.connectionPool.getAvailableConnectionCount();
            if (availableConnectionCount > 0 || recentlyStartedActiveConnectionCount > 0) {
                if (this.connectionPool.getTimeOfLastRefusal() > System.currentTimeMillis() - (long)this.connectionPool.getDefinition().getOverloadWithoutRefusalLifetime()) {
                    calculatedUpState = 2;
                } else if (this.connectionPool.getActiveConnectionCount() > 0) {
                    calculatedUpState = 1;
                }
            } else {
                calculatedUpState = 3;
            }
            this.connectionPool.setUpState(calculatedUpState);
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    protected String getAlias() {
        return this.connectionPool.getDefinition().getAlias();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

