/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.SQLException;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxyConnection;
import org.logicalcobwebs.proxool.ProxyConnectionIF;
import org.logicalcobwebs.proxool.ProxyFactory;

public class Prototyper {
    private ConnectionPool connectionPool;
    private Log log = LogFactory.getLog(class$org$logicalcobwebs$proxool$Prototyper == null ? (class$org$logicalcobwebs$proxool$Prototyper = Prototyper.class$("org.logicalcobwebs.proxool.Prototyper")) : class$org$logicalcobwebs$proxool$Prototyper);
    private long connectionCount;
    private final Object lock = new Integer(1);
    private boolean sweepNeeded = true;
    private long nextConnectionId = 1L;
    private boolean cancel;
    private int connectionsBeingMade;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$Prototyper;

    public Prototyper(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        this.log = connectionPool.getLog();
    }

    protected boolean isSweepNeeded() {
        return this.sweepNeeded;
    }

    protected void triggerSweep() {
        this.sweepNeeded = true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sweep() {
        boolean somethingDone = false;
        try {
            block11: {
                block10: {
                    if (!true) break block10;
                    if (this.cancel) return somethingDone;
                    if (!this.connectionPool.isConnectionPoolUp()) break block11;
                }
                do {
                    String reason = null;
                    if (this.connectionCount >= (long)this.getDefinition().getMaximumConnectionCount()) {
                        return somethingDone;
                    }
                    if (this.connectionCount < (long)this.getDefinition().getMinimumConnectionCount()) {
                        reason = "to achieve minimum of " + this.getDefinition().getMinimumConnectionCount();
                    } else {
                        if (this.connectionPool.getAvailableConnectionCount() >= this.getDefinition().getPrototypeCount()) return somethingDone;
                        reason = "to keep " + this.getDefinition().getPrototypeCount() + " available";
                    }
                    try {
                        if (!this.connectionPool.isConnectionPoolUp()) {
                            return somethingDone;
                        }
                        this.buildConnection(1, reason);
                        somethingDone = true;
                    }
                    catch (Exception e) {
                        this.log.error("Prototype", e);
                        return somethingDone;
                    }
                    if (this.cancel) return somethingDone;
                } while (this.connectionPool.isConnectionPoolUp());
            }
            return somethingDone;
        }
        catch (Throwable t) {
            this.log.error("Unexpected error", t);
            return somethingDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProxyConnectionIF buildConnection(int status, String creator) throws SQLException, ProxoolException {
        long id = 0L;
        Object object = this.lock;
        synchronized (object) {
            if (this.connectionCount >= (long)this.getDefinition().getMaximumConnectionCount()) {
                throw new ProxoolException("ConnectionCount is " + this.connectionCount + ". Maximum connection count of " + this.getDefinition().getMaximumConnectionCount() + " cannot be exceeded.");
            }
            this.checkSimultaneousBuildThrottle();
            ++this.connectionsBeingMade;
            ++this.connectionCount;
            id = this.nextConnectionId++;
        }
        ProxyConnection proxyConnection = null;
        Connection connection = null;
        try {
            proxyConnection = ProxyFactory.buildProxyConnection(id, this.connectionPool, status);
            connection = ProxyFactory.getConnection(proxyConnection);
            try {
                this.connectionPool.onBirth(connection);
            }
            catch (Exception e) {
                this.log.error("Problem during onBirth (ignored)", e);
            }
            this.connectionPool.addProxyConnection(proxyConnection);
            if (this.log.isDebugEnabled()) {
                StringBuffer out = new StringBuffer(this.connectionPool.displayStatistics());
                out.append(" - Connection #");
                out.append(proxyConnection.getId());
                if (this.getDefinition().isVerbose()) {
                    out.append(" (");
                    out.append(Integer.toHexString(proxyConnection.hashCode()));
                    out.append(")");
                }
                out.append(" created ");
                out.append(creator);
                out.append(" = ");
                out.append(ConnectionPool.getStatusDescription(proxyConnection.getStatus()));
                if (this.getDefinition().isVerbose()) {
                    out.append(" -> ");
                    out.append(this.getDefinition().getUrl());
                    out.append(" (");
                    out.append(Integer.toHexString(proxyConnection.getConnection().hashCode()));
                    out.append(") by thread ");
                    out.append(Thread.currentThread().getName());
                }
                this.log.debug(out);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(e);
            }
            throw e;
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(t);
            }
        }
        finally {
            Object object2 = this.lock;
            synchronized (object2) {
                if (proxyConnection == null) {
                    --this.connectionCount;
                }
                --this.connectionsBeingMade;
            }
        }
        return proxyConnection;
    }

    protected void connectionRemoved() {
        --this.connectionCount;
    }

    protected void checkSimultaneousBuildThrottle() throws SQLException {
        if (this.connectionsBeingMade > this.getDefinition().getSimultaneousBuildThrottle()) {
            throw new SQLException("We are already in the process of making " + this.connectionsBeingMade + " connections and the number of simultaneous builds has been throttled to " + this.getDefinition().getSimultaneousBuildThrottle());
        }
    }

    public long getConnectionCount() {
        return this.connectionCount;
    }

    private ConnectionPoolDefinitionIF getDefinition() {
        return this.connectionPool.getDefinition();
    }

    public void cancel() {
        this.cancel = true;
    }

    public String getAlias() {
        return this.getDefinition().getAlias();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

