/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.lang.ObjectUtils;
import com.mchange.v2.ser.SerializableUtils;
import com.mchange.v2.ser.UnsupportedVersionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public abstract class PoolBackedDataSource
implements DataSource,
Referenceable {
    static final Coalescer IMMUTABLES_COALESCER = CoalescerFactory.createCoalescer(true, true);
    transient ConnectionPoolDataSource connectionPoolDataSource;
    transient int numHelperThreads = C3P0Defaults.numHelperThreads();
    transient String factoryClassLocation;
    transient C3P0PooledConnectionPoolManager poolManager;
    static final String REFADDR_VERSION = "version";
    static final String REFADDR_connectionPoolDataSource = "connectionPoolDataSource";
    static final String REFADDR_numHelperThreads = "numHelperThreads";
    static final int CURRENT_VERSION = 1;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$ObjectFactory;

    ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.connectionPoolDataSource;
    }

    int getNumHelperThreads() {
        return this.numHelperThreads;
    }

    String getFactoryClassLocation() {
        return this.factoryClassLocation;
    }

    void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
        this.connectionPoolDataSource = connectionPoolDataSource;
        this._resetPoolManager();
    }

    void setNumHelperThreads(int numHelperThreads) {
        this.numHelperThreads = numHelperThreads;
    }

    void setFactoryClassLocation(String factoryClassLocation) {
        this.factoryClassLocation = factoryClassLocation;
    }

    public Immutable asImmutable() {
        return Immutable.find(this.connectionPoolDataSource, this.numHelperThreads, this.factoryClassLocation);
    }

    public Connection getConnection() throws SQLException {
        if (this.poolManager == null) {
            this.poolManager = new C3P0PooledConnectionPoolManager(this.connectionPoolDataSource, this.numHelperThreads);
        }
        PooledConnection pc = this.poolManager.getPool().checkoutPooledConnection();
        return pc.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (this.poolManager == null) {
            this.poolManager = new C3P0PooledConnectionPoolManager(this.connectionPoolDataSource, this.numHelperThreads);
        }
        PooledConnection pc = this.poolManager.getPool(new DbAuth(username, password)).checkoutPooledConnection();
        return pc.getConnection();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.connectionPoolDataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.connectionPoolDataSource.setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return this.connectionPoolDataSource.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.connectionPoolDataSource.setLoginTimeout(seconds);
    }

    void _resetPoolManager() {
        if (this.poolManager != null) {
            this.poolManager.close();
            this.poolManager = null;
        }
    }

    private static boolean parseBoolean(String sRep) {
        return Boolean.valueOf(sRep);
    }

    private static char firstChar(String s) {
        return s.charAt(0);
    }

    public final Reference getReference() throws NamingException {
        try {
            Reference out = new Reference((class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable = PoolBackedDataSource.class$("com.mchange.v2.c3p0.impl.PoolBackedDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable).getName(), (class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$ObjectFactory == null ? (class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$ObjectFactory = PoolBackedDataSource.class$("com.mchange.v2.c3p0.impl.PoolBackedDataSource$ObjectFactory")) : class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$ObjectFactory).getName(), this.factoryClassLocation);
            out.add(new StringRefAddr(REFADDR_VERSION, String.valueOf(1)));
            out.add(new BinaryRefAddr(REFADDR_connectionPoolDataSource, SerializableUtils.toByteArray(this.connectionPoolDataSource)));
            out.add(new StringRefAddr(REFADDR_numHelperThreads, String.valueOf(this.numHelperThreads)));
            return out;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NamingException("Nested Exception: " + e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Mutable
    extends PoolBackedDataSource
    implements Serializable {
        public synchronized ConnectionPoolDataSource getConnectionPoolDataSource() {
            return super.getConnectionPoolDataSource();
        }

        public synchronized int getNumHelperThreads() {
            return super.getNumHelperThreads();
        }

        public synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public synchronized void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
            super.setConnectionPoolDataSource(connectionPoolDataSource);
        }

        public synchronized void setNumHelperThreads(int numHelperThreads) {
            super.setNumHelperThreads(numHelperThreads);
        }

        public synchronized void setFactoryClassLocation(String factoryClassLocation) {
            super.setFactoryClassLocation(factoryClassLocation);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of PoolBackedDataSource");
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new IOException("We should not be finding this mutable version of PoolBackedDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static abstract class Base
    extends PoolBackedDataSource
    implements Serializable {
        protected synchronized ConnectionPoolDataSource getConnectionPoolDataSource() {
            return super.getConnectionPoolDataSource();
        }

        protected synchronized int getNumHelperThreads() {
            return super.getNumHelperThreads();
        }

        protected synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        protected synchronized void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
            super.setConnectionPoolDataSource(connectionPoolDataSource);
        }

        protected synchronized void setNumHelperThreads(int numHelperThreads) {
            super.setNumHelperThreads(numHelperThreads);
        }

        protected synchronized void setFactoryClassLocation(String factoryClassLocation) {
            super.setFactoryClassLocation(factoryClassLocation);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of PoolBackedDataSource");
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new IOException("We should not be finding this mutable version of PoolBackedDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static final class Immutable
    extends PoolBackedDataSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final short VERSION = 1;

        public static Immutable find(ConnectionPoolDataSource _connectionPoolDataSource, int _numHelperThreads, String _factoryClassLocation) {
            Immutable uncanonical = new Immutable();
            uncanonical.connectionPoolDataSource = _connectionPoolDataSource;
            uncanonical._resetPoolManager();
            uncanonical.numHelperThreads = _numHelperThreads;
            uncanonical.factoryClassLocation = _factoryClassLocation;
            return (Immutable)IMMUTABLES_COALESCER.coalesce(uncanonical);
        }

        private Immutable() {
        }

        public ConnectionPoolDataSource getConnectionPoolDataSource() {
            return super.getConnectionPoolDataSource();
        }

        public int getNumHelperThreads() {
            return super.getNumHelperThreads();
        }

        public String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public Immutable asImmutable() {
            return this;
        }

        public boolean equals(Object o) {
            if (o instanceof Immutable) {
                Immutable other = (Immutable)o;
                return ObjectUtils.eqOrBothNull(this.connectionPoolDataSource, other.connectionPoolDataSource) && this.numHelperThreads == other.numHelperThreads && ObjectUtils.eqOrBothNull(this.factoryClassLocation, other.factoryClassLocation);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtils.hashOrZero(this.connectionPoolDataSource) ^ this.numHelperThreads ^ ObjectUtils.hashOrZero(this.factoryClassLocation);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeShort(1);
            out.writeObject(this.connectionPoolDataSource);
            out.writeInt(this.numHelperThreads);
            out.writeObject(this.factoryClassLocation);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            short version = in.readShort();
            switch (version) {
                case 1: {
                    this.connectionPoolDataSource = (ConnectionPoolDataSource)in.readObject();
                    this._resetPoolManager();
                    this.numHelperThreads = in.readInt();
                    this.factoryClassLocation = (String)in.readObject();
                    break;
                }
                default: {
                    throw new UnsupportedVersionException(this, version);
                }
            }
        }
    }

    public static class ObjectFactory
    implements javax.naming.spi.ObjectFactory {
        static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable;

        public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
            Reference ref;
            String className = (class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable = ObjectFactory.class$("com.mchange.v2.c3p0.impl.PoolBackedDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable).getName();
            if (refObj instanceof Reference && (ref = (Reference)refObj).getClassName().equals(className)) {
                int version = Integer.parseInt((String)ref.get(PoolBackedDataSource.REFADDR_VERSION).getContent());
                if (version == 1) {
                    ConnectionPoolDataSource nascentConnectionPoolDataSource = (ConnectionPoolDataSource)SerializableUtils.fromByteArray((byte[])ref.get(PoolBackedDataSource.REFADDR_connectionPoolDataSource).getContent());
                    int nascentNumHelperThreads = Integer.parseInt((String)ref.get(PoolBackedDataSource.REFADDR_numHelperThreads).getContent());
                    return Immutable.find(nascentConnectionPoolDataSource, nascentNumHelperThreads, ref.getFactoryClassLocation());
                }
                throw new NamingException("Cannot resolve reference (version " + version + " unknown.");
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

