/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.test;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.test.C3P0BenchmarkApp;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.DataSource;

public final class C3P0BenchmarkApp {
    static final String EMPTY_TABLE_CREATE = "CREATE TABLE emptyyukyuk (a varchar(8), b varchar(8))";
    static final String EMPTY_TABLE_SELECT = "SELECT * FROM emptyyukyuk";
    static final String EMPTY_TABLE_DROP = "DROP TABLE emptyyukyuk";
    static final String EMPTY_TABLE_CONDITIONAL_SELECT = "SELECT * FROM emptyyukyuk where a = ?";
    static final String N_ENTRY_TABLE_CREATE = "CREATE TABLE n_entryyukyuk (a INTEGER)";
    static final String N_ENTRY_TABLE_INSERT = "INSERT INTO n_entryyukyuk VALUES ( ? )";
    static final String N_ENTRY_TABLE_SELECT = "SELECT * FROM n_entryyukyuk";
    static final String N_ENTRY_TABLE_DROP = "DROP TABLE n_entryyukyuk";
    static final int NUM_ITERATIONS = 2000;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$test$C3P0BenchmarkApp;

    /*
     * Loose catch block
     */
    public static void main(String[] argv) {
        block14: {
            DataSource ds_unpooled = null;
            DataSource ds_pooled = null;
            String jdbc_url = null;
            String username = null;
            String password = null;
            if (argv.length == 3) {
                jdbc_url = argv[0];
                username = argv[1];
                password = argv[2];
            } else if (argv.length == 1) {
                jdbc_url = argv[0];
                username = null;
                password = null;
            } else {
                C3P0BenchmarkApp.usage();
            }
            if (!jdbc_url.startsWith("jdbc:")) {
                C3P0BenchmarkApp.usage();
            }
            ds_unpooled = DataSources.unpooledDataSource(jdbc_url, username, password);
            ds_pooled = DataSources.pooledDataSource(ds_unpooled);
            C3P0BenchmarkApp.create(ds_pooled);
            System.out.println("Please wait. Tests can be very slow.");
            ArrayList<Test> l = new ArrayList<Test>();
            l.add(new ConnectionAcquisitionTest());
            l.add(new StatementCreateTest());
            l.add(new StatementEmptyTableSelectTest());
            l.add(new PreparedStatementEmptyTableSelectTest());
            l.add(new PreparedStatementAcquireTest());
            l.add(new ResultSetReadTest());
            l.add(new FiveThreadPSQueryTestTest());
            int i = 0;
            int len = l.size();
            while (i < len) {
                ((Test)l.get(i)).perform(ds_unpooled, ds_pooled, 2000);
                ++i;
            }
            Object var10_10 = null;
            try {
                C3P0BenchmarkApp.drop(ds_pooled);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block14;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    Object var10_11 = null;
                    try {
                        C3P0BenchmarkApp.drop(ds_pooled);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    C3P0BenchmarkApp.drop(ds_pooled);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private static void usage() {
        System.err.println("java -Djdbc.drivers=<comma_sep_list_of_drivers> " + (class$com$mchange$v2$c3p0$test$C3P0BenchmarkApp == null ? (class$com$mchange$v2$c3p0$test$C3P0BenchmarkApp = C3P0BenchmarkApp.class$("com.mchange.v2.c3p0.test.C3P0BenchmarkApp")) : class$com$mchange$v2$c3p0$test$C3P0BenchmarkApp).getName() + " <jdbc_url> [<username> <password>]");
        System.exit(-1);
    }

    static void create(DataSource ds) throws SQLException {
        System.err.println("Creating test schema.");
        Connection con = null;
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        PreparedStatement ps3 = null;
        try {
            con = ds.getConnection();
            ps1 = con.prepareStatement(EMPTY_TABLE_CREATE);
            ps2 = con.prepareStatement(N_ENTRY_TABLE_CREATE);
            ps3 = con.prepareStatement(N_ENTRY_TABLE_INSERT);
            ps1.executeUpdate();
            ps2.executeUpdate();
            int i = 0;
            while (i < 2000) {
                ps3.setInt(1, i);
                ps3.executeUpdate();
                System.err.print('.');
                ++i;
            }
            System.err.println();
            System.err.println("Test schema created.");
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            StatementUtils.attemptClose(ps1);
            StatementUtils.attemptClose(ps2);
            StatementUtils.attemptClose(ps3);
            ConnectionUtils.attemptClose(con);
            throw throwable;
        }
        StatementUtils.attemptClose(ps1);
        StatementUtils.attemptClose(ps2);
        StatementUtils.attemptClose(ps3);
        ConnectionUtils.attemptClose(con);
    }

    static void drop(DataSource ds) throws SQLException {
        Connection con = null;
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        try {
            con = ds.getConnection();
            ps1 = con.prepareStatement(EMPTY_TABLE_DROP);
            ps2 = con.prepareStatement(N_ENTRY_TABLE_DROP);
            ps1.executeUpdate();
            ps2.executeUpdate();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            StatementUtils.attemptClose(ps1);
            StatementUtils.attemptClose(ps2);
            ConnectionUtils.attemptClose(con);
            throw throwable;
        }
        StatementUtils.attemptClose(ps1);
        StatementUtils.attemptClose(ps2);
        ConnectionUtils.attemptClose(con);
        System.err.println("Test schema dropped.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class FiveThreadPSQueryTestTest
    extends Test {
        FiveThreadPSQueryTestTest() {
            super("Five threads getting a connection, executing a query, " + System.getProperty("line.separator") + "and retrieving results concurrently via a prepared statement.");
        }

        protected long test(DataSource ds, int n) throws Exception {
            long start = System.currentTimeMillis();
            Thread[] ts = new Thread[5];
            int i = 0;
            while (i < 5) {
                class QueryThread
                extends Thread {
                    private final /* synthetic */ int val$n;
                    private final /* synthetic */ DataSource val$ds;
                    private final /* synthetic */ FiveThreadPSQueryTestTest this$0;

                    QueryThread(FiveThreadPSQueryTestTest this$0, int val$n, DataSource val$ds, int num) {
                        super("QueryThread-" + num);
                        this.this$0 = this$0;
                        this.val$n = val$n;
                        this.val$ds = val$ds;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        Connection con = null;
                        PreparedStatement pstmt = null;
                        ResultSet rs = null;
                        int i = 0;
                        while (true) {
                            block7: {
                                Object var7_6;
                                if (i >= this.val$n / 5) {
                                    return;
                                }
                                try {
                                    try {
                                        con = this.val$ds.getConnection();
                                        pstmt = con.prepareStatement("SELECT * FROM emptyyukyuk where a = ?");
                                        pstmt.setString(1, "boo");
                                        rs = pstmt.executeQuery();
                                        while (rs.next()) {
                                            System.err.println("Huh?? Empty table has values?");
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        var7_6 = null;
                                        ResultSetUtils.attemptClose(rs);
                                        StatementUtils.attemptClose(pstmt);
                                        ConnectionUtils.attemptClose(con);
                                        break block7;
                                    }
                                    var7_6 = null;
                                }
                                catch (Throwable throwable) {
                                    var7_6 = null;
                                    ResultSetUtils.attemptClose(rs);
                                    StatementUtils.attemptClose(pstmt);
                                    ConnectionUtils.attemptClose(con);
                                    throw throwable;
                                }
                                ResultSetUtils.attemptClose(rs);
                                StatementUtils.attemptClose(pstmt);
                                ConnectionUtils.attemptClose(con);
                            }
                            ++i;
                        }
                    }
                }
                ts[i] = new QueryThread(this, n, ds, i);
                ts[i].start();
                ++i;
            }
            int i2 = 0;
            while (i2 < 5) {
                ts[i2].join();
                ++i2;
            }
            return System.currentTimeMillis() - start;
        }
    }

    static class ResultSetReadTest
    extends Test {
        ResultSetReadTest() {
            super("Reading one row / one entry from a result set");
        }

        protected long test(DataSource ds, int n) throws SQLException {
            long l;
            if (n > 10000) {
                throw new IllegalArgumentException("10K max.");
            }
            Connection con = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                con = ds.getConnection();
                pstmt = con.prepareStatement(C3P0BenchmarkApp.N_ENTRY_TABLE_SELECT);
                rs = pstmt.executeQuery();
                long start = System.currentTimeMillis();
                int i = 0;
                while (i < n) {
                    if (!rs.next()) {
                        System.err.println("huh?");
                    }
                    rs.getInt(1);
                    ++i;
                }
                long end = System.currentTimeMillis();
                l = end - start;
                Object var14_10 = null;
            }
            catch (Throwable throwable) {
                Object var14_11 = null;
                ResultSetUtils.attemptClose(rs);
                StatementUtils.attemptClose(pstmt);
                ConnectionUtils.attemptClose(con);
                throw throwable;
            }
            ResultSetUtils.attemptClose(rs);
            StatementUtils.attemptClose(pstmt);
            ConnectionUtils.attemptClose(con);
            return l;
        }
    }

    static class PreparedStatementEmptyTableSelectTest
    extends Test {
        PreparedStatementEmptyTableSelectTest() {
            super("Empty Table PreparedStatement Select (on a single PreparedStatement)");
        }

        protected long test(DataSource ds, int n) throws SQLException {
            long l;
            Connection con = null;
            PreparedStatement pstmt = null;
            try {
                con = ds.getConnection();
                pstmt = con.prepareStatement(C3P0BenchmarkApp.EMPTY_TABLE_SELECT);
                l = this.test(pstmt, n);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                StatementUtils.attemptClose(pstmt);
                ConnectionUtils.attemptClose(con);
                throw throwable;
            }
            StatementUtils.attemptClose(pstmt);
            ConnectionUtils.attemptClose(con);
            return l;
        }

        long test(PreparedStatement pstmt, int n) throws SQLException {
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < n) {
                pstmt.executeQuery().close();
                ++i;
            }
            long end = System.currentTimeMillis();
            return end - start;
        }
    }

    static class PreparedStatementAcquireTest
    extends Test {
        PreparedStatementAcquireTest() {
            super("Acquire and Cleanup a PreparedStatement (same statement, many times)");
        }

        protected long test(DataSource ds, int n) throws SQLException {
            long l;
            Connection con = null;
            PreparedStatement pstmt = null;
            try {
                con = ds.getConnection();
                long start = System.currentTimeMillis();
                int i = 0;
                while (i < n) {
                    Object var11_7;
                    try {
                        pstmt = con.prepareStatement(C3P0BenchmarkApp.EMPTY_TABLE_CONDITIONAL_SELECT);
                        var11_7 = null;
                    }
                    catch (Throwable throwable) {
                        var11_7 = null;
                        StatementUtils.attemptClose(pstmt);
                        throw throwable;
                    }
                    StatementUtils.attemptClose(pstmt);
                    ++i;
                }
                long end = System.currentTimeMillis();
                l = end - start;
                Object var13_11 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                ConnectionUtils.attemptClose(con);
                throw throwable;
            }
            ConnectionUtils.attemptClose(con);
            return l;
        }
    }

    static class StatementEmptyTableSelectTest
    extends Test {
        StatementEmptyTableSelectTest() {
            super("Empty Table Statement Select (on a single Statement)");
        }

        protected long test(DataSource ds, int n) throws SQLException {
            long l;
            Connection con = null;
            Statement stmt = null;
            try {
                con = ds.getConnection();
                stmt = con.createStatement();
                l = this.test(stmt, n);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                StatementUtils.attemptClose(stmt);
                ConnectionUtils.attemptClose(con);
                throw throwable;
            }
            StatementUtils.attemptClose(stmt);
            ConnectionUtils.attemptClose(con);
            return l;
        }

        long test(Statement stmt, int n) throws SQLException {
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < n) {
                stmt.executeQuery(C3P0BenchmarkApp.EMPTY_TABLE_SELECT).close();
                ++i;
            }
            long end = System.currentTimeMillis();
            return end - start;
        }
    }

    static class StatementCreateTest
    extends Test {
        StatementCreateTest() {
            super("Statement Creation and Cleanup");
        }

        protected long test(DataSource ds, int n) throws SQLException {
            long l;
            Connection con = null;
            try {
                con = ds.getConnection();
                l = this.test(con, n);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                ConnectionUtils.attemptClose(con);
                throw throwable;
            }
            ConnectionUtils.attemptClose(con);
            return l;
        }

        long test(Connection con, int n) throws SQLException {
            Statement stmt = null;
            long start = System.currentTimeMillis();
            try {
                int i = 0;
                while (i < n) {
                    stmt = con.createStatement();
                    ++i;
                }
                Object var10_6 = null;
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                StatementUtils.attemptClose(stmt);
                throw throwable;
            }
            StatementUtils.attemptClose(stmt);
            long end = System.currentTimeMillis();
            return end - start;
        }
    }

    static class ConnectionAcquisitionTest
    extends Test {
        ConnectionAcquisitionTest() {
            super("Connection Acquisition and Cleanup");
        }

        protected long test(DataSource ds, int n) throws Exception {
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < n) {
                Object var10_6;
                Connection con = null;
                try {
                    con = ds.getConnection();
                    var10_6 = null;
                }
                catch (Throwable throwable) {
                    var10_6 = null;
                    ConnectionUtils.attemptClose(con);
                    throw throwable;
                }
                ConnectionUtils.attemptClose(con);
                ++i;
            }
            long end = System.currentTimeMillis();
            return end - start;
        }
    }

    static abstract class Test {
        String name;

        Test(String name) {
            this.name = name;
        }

        public void perform(DataSource unpooled, DataSource pooled, int iterations) throws Exception {
            double msecs_unpooled = (double)this.test(unpooled, iterations) / (double)iterations;
            double msecs_pooled = (double)this.test(pooled, iterations) / (double)iterations;
            System.out.println(this.name + " [ " + iterations + " iterations ]:");
            System.out.println("\tunpooled: " + msecs_unpooled + " msecs");
            System.out.println("\t  pooled: " + msecs_pooled + " msecs");
            System.out.println("\tspeed-up factor: " + msecs_unpooled / msecs_pooled + " times");
            System.out.println("\tspeed-up absolute: " + (msecs_unpooled - msecs_pooled) + " msecs");
            System.out.println();
        }

        protected abstract long test(DataSource var1, int var2) throws Exception;
    }
}

