/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cfg;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.cfg.Mappings;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.mapping.Any;
import net.sf.hibernate.mapping.Array;
import net.sf.hibernate.mapping.Association;
import net.sf.hibernate.mapping.Bag;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.Component;
import net.sf.hibernate.mapping.ForeignKey;
import net.sf.hibernate.mapping.Formula;
import net.sf.hibernate.mapping.IdentifierBag;
import net.sf.hibernate.mapping.IdentifierCollection;
import net.sf.hibernate.mapping.IndexedCollection;
import net.sf.hibernate.mapping.IntegerValue;
import net.sf.hibernate.mapping.List;
import net.sf.hibernate.mapping.ManyToOne;
import net.sf.hibernate.mapping.Map;
import net.sf.hibernate.mapping.OneToMany;
import net.sf.hibernate.mapping.OneToOne;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.PrimitiveArray;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.RootClass;
import net.sf.hibernate.mapping.Set;
import net.sf.hibernate.mapping.Subclass;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.ComponentType;
import net.sf.hibernate.type.DynaBeanType;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.PrimitiveType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

final class Binder {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cfg$Binder == null ? (class$net$sf$hibernate$cfg$Binder = Binder.class$("net.sf.hibernate.cfg.Binder")) : class$net$sf$hibernate$cfg$Binder));
    static /* synthetic */ Class class$net$sf$hibernate$cfg$Binder;
    static /* synthetic */ Class class$net$sf$hibernate$persister$EntityPersister;
    static /* synthetic */ Class class$net$sf$hibernate$persister$NormalizedEntityPersister;
    static /* synthetic */ Class class$org$apache$commons$beanutils$BasicDynaBean;

    private Binder() {
    }

    public static void bindClass(Element node, PersistentClass model, Mappings mapping) throws MappingException {
        Attribute discriminatorNode;
        String className = node.attributeValue("name");
        try {
            model.setPersistentClass(ReflectHelper.classForName(className));
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("persistent class not found", cnfe);
        }
        Attribute proxyNode = node.attribute("proxy");
        if (proxyNode != null) {
            try {
                model.setProxyInterface(ReflectHelper.classForName(proxyNode.getValue()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException(cnfe);
            }
        }
        model.setDiscriminatorValue((discriminatorNode = node.attribute("discriminator-value")) == null ? model.getName() : discriminatorNode.getValue());
        Attribute dynamicNode = node.attribute("dynamic-update");
        model.setDynamicUpdate(dynamicNode == null ? false : "true".equals(dynamicNode.getValue()));
        Attribute insertNode = node.attribute("dynamic-insert");
        model.setDynamicInsert(insertNode == null ? false : "true".equals(insertNode.getValue()));
        if (mapping.isAutoImport()) {
            mapping.addImport(className, StringHelper.unqualify(className));
        }
    }

    public static void bindSubclass(Element node, Subclass model, Mappings mappings) throws MappingException {
        Binder.bindClass(node, model, mappings);
        if (model.getPersister() == null) {
            model.getRootClass().setPersister(class$net$sf$hibernate$persister$EntityPersister == null ? (class$net$sf$hibernate$persister$EntityPersister = Binder.class$("net.sf.hibernate.persister.EntityPersister")) : class$net$sf$hibernate$persister$EntityPersister);
        }
        model.setTable(model.getSuperclass().getTable());
        log.info((Object)("Mapping subclass: " + model.getName() + " -> " + model.getTable().getName()));
        Binder.propertiesFromXML(node, model, mappings);
    }

    public static void bindJoinedSubclass(Element node, Subclass model, Mappings mappings) throws MappingException {
        Attribute tableNameNode;
        Binder.bindClass(node, model, mappings);
        if (model.getPersister() == null) {
            model.getRootClass().setPersister(class$net$sf$hibernate$persister$NormalizedEntityPersister == null ? (class$net$sf$hibernate$persister$NormalizedEntityPersister = Binder.class$("net.sf.hibernate.persister.NormalizedEntityPersister")) : class$net$sf$hibernate$persister$NormalizedEntityPersister);
        }
        String tableName = (tableNameNode = node.attribute("table")) == null ? StringHelper.unqualify(model.getPersistentClass().getName()) : tableNameNode.getValue();
        Attribute schemaNode = node.attribute("schema");
        String schema = schemaNode == null ? mappings.getSchemaName() : schemaNode.getValue();
        Table mytable = mappings.addTable(schema, tableName);
        model.setTable(mytable);
        log.info((Object)("Mapping joined-subclass: " + model.getName() + " -> " + model.getTable().getName()));
        Element keyNode = node.element("key");
        Value key = new Value(mytable);
        model.setKey(key);
        Binder.bindValue(keyNode, key, false, model.getName());
        model.getKey().setType(model.getIdentifier().getType());
        model.createPrimaryKey();
        ForeignKey fk = mytable.createForeignKey(model.getKey().getConstraintColumns());
        fk.setReferencedClass(model.getSuperclass().getPersistentClass());
        Binder.propertiesFromXML(node, model, mappings);
    }

    public static void bindRootClass(Element node, RootClass model, Mappings mappings) throws MappingException {
        Attribute polyNode;
        Binder.bindClass(node, model, mappings);
        Attribute tableNameNode = node.attribute("table");
        String tableName = tableNameNode == null ? StringHelper.unqualify(model.getPersistentClass().getName()) : tableNameNode.getValue();
        Attribute schemaNode = node.attribute("schema");
        String schema = schemaNode == null ? mappings.getSchemaName() : schemaNode.getValue();
        Table table = mappings.addTable(schema, tableName);
        model.setTable(table);
        log.info((Object)("Mapping class: " + model.getName() + " -> " + model.getTable().getName()));
        Attribute persisterNode = node.attribute("persister");
        if (persisterNode != null) {
            try {
                model.setPersister(ReflectHelper.classForName(persisterNode.getValue()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException("Could not find persister class: " + persisterNode.getValue());
            }
        }
        Attribute mutableNode = node.attribute("mutable");
        model.setMutable(mutableNode == null || mutableNode.getValue().equals("true"));
        Attribute whereNode = node.attribute("where");
        if (whereNode != null) {
            model.setWhere(whereNode.getValue());
        }
        model.setExplicitPolymorphism((polyNode = node.attribute("polymorphism")) != null && polyNode.getValue().equals("explicit"));
        Iterator subnodes = node.elementIterator();
        while (subnodes.hasNext()) {
            Property prop;
            Value id;
            Element subnode = (Element)subnodes.next();
            String name = subnode.getName();
            String propertyName = Binder.getPropertyName(subnode);
            if ("id".equals(name)) {
                id = new Value(table);
                model.setIdentifier(id);
                if (propertyName == null) {
                    Binder.bindValue(subnode, id, false, "id");
                    if (id.getType() == null) {
                        throw new MappingException("must specify an identifier type: " + model.getPersistentClass().getName());
                    }
                    model.setIdentifierProperty(null);
                } else {
                    Binder.bindValue(subnode, id, false, propertyName);
                    id.setTypeByReflection(model.getPersistentClass(), propertyName);
                    prop = new Property(id);
                    Binder.bindProperty(subnode, prop, mappings);
                    model.setIdentifierProperty(prop);
                }
                if (id.getType().getReturnedClass().isArray()) {
                    throw new MappingException("illegal use of an array as an identifier (arrays don't reimplement equals)");
                }
                Binder.makeIdentifier(subnode, id, mappings);
                continue;
            }
            if ("composite-id".equals(name)) {
                id = new Component(model);
                model.setIdentifier(id);
                if (propertyName == null) {
                    Binder.bindComponent(subnode, (Component)id, null, model.getName() + ".id", false, mappings);
                    model.setEmbeddedIdentifier(((Component)id).isEmbedded());
                    model.setIdentifierProperty(null);
                } else {
                    Class reflectedClass = ReflectHelper.getGetter(model.getPersistentClass(), propertyName).getReturnType();
                    Binder.bindComponent(subnode, (Component)id, reflectedClass, model.getName() + '.' + propertyName, false, mappings);
                    Property prop2 = new Property(id);
                    Binder.bindProperty(subnode, prop2, mappings);
                    model.setIdentifierProperty(prop2);
                }
                Binder.makeIdentifier(subnode, id, mappings);
                continue;
            }
            if ("version".equals(name) || "timestamp".equals(name)) {
                Value val = new Value(table);
                Binder.bindValue(subnode, val, false, propertyName);
                if (val.getType() == null) {
                    val.setType("version".equals(name) ? Hibernate.INTEGER : Hibernate.TIMESTAMP);
                }
                prop = new Property(val);
                Binder.bindProperty(subnode, prop, mappings);
                model.setVersion(prop);
                model.addProperty(prop);
                continue;
            }
            if ("discriminator".equals(name)) {
                Value discrim = new Value(table);
                model.setDiscriminator(discrim);
                Binder.bindValue(subnode, discrim, false, "class");
                if (discrim.getType() == null) {
                    discrim.setType(Hibernate.STRING);
                    ((Column)discrim.getColumnIterator().next()).setType(Hibernate.STRING);
                }
                model.setPolymorphic(true);
                if (!"true".equals(subnode.attributeValue("force"))) continue;
                model.setForceDiscriminator(true);
                continue;
            }
            if (!"jcs-cache".equals(name)) continue;
            model.setCache(Configuration.createJCSCache(subnode.attributeValue("usage"), model.getPersistentClass().getName(), model));
        }
        model.createPrimaryKey();
        Binder.propertiesFromXML(node, model, mappings);
    }

    public static void bindColumns(Element node, Value model, boolean isNullable, boolean autoColumn, String defaultColumnName) throws MappingException {
        Column col;
        Attribute columnNode = node.attribute("column");
        if (columnNode == null) {
            Iterator iter = node.elementIterator("column");
            int count = 0;
            while (iter.hasNext()) {
                Attribute uniqueNode;
                Element subnode = (Element)iter.next();
                Table table = model.getTable();
                Column col2 = new Column(model.getType(), count++);
                Binder.bindColumn(subnode, col2, isNullable);
                col2.setName(subnode.attributeValue("name"));
                if (table != null) {
                    table.addColumn(col2);
                }
                model.addColumn(col2);
                Attribute indexNode = subnode.attribute("index");
                if (indexNode != null && table != null) {
                    table.getIndex(indexNode.getValue()).addColumn(col2);
                }
                if ((uniqueNode = subnode.attribute("unique-key")) == null || table == null) continue;
                table.getUniqueKey(uniqueNode.getValue()).addColumn(col2);
            }
        } else {
            col = new Column(model.getType(), 0);
            Binder.bindColumn(node, col, isNullable);
            col.setName(columnNode.getValue());
            Table table = model.getTable();
            if (table != null) {
                table.addColumn(col);
            }
            model.addColumn(col);
        }
        if (autoColumn && model.getColumnSpan() == 0) {
            col = new Column(model.getType(), 0);
            Binder.bindColumn(node, col, isNullable);
            col.setName(defaultColumnName);
            model.getTable().addColumn(col);
            model.addColumn(col);
        }
    }

    public static void bindValue(Element node, Value model, boolean isNullable) throws MappingException {
        model.setType(Binder.getTypeFromXML(node));
        Binder.bindColumns(node, model, isNullable, false, null);
    }

    public static void bindValue(Element node, Value model, boolean isNullable, String defaultColumnName) throws MappingException {
        model.setType(Binder.getTypeFromXML(node));
        Attribute formulaNode = node.attribute("formula");
        if (formulaNode != null) {
            Formula f = new Formula();
            f.setFormula(formulaNode.getText());
            model.setFormula(f);
        } else {
            Binder.bindColumns(node, model, isNullable, true, defaultColumnName);
        }
    }

    public static void bindProperty(Element node, Property model, Mappings mappings) throws MappingException {
        model.setName(Binder.getPropertyName(node));
        Type type = model.getValue().getType();
        if (type == null) {
            throw new MappingException("Could not determine a property type for: " + model.getName());
        }
        Attribute cascadeNode = node.attribute("cascade");
        model.setCascade(cascadeNode == null ? mappings.getDefaultCascade() : cascadeNode.getValue());
        Attribute updateNode = node.attribute("update");
        model.setUpdateable(updateNode == null ? true : "true".equals(updateNode.getValue()));
        Attribute insertNode = node.attribute("insert");
        model.setInsertable(insertNode == null ? true : "true".equals(insertNode.getValue()));
        if (log.isDebugEnabled()) {
            String msg = "Mapped property: " + model.getName();
            String columns = Binder.columns(model.getValue());
            if (columns.length() > 0) {
                msg = msg + " -> " + columns;
            }
            if (model.getType() != null) {
                msg = msg + ", type: " + model.getType().getName();
            }
            log.debug((Object)msg);
        }
    }

    private static String columns(Value val) {
        StringBuffer columns = new StringBuffer();
        Iterator iter = val.getColumnIterator();
        while (iter.hasNext()) {
            columns.append(((Column)iter.next()).getName());
            if (!iter.hasNext()) continue;
            columns.append(", ");
        }
        return columns.toString();
    }

    public static void bindCollection(Element node, Collection model, String prefix, Mappings mappings) throws MappingException {
        Attribute sortedAtt;
        Element oneToManyNode;
        Attribute whereNode;
        Attribute orderNode;
        String propertyName = node.attributeValue("name");
        model.setRole(prefix + '.' + propertyName);
        Attribute inverseNode = node.attribute("inverse");
        if (inverseNode != null) {
            model.setInverse(StringHelper.booleanValue(inverseNode.getValue()));
        }
        if ((orderNode = node.attribute("order-by")) != null) {
            if (Environment.jvmSupportsLinkedHashCollections() || model instanceof Bag) {
                model.setOrderBy(orderNode.getValue());
            } else {
                log.warn((Object)"Attribute \"order-by\" ignored in JDK1.3 or less");
            }
        }
        if ((whereNode = node.attribute("where")) != null) {
            model.setWhere(whereNode.getValue());
        }
        if ((oneToManyNode = node.element("one-to-many")) != null) {
            model.setIsOneToMany(true);
            model.setOneToMany(new OneToMany(model.getOwner()));
            Binder.bindOneToMany(oneToManyNode, model.getOneToMany());
        } else {
            Attribute tableNode = node.attribute("table");
            String tableName = tableNode != null ? tableNode.getValue() : propertyName;
            Attribute schemaNode = node.attribute("schema");
            String schema = schemaNode == null ? mappings.getSchemaName() : schemaNode.getValue();
            model.setTable(mappings.addTable(schema, tableName));
            log.info((Object)("Mapping collection: " + model.getRole() + " -> " + model.getTable().getName()));
        }
        Attribute lazyNode = node.attribute("lazy");
        if (lazyNode != null) {
            model.setLazy(StringHelper.booleanValue(lazyNode.getValue()));
        }
        if ((sortedAtt = node.attribute("sort")) == null || sortedAtt.getValue().equals("unsorted")) {
            model.setSorted(false);
        } else {
            model.setSorted(true);
            String className = sortedAtt.getValue();
            if (!className.equals("natural")) {
                try {
                    model.setComparator((Comparator)ReflectHelper.classForName(className).newInstance());
                }
                catch (Exception e) {
                    throw new MappingException("Could not instantiate comparator class: " + className);
                }
            }
        }
        Attribute cascadeAtt = node.attribute("cascade");
        if (cascadeAtt != null && cascadeAtt.getValue().equals("all-delete-orphan")) {
            model.setOrphanDelete(true);
        }
        if (model instanceof List) {
            mappings.addSecondPass(new ListSecondPass(node, mappings, (List)model));
        } else if (model instanceof Set) {
            mappings.addSecondPass(new SetSecondPass(node, mappings, (Set)model));
        } else if (model instanceof Map) {
            mappings.addSecondPass(new MapSecondPass(node, mappings, (Map)model));
        } else if (model instanceof IdentifierCollection) {
            mappings.addSecondPass(new IdentifierCollectionSecondPass(node, mappings, (IdentifierCollection)model));
        } else {
            mappings.addSecondPass(new CollectionSecondPass(node, mappings, model));
        }
    }

    public static void bindIntegerValue(Element node, IntegerValue model, String defaultColumnName, boolean isNullable) throws MappingException {
        Binder.bindValue(node, model, isNullable, defaultColumnName);
        Column col = (Column)model.getColumnIterator().next();
        col.setType(Hibernate.INTEGER);
        col.setTypeIndex(0);
    }

    public static void bindManyToOne(Element node, ManyToOne model, String defaultColumnName, boolean isNullable) throws MappingException {
        Binder.bindColumns(node, model, isNullable, true, defaultColumnName);
        Binder.initOuterJoinFetchSetting(node, model);
        Attribute typeNode = node.attribute("class");
        if (typeNode != null) {
            try {
                model.setType(TypeFactory.manyToOne(ReflectHelper.classForName(typeNode.getValue())));
            }
            catch (Exception e) {
                throw new MappingException("Could not find class: " + typeNode.getValue());
            }
        }
    }

    public static void bindAny(Element node, Any model, boolean isNullable) throws MappingException {
        model.setIdentifierType(Binder.getTypeFromXML(node));
        Attribute metaAttribute = node.attribute("meta-type");
        if (metaAttribute != null) {
            Type metaType = TypeFactory.hueristicType(metaAttribute.getValue());
            if (metaType == null) {
                throw new MappingException("could not interpret meta-type");
            }
            model.setMetaType(metaType);
        }
        Binder.bindColumns(node, model, isNullable, false, null);
    }

    public static void bindOneToOne(Element node, OneToOne model, boolean isNullable) throws MappingException {
        Binder.bindColumns(node, model, isNullable, false, null);
        Binder.initOuterJoinFetchSetting(node, model);
        Attribute constrNode = node.attribute("constrained");
        boolean constrained = constrNode != null && constrNode.getValue().equals("true");
        model.setConstrained(constrained);
        model.setForeignKeyType(constrained ? AssociationType.FOREIGN_KEY_FROM_PARENT : AssociationType.FOREIGN_KEY_TO_PARENT);
        Attribute typeNode = node.attribute("class");
        if (typeNode != null) {
            try {
                model.setType(TypeFactory.oneToOne(ReflectHelper.classForName(typeNode.getValue()), model.getForeignKeyType()));
            }
            catch (Exception e) {
                throw new MappingException("Could not find class: " + typeNode.getValue());
            }
        }
    }

    public static void bindOneToMany(Element node, OneToMany model) throws MappingException {
        try {
            model.setType((EntityType)Hibernate.entity(ReflectHelper.classForName(node.attributeValue("class"))));
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("Associated class not found", cnfe);
        }
    }

    public static void bindColumn(Element node, Column model, boolean isNullable) {
        Attribute nullNode;
        Attribute lengthNode = node.attribute("length");
        if (lengthNode != null) {
            model.setLength(Integer.parseInt(lengthNode.getValue()));
        }
        model.setNullable((nullNode = node.attribute("not-null")) != null ? !StringHelper.booleanValue(nullNode.getValue()) : isNullable);
        Attribute unqNode = node.attribute("unique");
        model.setUnique(unqNode != null && StringHelper.booleanValue(unqNode.getValue()));
        Attribute typeNode = node.attribute("sql-type");
        model.setSqlType(typeNode == null ? null : typeNode.getValue());
    }

    public static void bindArray(Element node, Array model, String prefix, Mappings mappings) throws MappingException {
        Binder.bindCollection(node, model, prefix, mappings);
        Attribute att = node.attribute("element-class");
        if (att != null) {
            try {
                model.setElementClass(ReflectHelper.classForName(att.getValue()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException(cnfe);
            }
        } else {
            Iterator iter = node.elementIterator();
            while (iter.hasNext()) {
                Element subnode = (Element)iter.next();
                String name = subnode.getName();
                if ("element".equals(name)) {
                    Type type = Binder.getTypeFromXML(subnode);
                    model.setElementClass(model.isPrimitiveArray() ? ((PrimitiveType)type).getPrimitiveClass() : type.getReturnedClass());
                    continue;
                }
                if (!"one-to-many".equals(name) && !"many-to-many".equals(name) && !"composite-element".equals(name)) continue;
                try {
                    model.setElementClass(ReflectHelper.classForName(subnode.attributeValue("class")));
                }
                catch (ClassNotFoundException cnfe) {
                    throw new MappingException(cnfe);
                }
            }
        }
    }

    public static void bindComponent(Element node, Component model, Class reflectedClass, String path, boolean isNullable, Mappings mappings) throws MappingException {
        Property prop;
        String className;
        Attribute classNode = node.attribute("class");
        Attribute dynaclassNode = node.attribute("dynaclass");
        if (dynaclassNode != null) {
            className = dynaclassNode.getValue();
            model.setEmbedded(false);
        } else if (classNode != null) {
            className = classNode.getValue();
            try {
                model.setComponentClass(ReflectHelper.classForName(className));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException("component class not found", cnfe);
            }
            model.setEmbedded(false);
        } else if (reflectedClass != null) {
            model.setComponentClass(reflectedClass);
            className = model.getComponentClass().getName();
            model.setEmbedded(false);
        } else {
            model.setComponentClass(model.getOwner().getPersistentClass());
            className = model.getOwner().getName();
            model.setEmbedded(true);
        }
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            String propertyName = Binder.getPropertyName(subnode);
            String subpath = path + '.' + propertyName;
            CollectionType collectType = CollectionType.collectionTypeFromString(name);
            Value value = null;
            if (collectType != null) {
                Collection collection = collectType.create(subnode, path, model.getOwner(), mappings);
                mappings.addCollection(collection);
                value = new Value(model.getTable());
                Binder.bindValue(subnode, value, isNullable);
                value.setType(collection.getType());
            } else if ("many-to-one".equals(name) || "key-many-to-one".equals(name)) {
                value = new ManyToOne(model.getTable());
                Binder.bindManyToOne(subnode, (ManyToOne)value, propertyName, isNullable);
            } else if ("one-to-one".equals(name)) {
                value = new OneToOne(model.getTable(), model.getOwner().getIdentifier());
                Binder.bindOneToOne(subnode, (OneToOne)value, isNullable);
            } else if ("any".equals(name)) {
                value = new Any(model.getTable());
                Binder.bindAny(subnode, (Any)value, isNullable);
            } else if ("property".equals(name) || "key-property".equals(name)) {
                value = new Value(model.getTable());
                if (value.getFormula() != null) {
                    throw new MappingException("properties of components do not support formula: " + propertyName);
                }
                Binder.bindValue(subnode, value, isNullable, propertyName);
            } else if ("component".equals(name) || "dynabean".equals(name) || "nested-composite-element".equals(name)) {
                Class subreflectedClass = model.getComponentClass() == null ? null : ReflectHelper.getGetter(model.getComponentClass(), propertyName).getReturnType();
                value = model.getOwner() != null ? new Component(model.getOwner()) : new Component(model.getTable());
                Binder.bindComponent(subnode, (Component)value, subreflectedClass, subpath, isNullable, mappings);
            } else if ("parent".equals(name)) {
                model.setParentProperty(propertyName);
            }
            if (value == null) continue;
            Class componentClass = model.getComponentClass();
            if (componentClass != null) {
                value.setTypeByReflection(componentClass, propertyName);
            }
            value.createForeignKey();
            prop = new Property(value);
            Binder.bindProperty(subnode, prop, mappings);
            model.addProperty(prop);
        }
        int span = model.getPropertySpan();
        String[] names = new String[span];
        Type[] types = new Type[span];
        Cascades.CascadeStyle[] cascade = new Cascades.CascadeStyle[span];
        int[] joinedFetch = new int[span];
        DynaProperty[] dynaprops = new DynaProperty[span];
        iter = model.getPropertyIterator();
        int i = 0;
        while (iter.hasNext()) {
            prop = (Property)iter.next();
            names[i] = prop.getName();
            types[i] = prop.getType();
            cascade[i] = prop.getCascadeStyle();
            joinedFetch[i] = prop.getValue().getOuterJoinFetchSetting();
            if (model.getComponentClass() == null) {
                dynaprops[i] = new DynaProperty(names[i], types[i].getReturnedClass());
            }
            ++i;
        }
        if (model.getComponentClass() == null) {
            model.setDynaClass(new BasicDynaClass(className, class$org$apache$commons$beanutils$BasicDynaBean == null ? (class$org$apache$commons$beanutils$BasicDynaBean = Binder.class$("org.apache.commons.beanutils.BasicDynaBean")) : class$org$apache$commons$beanutils$BasicDynaBean, dynaprops));
        }
        model.setType(model.getComponentClass() == null ? new DynaBeanType((DynaClass)model.getDynaClass(), names, types, joinedFetch, cascade) : new ComponentType(model.getComponentClass(), names, types, joinedFetch, cascade, model.getParentProperty(), model.isEmbedded()));
    }

    private static Type getTypeFromXML(Element node) throws MappingException {
        Attribute typeNode = node.attribute("type");
        if (typeNode == null) {
            typeNode = node.attribute("id-type");
        }
        if (typeNode == null) {
            return null;
        }
        Type type = TypeFactory.hueristicType(typeNode.getValue());
        if (type == null) {
            throw new MappingException("Could not interpret type: " + typeNode.getValue());
        }
        return type;
    }

    private static void initOuterJoinFetchSetting(Element node, Association model) {
        Attribute jfNode = node.attribute("outer-join");
        if (jfNode == null) {
            model.setOuterJoinFetchSetting(0);
        } else {
            String eoj = jfNode.getValue();
            if ("auto".equals(eoj)) {
                model.setOuterJoinFetchSetting(0);
            } else {
                model.setOuterJoinFetchSetting("true".equals(eoj) ? 1 : -1);
            }
        }
    }

    private static void makeIdentifier(Element node, Value model, Mappings mappings) throws MappingException {
        Element subnode = node.element("generator");
        if (subnode != null) {
            model.setIdentifierGeneratorStrategy(subnode.attributeValue("class"));
            Properties params = new Properties();
            if (mappings.getSchemaName() != null) {
                params.setProperty("schema", mappings.getSchemaName());
            }
            params.setProperty("target_table", model.getTable().getName());
            params.setProperty("target_column", ((Column)model.getColumnIterator().next()).getName());
            Iterator iter = subnode.elementIterator("param");
            while (iter.hasNext()) {
                Element childNode = (Element)iter.next();
                params.setProperty(childNode.attributeValue("name"), childNode.getText());
            }
            model.setIdentifierGeneratorProperties(params);
        }
        model.getTable().setIdentifierValue(model);
        Attribute nullValueNode = node.attribute("unsaved-value");
        if (nullValueNode != null) {
            model.setNullValue(nullValueNode.getValue());
        } else {
            model.setNullValue("null");
        }
    }

    protected static void propertiesFromXML(Element node, PersistentClass model, Mappings mappings) throws MappingException {
        String path = model.getName();
        Table table = model.getTable();
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Subclass subclass;
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            String propertyName = Binder.getPropertyName(subnode);
            CollectionType collectType = CollectionType.collectionTypeFromString(name);
            Value value = null;
            if (collectType != null) {
                Collection collection = collectType.create(subnode, path, model, mappings);
                mappings.addCollection(collection);
                value = new Value(table);
                Binder.bindValue(subnode, value, true);
                value.setType(collection.getType());
            } else if ("many-to-one".equals(name)) {
                value = new ManyToOne(table);
                Binder.bindManyToOne(subnode, (ManyToOne)value, propertyName, true);
            } else if ("any".equals(name)) {
                value = new Any(table);
                Binder.bindAny(subnode, (Any)value, true);
            } else if ("one-to-one".equals(name)) {
                value = new OneToOne(table, model.getIdentifier());
                Binder.bindOneToOne(subnode, (OneToOne)value, true);
            } else if ("property".equals(name)) {
                value = new Value(table);
                Binder.bindValue(subnode, value, true, propertyName);
            } else if ("component".equals(name) || "dynabean".equals(name)) {
                String subpath = path + '.' + propertyName;
                Class reflectedClass = ReflectHelper.getGetter(model.getPersistentClass(), propertyName).getReturnType();
                value = new Component(model);
                Binder.bindComponent(subnode, (Component)value, reflectedClass, subpath, true, mappings);
            } else if ("subclass".equals(name)) {
                subclass = new Subclass(model);
                Binder.bindSubclass(subnode, subclass, mappings);
                model.addSubclass(subclass);
                mappings.addClass(subclass);
            } else if ("joined-subclass".equals(name)) {
                subclass = new Subclass(model);
                Binder.bindJoinedSubclass(subnode, subclass, mappings);
                model.addSubclass(subclass);
                mappings.addClass(subclass);
            }
            if (value == null) continue;
            value.setTypeByReflection(model.getPersistentClass(), propertyName);
            value.createForeignKey();
            Property prop = new Property(value);
            Binder.bindProperty(subnode, prop, mappings);
            model.addProperty(prop);
        }
    }

    public static void bindSetSecondPass(Element node, Set model, java.util.Map persistentClasses, Mappings mappings) throws MappingException {
        Binder.bindCollectionSecondPass(node, model, persistentClasses, mappings);
        if (!model.isOneToMany()) {
            model.createPrimaryKey();
        }
    }

    public static void bindListSecondPass(Element node, List model, java.util.Map classes, Mappings mappings) throws MappingException {
        Binder.bindCollectionSecondPass(node, model, classes, mappings);
        Element subnode = node.element("index");
        IntegerValue iv = new IntegerValue(model.getTable());
        Binder.bindIntegerValue(subnode, iv, "idx", model.isOneToMany());
        model.setIndex(iv);
        if (!model.isOneToMany()) {
            model.createPrimaryKey();
        }
        Binder.addIndexForIndexedCollection(model);
    }

    public static void bindIdentifierCollectionSecondPass(Element node, IdentifierCollection model, java.util.Map persistentClasses, Mappings mappings) throws MappingException {
        Binder.bindCollectionSecondPass(node, model, persistentClasses, mappings);
        Element subnode = node.element("collection-id");
        Value id = new Value(model.getTable());
        Binder.bindValue(subnode, id, false, "id");
        model.setIdentifier(id);
        Binder.makeIdentifier(subnode, id, mappings);
        if (!model.isOneToMany()) {
            model.createPrimaryKey();
        }
    }

    public static void bindMapSecondPass(Element node, Map model, java.util.Map classes, Mappings mappings) throws MappingException {
        Binder.bindCollectionSecondPass(node, model, classes, mappings);
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            if ("index".equals(name)) {
                Value value = new Value(model.getTable());
                Binder.bindValue(subnode, value, model.isOneToMany(), "idx");
                model.setIndex(value);
                if (model.getIndex().getType() != null) continue;
                throw new MappingException("map index element must specify a type");
            }
            if ("index-many-to-many".equals(name)) {
                ManyToOne mto = new ManyToOne(model.getTable());
                Binder.bindManyToOne(subnode, mto, "idx", model.isOneToMany());
                model.setIndex(mto);
                continue;
            }
            if ("composite-index".equals(name)) {
                Component component = new Component(model.getTable());
                Binder.bindComponent(subnode, component, null, model.getRole() + ".index", model.isOneToMany(), mappings);
                model.setIndex(component);
                continue;
            }
            if (!"index-many-to-any".equals(name)) continue;
            Any any = new Any(model.getTable());
            Binder.bindAny(subnode, any, model.isOneToMany());
            model.setIndex(any);
        }
        if (!model.isInverse()) {
            model.getIndex().createForeignKey();
        }
        if (!model.isOneToMany()) {
            model.createPrimaryKey();
        }
        Binder.addIndexForIndexedCollection(model);
    }

    private static void addIndexForIndexedCollection(IndexedCollection model) {
    }

    public static void bindCollectionSecondPass(Element node, Collection model, java.util.Map persistentClasses, Mappings mappings) throws MappingException {
        if (model.isOneToMany()) {
            Class assocClass = model.getOneToMany().getType().getPersistentClass();
            PersistentClass persistentClass = (PersistentClass)persistentClasses.get(assocClass);
            if (persistentClass == null) {
                throw new MappingException("Association references unmapped class: " + assocClass.getName());
            }
            model.setTable(persistentClass.getTable());
            log.info((Object)("Mapping collection: " + model.getRole() + " -> " + model.getTable().getName()));
        }
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Value element;
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            if ("key".equals(name) || "generated-key".equals(name)) {
                Value key = new Value(model.getTable());
                Binder.bindValue(subnode, key, model.isOneToMany(), "id");
                key.setType(model.getOwner().getIdentifier().getType());
                if (key.getType().getReturnedClass().isArray()) {
                    throw new MappingException("illegal use of an array as an identifier (arrays don't reimplement equals)");
                }
                model.setKey(key);
                continue;
            }
            if ("element".equals(name)) {
                Value elt = new Value(model.getTable());
                model.setElement(elt);
                Binder.bindValue(subnode, elt, true, "elt");
                continue;
            }
            if ("many-to-many".equals(name)) {
                element = new ManyToOne(model.getTable());
                model.setElement(element);
                Binder.bindManyToOne(subnode, element, "elt", false);
                continue;
            }
            if ("composite-element".equals(name)) {
                element = new Component(model.getTable());
                model.setElement(element);
                Binder.bindComponent(subnode, (Component)element, null, model.getRole() + ".element", true, mappings);
                continue;
            }
            if ("many-to-any".equals(name)) {
                element = new Any(model.getTable());
                model.setElement(element);
                Binder.bindAny(subnode, (Any)element, true);
                continue;
            }
            if (!"jcs-cache".equals(name)) continue;
            model.setCache(Configuration.createJCSCache(subnode.attributeValue("usage"), model.getRole(), model.getOwner()));
        }
        if (!model.isInverse()) {
            if (!model.isOneToMany()) {
                model.getElement().createForeignKey();
            }
            model.getKey().createForeignKeyOfClass(model.getOwner().getPersistentClass());
        }
    }

    public static void bindRoot(Document doc, Mappings model) throws MappingException {
        Element n;
        Element hmNode = doc.getRootElement();
        Attribute schemaNode = hmNode.attribute("schema");
        model.setSchemaName(schemaNode == null ? null : schemaNode.getValue());
        Attribute dcNode = hmNode.attribute("default-cascade");
        model.setDefaultCascade(dcNode == null ? "none" : dcNode.getValue());
        Attribute aiNode = hmNode.attribute("auto-import");
        model.setAutoImport(aiNode == null ? true : "true".equals(aiNode.getValue()));
        Iterator nodes = hmNode.elementIterator("class");
        while (nodes.hasNext()) {
            n = (Element)nodes.next();
            RootClass rootclass = new RootClass();
            Binder.bindRootClass(n, rootclass, model);
            model.addClass(rootclass);
        }
        nodes = hmNode.elementIterator("query");
        while (nodes.hasNext()) {
            n = (Element)nodes.next();
            String qname = n.attributeValue("name");
            String query = n.getText();
            log.debug((Object)("Named query: " + qname + " -> " + query));
            model.addQuery(qname, query);
        }
        nodes = hmNode.elementIterator("import");
        while (nodes.hasNext()) {
            n = (Element)nodes.next();
            String className = n.attributeValue("class");
            Attribute renameNode = n.attribute("rename");
            String rename = renameNode == null ? StringHelper.unqualify(className) : renameNode.getValue();
            log.debug((Object)("Import: " + rename + " -> " + className));
            model.addImport(className, rename);
        }
    }

    private static String getPropertyName(Element node) {
        Attribute propertyNameNode = node.attribute("name");
        return propertyNameNode == null ? null : propertyNameNode.getValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static abstract class CollectionType {
        private String xmlTag;
        private static final CollectionType MAP = new CollectionType("map"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                Map map = new Map(owner);
                Binder.bindCollection(node, map, prefix, mappings);
                return map;
            }
        };
        private static final CollectionType SET = new CollectionType("set"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                Set set = new Set(owner);
                Binder.bindCollection(node, set, prefix, mappings);
                return set;
            }
        };
        private static final CollectionType LIST = new CollectionType("list"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                List list = new List(owner);
                Binder.bindCollection(node, list, prefix, mappings);
                return list;
            }
        };
        private static final CollectionType BAG = new CollectionType("bag"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                Bag bag = new Bag(owner);
                Binder.bindCollection(node, bag, prefix, mappings);
                return bag;
            }
        };
        private static final CollectionType IDBAG = new CollectionType("idbag"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                IdentifierBag bag = new IdentifierBag(owner);
                Binder.bindCollection(node, bag, prefix, mappings);
                return bag;
            }
        };
        private static final CollectionType ARRAY = new CollectionType("array"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                Array array = new Array(owner);
                Binder.bindArray(node, array, prefix, mappings);
                return array;
            }
        };
        private static final CollectionType PRIMITIVE_ARRAY = new CollectionType("primitive-array"){

            public Collection create(Element node, String prefix, PersistentClass owner, Mappings mappings) throws MappingException {
                PrimitiveArray array = new PrimitiveArray(owner);
                Binder.bindArray(node, array, prefix, mappings);
                return array;
            }
        };
        private static final HashMap INSTANCES = new HashMap();

        public abstract Collection create(Element var1, String var2, PersistentClass var3, Mappings var4) throws MappingException;

        CollectionType(String xmlTag) {
            this.xmlTag = xmlTag;
        }

        public String toString() {
            return this.xmlTag;
        }

        public static CollectionType collectionTypeFromString(String xmlTagName) {
            return (CollectionType)INSTANCES.get(xmlTagName);
        }

        static {
            INSTANCES.put(MAP.toString(), MAP);
            INSTANCES.put(BAG.toString(), BAG);
            INSTANCES.put(IDBAG.toString(), IDBAG);
            INSTANCES.put(SET.toString(), SET);
            INSTANCES.put(LIST.toString(), LIST);
            INSTANCES.put(ARRAY.toString(), ARRAY);
            INSTANCES.put(PRIMITIVE_ARRAY.toString(), PRIMITIVE_ARRAY);
        }
    }

    static class ListSecondPass
    extends SecondPass {
        ListSecondPass(Element node, Mappings mappings, List collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses) throws MappingException {
            Binder.bindListSecondPass(this.node, (List)this.collection, persistentClasses, this.mappings);
        }
    }

    static class SetSecondPass
    extends SecondPass {
        SetSecondPass(Element node, Mappings mappings, Set collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses) throws MappingException {
            Binder.bindSetSecondPass(this.node, (Set)this.collection, persistentClasses, this.mappings);
        }
    }

    static class MapSecondPass
    extends SecondPass {
        MapSecondPass(Element node, Mappings mappings, Map collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses) throws MappingException {
            Binder.bindMapSecondPass(this.node, (Map)this.collection, persistentClasses, this.mappings);
        }
    }

    static class IdentifierCollectionSecondPass
    extends SecondPass {
        IdentifierCollectionSecondPass(Element node, Mappings mappings, IdentifierCollection collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses) throws MappingException {
            Binder.bindIdentifierCollectionSecondPass(this.node, (IdentifierCollection)this.collection, persistentClasses, this.mappings);
        }
    }

    static class CollectionSecondPass
    extends SecondPass {
        CollectionSecondPass(Element node, Mappings mappings, Collection collection) {
            super(node, mappings, collection);
        }

        void secondPass(java.util.Map persistentClasses) throws MappingException {
            Binder.bindCollectionSecondPass(this.node, this.collection, persistentClasses, this.mappings);
        }
    }

    static abstract class SecondPass {
        Element node;
        Mappings mappings;
        Collection collection;

        SecondPass(Element node, Mappings mappings, Collection collection) {
            this.node = node;
            this.collection = collection;
            this.mappings = mappings;
        }

        final void doSecondPass(java.util.Map persistentClasses) throws MappingException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Second pass for collection: " + this.collection.getRole()));
            }
            this.secondPass(persistentClasses);
            if (log.isDebugEnabled()) {
                String msg = "Mapped collection key: " + Binder.columns(this.collection.getKey());
                if (this.collection.isIndexed()) {
                    msg = msg + ", index: " + Binder.columns(((IndexedCollection)this.collection).getIndex());
                }
                if (this.collection.isOneToMany()) {
                    msg = msg + ", one-to-many: " + this.collection.getOneToMany().getType().getName();
                } else {
                    msg = msg + ", element: " + Binder.columns(this.collection.getElement());
                    msg = msg + ", type: " + this.collection.getElement().getType().getName();
                }
                log.debug((Object)msg);
            }
        }

        abstract void secondPass(java.util.Map var1) throws MappingException;
    }
}

