/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.ODMGCollection;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.LinkedHashCollectionHelper;
import org.odmg.DSet;

public class Set
extends ODMGCollection
implements java.util.Set,
DSet {
    java.util.Set set;
    private transient List tempList;

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        HashMap<Object, Object> clonedSet = new HashMap<Object, Object>(this.set.size());
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            Object copied = persister.getElementType().deepCopy(iter.next());
            clonedSet.put(copied, copied);
        }
        return clonedSet;
    }

    public Collection getOrphans(Serializable snapshot) throws HibernateException {
        Map sn = (Map)((Object)snapshot);
        ArrayList result = new ArrayList();
        result.addAll(sn.keySet());
        PersistentCollection.identityRemoveAll(result, this.set, this.session);
        return result;
    }

    public boolean equalsSnapshot(Type elementType) throws HibernateException {
        Map sn = (Map)((Object)this.getSnapshot());
        if (sn.size() != this.set.size()) {
            return false;
        }
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            Object test = iter.next();
            Object oldValue = sn.get(test);
            if (oldValue != null && !elementType.isDirty(oldValue, test, this.session)) continue;
            return false;
        }
        return true;
    }

    public Set(SessionImplementor session) {
        super(session);
    }

    public Set() {
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.set = persister.hasOrdering() ? LinkedHashCollectionHelper.createLinkedHashSet() : new HashSet();
    }

    public Set(SessionImplementor session, java.util.Set set) {
        super(session);
        this.set = set;
        this.initialized = true;
        this.directlyAccessible = true;
    }

    public Set(SessionImplementor session, CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        super(session);
        this.beforeInitialize(persister);
        Serializable[] array = (Serializable[])disassembled;
        for (int i = 0; i < array.length; ++i) {
            this.set.add(persister.getElementType().assemble(array[i], session, owner));
        }
        this.initialized = true;
    }

    public Iterator elements() {
        return this.set.iterator();
    }

    public boolean empty() {
        return this.set.isEmpty();
    }

    public int size() {
        this.read();
        return this.set.size();
    }

    public boolean isEmpty() {
        this.read();
        return this.set.isEmpty();
    }

    public boolean contains(Object arg0) {
        this.read();
        return this.set.contains(arg0);
    }

    public Iterator iterator() {
        this.read();
        return new PersistentCollection.IteratorProxy(this.set.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.set.toArray();
    }

    public Object[] toArray(Object[] arg0) {
        this.read();
        return this.set.toArray(arg0);
    }

    public boolean add(Object arg0) {
        this.write();
        return this.set.add(arg0);
    }

    public boolean remove(Object arg0) {
        this.write();
        return this.set.remove(arg0);
    }

    public boolean containsAll(Collection arg0) {
        this.read();
        return this.set.containsAll(arg0);
    }

    public boolean addAll(Collection coll) {
        if (coll.size() > 0) {
            this.write();
            return this.set.addAll(coll);
        }
        return false;
    }

    public boolean retainAll(Collection coll) {
        this.write();
        return this.set.retainAll(coll);
    }

    public boolean removeAll(Collection coll) {
        if (coll.size() > 0) {
            this.write();
            return this.set.removeAll(coll);
        }
        return false;
    }

    public void clear() {
        this.write();
        this.set.clear();
    }

    public String toString() {
        this.read();
        return this.set.toString();
    }

    public void writeTo(PreparedStatement st, CollectionPersister persister, Object entry, int i, boolean writeOrder) throws HibernateException, SQLException {
        persister.writeElement(st, entry, writeOrder, this.session);
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, this.session);
        this.tempList.add(element);
        return element;
    }

    public void beginRead() {
        this.tempList = new ArrayList();
    }

    public void endRead() {
        this.set.addAll(this.tempList);
        this.tempList = null;
    }

    public Iterator entries() {
        return this.set.iterator();
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        Serializable[] result = new Serializable[this.set.size()];
        Iterator iter = this.set.iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i++] = persister.getElementType().disassemble(iter.next(), this.session);
        }
        return result;
    }

    public Iterator getDeletes(Type elemType) throws HibernateException {
        Object test;
        Map sn = (Map)((Object)this.getSnapshot());
        ArrayList deletes = new ArrayList(sn.size());
        Iterator<Object> iter = sn.keySet().iterator();
        while (iter.hasNext()) {
            test = iter.next();
            if (this.set.contains(test)) continue;
            deletes.add(test);
        }
        iter = this.set.iterator();
        while (iter.hasNext()) {
            test = iter.next();
            Object oldValue = sn.get(test);
            if (oldValue == null || !elemType.isDirty(test, oldValue, this.session)) continue;
            deletes.add(test);
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        Map sn = (Map)((Object)this.getSnapshot());
        Object oldValue = sn.get(entry);
        return oldValue == null || elemType.isDirty(oldValue, entry, this.session);
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        return false;
    }

    public Object getIndex(Object entry, int i) {
        throw new UnsupportedOperationException("Sets don't have indexes");
    }

    public DSet union(DSet set) {
        this.read();
        HashSet newset = new HashSet(this.set.size());
        newset.addAll(this.set);
        newset.addAll(set);
        return new Set(this.session, newset);
    }

    public DSet difference(DSet set) {
        this.read();
        HashSet newset = new HashSet(this.set.size());
        newset.addAll(this.set);
        newset.removeAll((Collection<?>)set);
        return new Set(this.session, newset);
    }

    public DSet intersection(DSet set) {
        this.read();
        HashSet newset = new HashSet(this.set.size());
        newset.addAll(this.set);
        newset.retainAll((Collection<?>)set);
        return new Set(this.session, newset);
    }

    public boolean properSubsetOf(DSet set) {
        this.read();
        return set.size() > this.set.size() && set.containsAll((Collection)this.set);
    }

    public boolean properSupersetOf(DSet set) {
        this.read();
        return this.set.size() > set.size() && this.set.containsAll((Collection<?>)set);
    }

    public boolean subsetOf(DSet set) {
        this.read();
        return set.size() >= this.set.size() && set.containsAll((Collection)this.set);
    }

    public boolean supersetOf(DSet set) {
        this.read();
        return this.set.size() >= set.size() && this.set.containsAll((Collection<?>)set);
    }

    public boolean equals(Object other) {
        this.read();
        return ((Object)this.set).equals(other);
    }

    public int hashCode() {
        this.read();
        return ((Object)this.set).hashCode();
    }

    public boolean entryExists(Object key, int i) {
        return true;
    }
}

