/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.hql;

import java.util.LinkedList;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.hql.Parser;
import net.sf.hibernate.hql.QueryTranslator;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.QueryJoinFragment;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;

public class PathExpressionParser
implements Parser {
    public static final String ENTITY_ID = "id";
    public static final String ENTITY_CLASS = "class";
    public static final String COLLECTION_SIZE = "size";
    public static final String COLLECTION_ELEMENTS = "elements";
    public static final String COLLECTION_INDICES = "indices";
    public static final String COLLECTION_MAX_INDEX = "maxIndex";
    public static final String COLLECTION_MIN_INDEX = "minIndex";
    public static final String COLLECTION_MAX_ELEMENT = "maxElement";
    public static final String COLLECTION_MIN_ELEMENT = "minElement";
    private int dotcount;
    protected String currentName;
    protected String currentProperty;
    protected QueryJoinFragment join;
    protected String[] columns;
    protected String[] collectionElementColumns;
    protected String collectionName;
    private String collectionOwnerName;
    private String collectionRole;
    private String collectionTable;
    protected Type collectionElementType;
    private String componentPath;
    protected Type type;
    private String path;
    private boolean ignoreInitialJoin;
    private boolean continuation;
    private int joinType = 0;
    private boolean useThetaStyleJoin = true;
    private boolean expectingCollectionIndex;
    private LinkedList collectionElements = new LinkedList();

    void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    void setUseThetaStyleJoin(boolean useThetaStyleJoin) {
        this.useThetaStyleJoin = useThetaStyleJoin;
    }

    private void addJoin(String table, String name, String[] rhsCols, QueryTranslator q) throws QueryException {
        String[] lhsCols = this.currentColumns(q);
        this.join.addJoin(table, name, lhsCols, rhsCols, this.joinType);
    }

    String continueFromManyToMany(Class clazz, String[] joinColumns, QueryTranslator q) throws QueryException {
        this.start(q);
        this.continuation = true;
        this.currentName = q.createNameFor(clazz);
        q.addType(this.currentName, clazz);
        Queryable p = q.getPersister(clazz);
        this.join.addJoin(p.getTableName(), this.currentName, joinColumns, p.getIdentifierColumnNames(), this.joinType);
        return this.currentName;
    }

    public void ignoreInitialJoin() {
        this.ignoreInitialJoin = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void token(String token, QueryTranslator q) throws QueryException {
        String alias;
        if (token != null) {
            this.path = this.path + token;
        }
        if ((alias = q.getPathAlias(this.path)) != null) {
            this.reset(q);
            this.currentName = alias;
            if (this.ignoreInitialJoin) return;
            JoinFragment ojf = q.getPathJoin(this.path);
            this.join.addCondition(ojf.toWhereFragmentString());
            return;
        } else if (".".equals(token)) {
            ++this.dotcount;
            return;
        } else if (this.dotcount == 0) {
            if (this.continuation) return;
            if (!q.isName(token)) {
                throw new QueryException("undefined alias: " + token);
            }
            this.currentName = token;
            return;
        } else if (this.dotcount == 1) {
            if (this.currentName != null) {
                this.currentProperty = token;
                return;
            } else {
                if (this.collectionName == null) throw new QueryException("unexpected");
                CollectionPersister p = q.getCollectionPersister(this.collectionRole);
                this.doCollectionProperty(token, p, this.collectionName);
                this.continuation = false;
            }
            return;
        } else {
            Type propertyType = this.getPropertyType(q);
            if (propertyType == null) {
                throw new QueryException("unresolved property: " + this.path);
            }
            if (propertyType.isComponentType() || propertyType.isObjectType()) {
                if (this.componentPath == null) {
                    this.componentPath = token;
                    return;
                } else {
                    if (token == null) return;
                    this.componentPath = this.componentPath + '.' + token;
                }
                return;
            } else if (propertyType.isEntityType()) {
                Class memberClass = ((EntityType)propertyType).getPersistentClass();
                Queryable memberPersister = q.getPersister(memberClass);
                if (ENTITY_ID.equals(token) || memberPersister.hasIdentifierProperty() && memberPersister.getIdentifierPropertyName().equals(token)) {
                    this.componentPath = this.componentPath == null ? ENTITY_ID : this.componentPath + ".id";
                    return;
                } else {
                    String name = q.createNameFor(memberClass);
                    q.addType(name, memberClass);
                    String[] keyColNames = memberPersister.getIdentifierColumnNames();
                    this.addJoin(memberPersister.getTableName(), name, keyColNames, q);
                    this.currentName = name;
                    this.currentProperty = token;
                    q.addPathAliasAndJoin(this.path.substring(0, this.path.lastIndexOf(46)), name, this.join);
                    this.componentPath = null;
                }
                return;
            } else if (propertyType.isPersistentCollectionType()) {
                this.collectionRole = ((PersistentCollectionType)propertyType).getRole();
                CollectionPersister collPersister = q.getCollectionPersister(this.collectionRole);
                String[] colNames = collPersister.getKeyColumnNames();
                String name = q.createNameForCollection(this.collectionRole);
                String tableName = collPersister.getQualifiedTableName();
                this.addJoin(tableName, name, colNames, q);
                if (collPersister.hasWhere()) {
                    this.join.addCondition(collPersister.getSQLWhereString(name));
                }
                this.doCollectionProperty(token, collPersister, name);
                this.collectionName = name;
                this.collectionOwnerName = this.currentName;
                this.collectionTable = collPersister.getQualifiedTableName();
                this.currentName = null;
                this.currentProperty = null;
                this.componentPath = null;
                return;
            } else {
                if (token == null) return;
                throw new QueryException("dereferenced: " + this.path);
            }
        }
    }

    private String getPropertyPath() {
        if (this.currentProperty == null) {
            return ENTITY_ID;
        }
        String fullPath = this.currentProperty;
        if (this.componentPath != null) {
            fullPath = fullPath + '.' + this.componentPath;
        }
        return fullPath;
    }

    private void setType(QueryTranslator q) throws QueryException {
        if (this.currentProperty == null) {
            Queryable p = q.getPersisterForName(this.currentName);
            this.type = Hibernate.entity(p.getMappedClass());
        } else {
            this.type = this.getPropertyType(q);
        }
    }

    protected Type getPropertyType(QueryTranslator q) throws QueryException {
        String propertyPath = this.getPropertyPath();
        Type propertyType = q.getPersisterForName(this.currentName).getPropertyType(propertyPath);
        if (propertyType == null) {
            throw new QueryException("could not resolve property type: " + propertyPath);
        }
        return propertyType;
    }

    protected String[] currentColumns(QueryTranslator q) throws QueryException {
        String propertyPath = this.getPropertyPath();
        String[] propertyColumns = q.getPersisterForName(this.currentName).toColumns(this.currentName, propertyPath);
        if (propertyColumns == null) {
            throw new QueryException("could not resolve property columns: " + propertyPath);
        }
        return propertyColumns;
    }

    private void reset(QueryTranslator q) {
        this.join = q.createJoinFragment(this.useThetaStyleJoin);
        this.dotcount = 0;
        this.currentName = null;
        this.currentProperty = null;
        this.collectionName = null;
        this.collectionRole = null;
        this.collectionTable = null;
        this.collectionElementColumns = null;
        this.collectionElementType = null;
        this.componentPath = null;
        this.type = null;
        this.collectionName = null;
        this.columns = null;
        this.expectingCollectionIndex = false;
        this.continuation = false;
    }

    public void start(QueryTranslator q) {
        if (!this.continuation) {
            this.reset(q);
            this.path = "";
        }
    }

    public void end(QueryTranslator q) throws QueryException {
        this.ignoreInitialJoin = false;
        if (this.isCollectionValued()) {
            this.columns = this.collectionElementColumns;
            this.type = this.collectionElementType;
        } else {
            Type propertyType;
            if (!this.continuation && (propertyType = this.getPropertyType(q)) != null && propertyType.isPersistentCollectionType()) {
                this.collectionRole = ((PersistentCollectionType)propertyType).getRole();
                this.collectionName = q.createNameForCollection(this.collectionRole);
            }
            if (this.collectionRole != null) {
                CollectionPersister collPersister = q.getCollectionPersister(this.collectionRole);
                if (!collPersister.hasIndex()) {
                    throw new QueryException("unindexed collection before []: " + this.path);
                }
                String[] indexCols = collPersister.getIndexColumnNames();
                if (indexCols.length != 1) {
                    throw new QueryException("composite-index appears in []: " + this.path);
                }
                String[] keyCols = collPersister.getKeyColumnNames();
                QueryJoinFragment ojf = q.createJoinFragment(this.useThetaStyleJoin);
                ((JoinFragment)ojf).addCrossJoin(collPersister.getQualifiedTableName(), this.collectionName);
                if (collPersister.isOneToMany()) {
                    Queryable persister = q.getPersister(((EntityType)collPersister.getElementType()).getPersistentClass());
                    ((JoinFragment)ojf).addJoins(persister.fromJoinFragment(this.collectionName, true, false), persister.whereJoinFragment(this.collectionName, true, false));
                }
                if (!this.continuation) {
                    this.addJoin(collPersister.getQualifiedTableName(), this.collectionName, keyCols, q);
                }
                this.join.addCondition(this.collectionName, indexCols, " = ");
                String[] eltCols = collPersister.getElementColumnNames();
                CollectionElement elem = new CollectionElement();
                elem.elementColumns = StringHelper.prefix(eltCols, this.collectionName + '.');
                elem.type = collPersister.getElementType();
                elem.isOneToMany = collPersister.isOneToMany();
                elem.alias = this.collectionName;
                elem.join = this.join;
                this.collectionElements.addLast(elem);
                this.setExpectingCollectionIndex();
                q.addCollection(this.collectionName, this.collectionRole);
                q.addJoin(this.collectionName, ojf);
            } else {
                this.columns = this.currentColumns(q);
                this.setType(q);
            }
        }
        this.continuation = false;
    }

    public CollectionElement lastCollectionElement() {
        return (CollectionElement)this.collectionElements.removeLast();
    }

    public void setLastCollectionElementIndexValue(String value) {
        ((CollectionElement)this.collectionElements.getLast()).indexValue.append(value);
    }

    public boolean isExpectingCollectionIndex() {
        return this.expectingCollectionIndex;
    }

    protected void setExpectingCollectionIndex() throws QueryException {
        this.expectingCollectionIndex = true;
    }

    public JoinFragment getWhereJoin() {
        return this.join;
    }

    public String getWhereColumn() throws QueryException {
        if (this.columns.length != 1) {
            throw new QueryException("path expression ends in a composite value: " + this.path);
        }
        return this.columns[0];
    }

    public String[] getWhereColumns() {
        return this.columns;
    }

    public Type getWhereColumnType() {
        return this.type;
    }

    public String getName() {
        return this.currentName == null ? this.collectionName : this.currentName;
    }

    public String getCollectionSubquery() throws QueryException {
        return "select " + StringHelper.join(", ", this.collectionElementColumns) + " from " + this.join.toFromFragmentString().substring(2) + " where " + this.join.toWhereFragmentString().substring(5);
    }

    public boolean isCollectionValued() {
        return this.collectionElementColumns != null;
    }

    public void addAssociation(QueryTranslator q) {
        q.addJoin(this.getName(), this.join);
    }

    public String addFromAssociation(QueryTranslator q) {
        q.addFrom(this.currentName, this.join);
        return this.currentName;
    }

    public String addFromCollection(QueryTranslator q) throws QueryException {
        String elementName;
        if (this.collectionElementType == null) {
            throw new QueryException("must specify 'elements' for collection valued property in from clause: " + this.path);
        }
        if (!this.collectionElementType.isEntityType()) {
            throw new QueryException("collection of values in from clause: " + this.path);
        }
        EntityType elemType = (EntityType)this.collectionElementType;
        Class clazz = elemType.getPersistentClass();
        CollectionPersister persister = q.getCollectionPersister(this.collectionRole);
        if (persister.isOneToMany()) {
            elementName = this.collectionName;
        } else {
            q.addCollection(this.collectionName, this.collectionRole);
            Queryable p = q.getPersister(clazz);
            elementName = q.createNameFor(clazz);
            String[] keyColumnNames = p.getIdentifierColumnNames();
            this.join.addJoin(p.getTableName(), elementName, this.collectionElementColumns, keyColumnNames, this.joinType);
        }
        q.addFrom(elementName, clazz, this.join);
        return elementName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getCollectionRole() {
        return this.collectionRole;
    }

    public String getCollectionTable() {
        return this.collectionTable;
    }

    private void doCollectionProperty(String token, CollectionPersister memberPersister, String name) throws QueryException {
        if (token.equals(COLLECTION_ELEMENTS)) {
            String[] cols = memberPersister.getElementColumnNames();
            this.collectionElementColumns = StringHelper.prefix(cols, name + '.');
            this.collectionElementType = memberPersister.getElementType();
        } else if (token.equals(COLLECTION_INDICES)) {
            if (!memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection before .indices");
            }
            String[] cols = memberPersister.getIndexColumnNames();
            this.collectionElementColumns = StringHelper.prefix(cols, name + '.');
            this.collectionElementType = memberPersister.getIndexType();
        } else if (token.equals(COLLECTION_SIZE)) {
            this.collectionElementColumns = new String[]{"count(*)"};
            this.collectionElementType = Hibernate.INTEGER;
        } else if (token.equals(COLLECTION_MAX_INDEX)) {
            if (!memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection before .maxIndex");
            }
            String[] cols = memberPersister.getIndexColumnNames();
            if (cols.length != 1) {
                throw new QueryException("composite collection index in maxIndex");
            }
            this.collectionElementColumns = new String[]{"max(" + cols[0] + ")"};
            this.collectionElementType = memberPersister.getIndexType();
        } else if (token.equals(COLLECTION_MIN_INDEX)) {
            if (!memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection before .minIndex");
            }
            String[] cols = memberPersister.getIndexColumnNames();
            if (cols.length != 1) {
                throw new QueryException("composite collection index in minIndex");
            }
            this.collectionElementColumns = new String[]{"min(" + cols[0] + ")"};
            this.collectionElementType = memberPersister.getIndexType();
        } else if (token.equals(COLLECTION_MAX_ELEMENT)) {
            String[] cols = memberPersister.getElementColumnNames();
            if (cols.length != 1) {
                throw new QueryException("composite collection element in maxElement");
            }
            this.collectionElementColumns = new String[]{"max(" + cols[0] + ")"};
            this.collectionElementType = memberPersister.getElementType();
        } else if (token.equals(COLLECTION_MIN_ELEMENT)) {
            String[] cols = memberPersister.getElementColumnNames();
            if (cols.length != 1) {
                throw new QueryException("composite collection element in minElement");
            }
            this.collectionElementColumns = new String[]{"min(" + cols[0] + ")"};
            this.collectionElementType = memberPersister.getElementType();
        } else {
            throw new QueryException("expecting 'elements' or 'indices' after: " + this.path);
        }
    }

    public String getCollectionOwnerName() {
        return this.collectionOwnerName;
    }

    static final class CollectionElement {
        Type type;
        boolean isOneToMany;
        String alias;
        String[] elementColumns;
        JoinFragment join;
        StringBuffer indexValue = new StringBuffer();

        CollectionElement() {
        }
    }
}

