/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.SessionImpl;

public abstract class ScheduledCollectionAction
implements SessionImpl.Executable {
    private final CollectionPersister persister;
    private final Serializable id;
    private final SessionImplementor session;

    public ScheduledCollectionAction(CollectionPersister persister, Serializable id, SessionImplementor session) {
        this.persister = persister;
        this.session = session;
        this.id = id;
    }

    public void afterTransactionCompletion() throws CacheException {
        this.persister.releaseSoftlock(this.id);
    }

    public Serializable[] getPropertySpaces() {
        return new String[]{this.persister.getQualifiedTableName()};
    }

    protected CollectionPersister getPersister() {
        return this.persister;
    }

    protected Serializable getId() {
        return this.id;
    }

    protected SessionImplementor getSession() {
        return this.session;
    }
}

