/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import java.sql.SQLException;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.ScheduledCollectionAction;
import net.sf.hibernate.impl.SessionImpl;

final class ScheduledCollectionUpdate
extends ScheduledCollectionAction
implements SessionImpl.Executable {
    private final PersistentCollection collection;
    private final boolean emptySnapshot;

    public ScheduledCollectionUpdate(PersistentCollection collection, CollectionPersister persister, Serializable id, boolean emptySnapshot, SessionImplementor session) {
        super(persister, id, session);
        this.collection = collection;
        this.emptySnapshot = emptySnapshot;
    }

    public void execute() throws SQLException, HibernateException {
        this.getPersister().softlock(this.getId());
        if (!this.collection.wasInitialized()) {
            if (!this.collection.hasQueuedAdds()) {
                throw new AssertionFailure("bug processing queued adds");
            }
        } else if (this.collection.empty()) {
            if (!this.emptySnapshot) {
                this.getPersister().remove(this.getId(), this.getSession());
            }
        } else if (this.collection.needsRecreate(this.getPersister())) {
            if (!this.emptySnapshot) {
                this.getPersister().remove(this.getId(), this.getSession());
            }
            this.getPersister().recreate(this.collection, this.getId(), this.getSession());
        } else {
            this.getPersister().deleteRows(this.collection, this.getId(), this.getSession());
            this.getPersister().updateRows(this.collection, this.getId(), this.getSession());
            this.getPersister().insertRows(this.collection, this.getId(), this.getSession());
        }
    }
}

