/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.ps;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sf.hibernate.util.IdentityMap;
import net.sf.hibernate.util.JDBCExceptionReporter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PreparedStatementCache {
    Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$ps$PreparedStatementCache == null ? (class$net$sf$hibernate$ps$PreparedStatementCache = PreparedStatementCache.class$("net.sf.hibernate.ps.PreparedStatementCache")) : class$net$sf$hibernate$ps$PreparedStatementCache));
    private final int maxSize;
    private final ArrayList open = new ArrayList();
    private final Map cache = new HashMap(20);
    private final Map entryMap = IdentityMap.instantiate(20);
    private final LinkedList entries = new LinkedList();
    private short reapCounter = 0;
    static /* synthetic */ Class class$net$sf$hibernate$ps$PreparedStatementCache;

    public PreparedStatementCache(int maxSize) {
        this.maxSize = maxSize;
        this.log.info((Object)("prepared statement cache size: " + maxSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getPreparedStatement(String sql, Connection connection, boolean scrollable) throws SQLException {
        PreparedStatement ps;
        Entry e = new Entry(sql, connection, scrollable);
        PreparedStatementCache preparedStatementCache = this;
        synchronized (preparedStatementCache) {
            if (this.log.isTraceEnabled()) {
                this.open.add(sql);
            }
            if ((ps = (PreparedStatement)this.cache.remove(e)) != null) {
                this.entries.remove(this.entryMap.get(ps));
            }
        }
        if (ps == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("preparing statement: " + sql));
            }
            try {
                ps = scrollable ? connection.prepareStatement(sql, 1004, 1007) : connection.prepareStatement(sql);
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            preparedStatementCache = this;
            synchronized (preparedStatementCache) {
                this.entryMap.put(ps, e);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("returning cached statement: " + sql));
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePreparedStatement(PreparedStatement ps) {
        this.log.trace((Object)"recaching");
        PreparedStatement old = null;
        PreparedStatementCache preparedStatementCache = this;
        synchronized (preparedStatementCache) {
            Entry e = (Entry)this.entryMap.get(ps);
            if (this.log.isTraceEnabled()) {
                this.open.remove(e.sql);
            }
            if ((old = this.cache.put(e, ps)) == null) {
                this.reapCounter = (short)(this.reapCounter + 1);
            } else {
                this.entries.remove(this.entryMap.remove(old));
            }
            this.entries.add(e);
        }
        if (old != null) {
            try {
                old.close();
            }
            catch (SQLException sqle) {
                this.log.warn((Object)"could not close statement", (Throwable)sqle);
            }
        }
        this.reap();
        if (this.log.isTraceEnabled()) {
            preparedStatementCache = this;
            synchronized (preparedStatementCache) {
                this.log.trace((Object)("total checked-out statements: " + (this.entryMap.size() - this.entries.size())));
                this.log.trace((Object)("checked out: " + this.open));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(Connection connection) {
        this.log.trace((Object)"closing all statements for connection");
        ArrayList<PreparedStatement> templist = new ArrayList<PreparedStatement>(25);
        PreparedStatementCache preparedStatementCache = this;
        synchronized (preparedStatementCache) {
            Iterator iter = this.entries.iterator();
            while (iter.hasNext()) {
                Entry e = (Entry)iter.next();
                if (e.connection != connection) continue;
                PreparedStatement ps = (PreparedStatement)this.cache.remove(e);
                templist.add(ps);
                iter.remove();
                this.entryMap.remove(ps);
            }
        }
        this.close(templist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reap() {
        ArrayList<PreparedStatement> templist = new ArrayList<PreparedStatement>(25);
        PreparedStatementCache preparedStatementCache = this;
        synchronized (preparedStatementCache) {
            if (this.reapCounter < 20) {
                return;
            }
            int size = this.entries.size();
            while (this.maxSize < size--) {
                PreparedStatement ps = (PreparedStatement)this.cache.remove(this.entries.removeFirst());
                templist.add(ps);
                this.entryMap.remove(ps);
            }
            this.reapCounter = 0;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("reaping: " + templist.size() + " statements"));
        }
        this.close(templist);
    }

    private void close(Collection statements) {
        Iterator iter = statements.iterator();
        while (iter.hasNext()) {
            try {
                ((PreparedStatement)iter.next()).close();
            }
            catch (SQLException sqle) {
                this.log.warn((Object)"could not close statement", (Throwable)sqle);
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    public synchronized void close() {
        this.log.info((Object)"cleaning up prepared statement cache");
        this.close(this.cache.values());
        this.cache.clear();
        this.entryMap.clear();
        this.entries.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class Entry {
        String sql;
        Connection connection;
        boolean scrollable;

        Entry(String sql, Connection connection, boolean scrollable) {
            this.sql = sql;
            this.connection = connection;
            this.scrollable = scrollable;
        }

        public boolean equals(Object other) {
            Entry oe = (Entry)other;
            return oe.connection == this.connection && oe.scrollable == this.scrollable && oe.sql.equals(this.sql);
        }

        public int hashCode() {
            return this.sql.hashCode();
        }
    }
}

