/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.sql.JoinFragment;

public class ANSIJoinFragment
extends JoinFragment {
    private StringBuffer buffer = new StringBuffer();
    private StringBuffer conditions = new StringBuffer();

    /*
     * WARNING - void declaration
     */
    public void addJoin(String tableName, String alias, String[] fkColumns, String[] pkColumns, int joinType) {
        void var6_6;
        switch (joinType) {
            case 0: {
                String joinString = " inner join ";
                break;
            }
            case 1: {
                String joinString = " left outer join ";
                break;
            }
            case 2: {
                String joinString = " right outer join ";
                break;
            }
            case -1: {
                String joinString = " full outer join ";
                break;
            }
            default: {
                throw new AssertionFailure("undefined join type");
            }
        }
        this.buffer.append((String)var6_6).append(tableName).append(' ').append(alias).append(" on ");
        for (int j = 0; j < fkColumns.length; ++j) {
            if (fkColumns[j].indexOf(46) < 1) {
                throw new AssertionFailure("missing alias");
            }
            this.buffer.append(fkColumns[j]).append('=').append(alias).append('.').append(pkColumns[j]);
            if (j >= fkColumns.length - 1) continue;
            this.buffer.append(" and ");
        }
    }

    public String toFromFragmentString() {
        return this.buffer.toString();
    }

    public String toWhereFragmentString() {
        return this.conditions.toString();
    }

    public void addJoins(String fromFragment, String whereFragment) {
        this.buffer.append(fromFragment);
    }

    public JoinFragment copy() {
        ANSIJoinFragment copy = new ANSIJoinFragment();
        copy.buffer = new StringBuffer(this.buffer.toString());
        return copy;
    }

    public void addCondition(String alias, String[] columns, String condition) {
        for (int i = 0; i < columns.length; ++i) {
            this.conditions.append(" and ").append(alias).append('.').append(columns[i]).append(condition);
        }
    }

    public void addCrossJoin(String tableName, String alias) {
        this.buffer.append(", ").append(tableName).append(' ').append(alias);
    }

    public void addCondition(String alias, String[] fkColumns, String[] pkColumns) {
        throw new UnsupportedOperationException();
    }

    public void addCondition(String condition) {
        throw new UnsupportedOperationException();
    }
}

