/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.type.LiteralType;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.collections.SequencedHashMap;

public class Update {
    private String tableName;
    private String[] primaryKeyColumnNames;
    private String versionColumnName;
    private String where;
    private Map columns = new SequencedHashMap();

    public Update addColumns(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            this.addColumn(columnNames[i]);
        }
        return this;
    }

    public Update addColumns(String[] columnNames, String value) {
        for (int i = 0; i < columnNames.length; ++i) {
            this.addColumn(columnNames[i], value);
        }
        return this;
    }

    public Update addColumn(String columnName) {
        return this.addColumn(columnName, "?");
    }

    public Update addColumn(String columnName, String value) {
        this.columns.put(columnName, value);
        return this;
    }

    public Update addColumn(String columnName, Object value, LiteralType type) throws Exception {
        return this.addColumn(columnName, type.objectToSQLString(value));
    }

    public Update setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Update setWhere(String where) {
        this.where = where;
        return this;
    }

    public String toStatementString() {
        StringBuffer buf = new StringBuffer(this.columns.size() * 15 + this.tableName.length() + 10);
        buf.append("update ").append(this.tableName).append(" set ");
        Iterator iter = this.columns.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            buf.append(e.getKey()).append('=').append(e.getValue());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(" where ").append(StringHelper.join("=? and ", this.primaryKeyColumnNames)).append("=?");
        if (this.where != null) {
            buf.append(" and ").append(this.where);
        }
        if (this.versionColumnName != null) {
            buf.append(" and ").append(this.versionColumnName).append("=?");
        }
        return buf.toString();
    }

    public Update setPrimaryKeyColumnNames(String[] primaryKeyColumnNames) {
        this.primaryKeyColumnNames = primaryKeyColumnNames;
        return this;
    }

    public Update setVersionColumnName(String versionColumnName) {
        this.versionColumnName = versionColumnName;
        return this;
    }
}

