create table customer
(
	id				serial,
	name			varchar(64) not null,
	CONSTRAINT		customer_pk PRIMARY KEY (id)
);

create table orders
(
	id				serial,
	customer		integer not null,
	CONSTRAINT		order_pk PRIMARY KEY (id),
	CONSTRAINT 		order_customer_fk FOREIGN KEY (customer) REFERENCES customer(id)
);

create table products
(
	id			serial,
	name		varchar(100) not null,
	cost		decimal(6,2),
	CONSTRAINT	products_pk PRIMARY KEY (id)
);

create table orderitems
(
	id				serial,
	orders			integer not null,
	product			integer not null,
	quantity		integer not null,
	CONSTRAINT		orderitems_pk PRIMARY KEY (id),
	CONSTRAINT orderitems_orders_fk FOREIGN KEY (orders) REFERENCES orders(id),
	CONSTRAINT orderitems_product_fk FOREIGN KEY (product) REFERENCES products(id)
);	