/**
 * This software program, Simple Data Access Layer (SDAL), is copyrighted by Object
 * Computing inc of St. Louis MO USA. It is provided under the open-source model
 * and is free of license fees. You are free to modify this code for your own use
 * but you may not claim copyright.
 *
 * Since SDAL is open source and free of licensing fees, you are free to use,
 * modify, and distribute the source code, as long as you include this copyright
 * statement.
 *
 * In particular, you can use SDAL to build proprietary software and are under no
 * obligation to redistribute any of your source code that is built using SDAL.
 * Note, however, that you may not do anything to the SDAL code, such as
 * copyrighting it yourself or claiming authorship of the SDAL code, that will
 * prevent SDAL from being distributed freely using an open source development
 * model.
 *
 * Warranty
 * LICENSED PRODUCT, SDAL, IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE,
 * NONINFRINGEMENT, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Support
 * LICENSED PRODUCT, SDAL, IS PROVIDED WITH NO SUPPORT AND WITHOUT ANY OBLIGATION ON THE
 * PART OF OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES TO ASSIST IN ITS USE,
 * CORRECTION, MODIFICATION OR ENHANCEMENT.
 *
 * Support may be available from OCI to users who have agreed to a support
 * contract.
 *
 * Liability
 * OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL HAVE NO LIABILITY WITH
 * RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
 * LICENSED PRODUCT OR ANY PART THEREOF.
 *
 * IN NO EVENT WILL OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE FOR ANY
 * LOST REVENUE OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL DAMAGES,
 * EVEN IF OCI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * Copyright OCI. St. Louis MO USA, 2004
 *
 */
package com.ociweb.service;

import net.sf.hibernate.HibernateException;

import java.util.List;
import java.util.Collection;
import java.util.Locale;
import java.util.Date;
import java.util.Calendar;
import java.io.Serializable;
import java.math.BigDecimal;

import com.ociweb.service.LookupException;
import com.ociweb.service.Query;

class QueryImpl implements Query{
    private net.sf.hibernate.Query query;

    QueryImpl(net.sf.hibernate.Query query) {
        this.query = query;
    }
    public List execute() throws LookupException {
        try {
            return query.list();
        } catch (HibernateException e) {
            throw new LookupException("Unable to execute the Query", e);
        }
    }

    public void setFirstResult(int firstResult) {
        query.setFirstResult(firstResult);
    }

    public void setMaxResults(int maxResults) {
        query.setMaxResults(maxResults);
    }

    public Query setParameter(int i, Object o) throws LookupException {
        try {
            query.setParameter(i, o);
        } catch (HibernateException e) {
            throw exceptionFactory(e);
        }
        return this;
    }

    public Query setParameter(String s, Object o) throws LookupException {
        try {
            query.setParameter(s, o);
        } catch (HibernateException e) {
            throw exceptionFactory(e);
        }
        return this;
    }

    public Query setParameterList(String s, Collection collection) throws LookupException {
        try {
            query.setParameterList(s, collection);
        } catch (HibernateException e) {
            throw exceptionFactory(e);
        }
        return this;
    }

    public Query setParameterList(String s, Object[] objects) throws LookupException {
        try {
            query.setParameterList(s, objects);
        } catch (HibernateException e) {
            throw exceptionFactory(e);
        }
        return this;
    }

    public Query setProperties(Object o) throws LookupException {
        try {
            query.setProperties(o);
        } catch (HibernateException e) {
            throw exceptionFactory(e);
        }
        return this;
    }

    public Query setString(int i, String s) {
        query.setString(i, s);
        return this;
    }

    public Query setCharacter(int i, char c) {
        query.setCharacter(i, c);
        return this;
    }

    public Query setBoolean(int i, boolean b) {
        query.setBoolean(i, b);
        return this;
    }

    public Query setByte(int i, byte b) {
        query.setByte(i, b);
        return this;
    }

    public Query setShort(int i, short i1) {
        query.setShort(i, i1);
        return this;
    }

    public Query setInteger(int i, int i1) {
        query.setInteger(i, i1);
        return this;
    }

    public Query setLong(int i, long l) {
        query.setLong(i, l);
        return this;
    }

    public Query setFloat(int i, float v) {
        query.setFloat(i, v);
        return this;
    }

    public Query setDouble(int i, double v) {
        query.setDouble(i, v);
        return this;
    }

    public Query setBinary(int i, byte[] bytes) {
        query.setBinary(i, bytes);
        return this;
    }

    public Query setSerializable(int i, Serializable serializable) {
        query.setSerializable(i, serializable);
        return this;
    }

    public Query setLocale(int i, Locale locale) {
        query.setLocale(i, locale);
        return this;
    }

    public Query setBigDecimal(int i, BigDecimal bigDecimal) {
        query.setBigDecimal(i, bigDecimal);
        return this;
    }

    public Query setDate(int i, Date date) {
        query.setDate(i, date);
        return this;
    }

    public Query setTime(int i, Date date) {
        query.setTime(i, date);
        return this;
    }

    public Query setTimestamp(int i, Date date) {
        query.setTimestamp(i, date);
        return this;
    }

    public Query setCalendar(int i, Calendar calendar) {
        query.setCalendar(i, calendar);
        return this;
    }

    public Query setCalendarDate(int i, Calendar calendar) {
        query.setCalendarDate(i, calendar);
        return this;
    }

    public Query setString(String s, String s1) {
        query.setString(s, s1);
        return this;
    }

    public Query setCharacter(String s, char c) {
        query.setCharacter(s, c);
        return this;
    }

    public Query setBoolean(String s, boolean b) {
        query.setBoolean(s, b);
        return this;
    }

    public Query setByte(String s, byte b) {
        query.setByte(s, b);
        return this;
    }

    public Query setShort(String s, short i) {
        query.setShort(s, i);
        return this;
    }

    public Query setInteger(String s, int i) {
        query.setInteger(s, i);
        return this;
    }

    public Query setLong(String s, long l) {
        query.setLong(s, l);
        return this;
    }

    public Query setFloat(String s, float v) {
        query.setFloat(s, v);
        return this;
    }

    public Query setDouble(String s, double v) {
        query.setDouble(s, v);
        return this;
    }

    public Query setBinary(String s, byte[] bytes) {
        query.setBinary(s, bytes);
        return this;
    }

    public Query setSerializable(String s, Serializable serializable) {
        query.setSerializable(s, serializable);
        return this;
    }

    public Query setLocale(String s, Locale locale) {
        query.setLocale(s, locale);
        return this;
    }

    public Query setBigDecimal(String s, BigDecimal bigDecimal) {
        query.setBigDecimal(s, bigDecimal);
        return this;
    }

    public Query setDate(String s, Date date) {
        query.setDate(s, date);
        return this;
    }

    public Query setTime(String s, Date date) {
        query.setTime(s, date);
        return this;
    }

    public Query setTimestamp(String s, Date date) {
        query.setTimestamp(s, date);
        return this;
    }

    public Query setCalendar(String s, Calendar calendar) {
        query.setCalendar(s, calendar);
        return this;
    }

    public Query setCalendarDate(String s, Calendar calendar) {
        query.setCalendarDate(s, calendar);
        return this;
    }

    public Query setEntity(int i, Object o) {
        query.setEntity(i, o);
        return this;
    }

    public Query setEntity(String s, Object o) {
        query.setEntity(s, o);
        return this;
    }

    private LookupException exceptionFactory(Exception e) {
        return new LookupException("Unable to build query", e);
    }
}
