/**
 * This software program, Simple Data Access Layer (SDAL), is copyrighted by Object
 * Computing inc of St. Louis MO USA. It is provided under the open-source model
 * and is free of license fees. You are free to modify this code for your own use
 * but you may not claim copyright.
 *
 * Since SDAL is open source and free of licensing fees, you are free to use,
 * modify, and distribute the source code, as long as you include this copyright
 * statement.
 *
 * In particular, you can use SDAL to build proprietary software and are under no
 * obligation to redistribute any of your source code that is built using SDAL.
 * Note, however, that you may not do anything to the SDAL code, such as
 * copyrighting it yourself or claiming authorship of the SDAL code, that will
 * prevent SDAL from being distributed freely using an open source development
 * model.
 *
 * Warranty
 * LICENSED PRODUCT, SDAL, IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE,
 * NONINFRINGEMENT, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Support
 * LICENSED PRODUCT, SDAL, IS PROVIDED WITH NO SUPPORT AND WITHOUT ANY OBLIGATION ON THE
 * PART OF OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES TO ASSIST IN ITS USE,
 * CORRECTION, MODIFICATION OR ENHANCEMENT.
 *
 * Support may be available from OCI to users who have agreed to a support
 * contract.
 *
 * Liability
 * OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL HAVE NO LIABILITY WITH
 * RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
 * LICENSED PRODUCT OR ANY PART THEREOF.
 *
 * IN NO EVENT WILL OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE FOR ANY
 * LOST REVENUE OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL DAMAGES,
 * EVEN IF OCI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * Copyright OCI. St. Louis MO USA, 2004
 *
 */
package com.ociweb.service;

import java.util.Collection;
import java.util.Map;

public class Expression {
    private net.sf.hibernate.expression.Expression expression;

    private Expression(net.sf.hibernate.expression.Expression exp) {
        expression = exp;
    }

    net.sf.hibernate.expression.Expression getExpression() {
        return expression;
    }
    /**
	 * Apply an "equal" constraint to the named property
	 * @param propertyName
	 * @param value
	 * @return ExpressionIntf
	 */
    public static Expression eq(String propertyName, Object value) {
        return new Expression(net.sf.hibernate.expression.Expression.eq(propertyName, value));
    }
    /**
	 * Apply a "like" constraint to the named property
	 * @param propertyName
	 * @param value
	 * @return ExpressionIntf
	 */
    public static Expression like(String propertyName, Object value) {
        return new Expression(net.sf.hibernate.expression.Expression.like(propertyName, value));
    }
    /**
	 * A case-insensitive "like", similar to Postgres <tt>ilike</tt>
	 * operator
	 *
	 * @param propertyName
	 * @param value
	 * @return ExpressionIntf
	 */
    public static Expression ilike(String propertyName, Object value) {
        return new Expression(net.sf.hibernate.expression.Expression.ilike(propertyName, value));
    }
    /**
	 * Apply a "greater than" constraint to the named property
	 * @param propertyName
	 * @param value
	 * @return ExpressionIntf
	 */
    public static Expression gt(String propertyName, Object value) {
        return new Expression(net.sf.hibernate.expression.Expression.gt(propertyName, value));
    }
    /**
	 * Apply a "less than" constraint to the named property
	 * @param propertyName
	 * @param value
	 * @return ExpressionIntf
	 */
    public static Expression lt(String propertyName, Object value) {
        return new Expression(net.sf.hibernate.expression.Expression.lt(propertyName, value));
    }
    /**
	 * Apply a "less than or equal" constraint to the named property
	 * @param propertyName
	 * @param value
	 * @return ExpressionIntf
	 */
    public static Expression le(String propertyName, Object value) {
        return new Expression(net.sf.hibernate.expression.Expression.le(propertyName, value));
    }
    /**
	 * Apply a "greater than or equal" constraint to the named property
	 * @param propertyName
	 * @param value
	 * @return ExpressionIntf
	 */
    public static Expression ge(String propertyName, Object value) {
        return new Expression(net.sf.hibernate.expression.Expression.ge(propertyName, value));
    }
    /**
	 * Apply a "between" constraint to the named property
	 * @param propertyName
	 * @param lo
     * @param hi
	 * @return ExpressionIntf
	 */
    public static Expression between(String propertyName, Object lo, Object hi) {
        return new Expression(net.sf.hibernate.expression.Expression.between(propertyName, lo, hi));
    }
    /**
	 * Apply an "in" constraint to the named property
	 * @param propertyName
	 * @param values
	 * @return ExpressionIntf
	 */
    public static Expression in(String propertyName, Object[] values) {
        return new Expression(net.sf.hibernate.expression.Expression.in(propertyName, values));
    }
    /**
	 * Apply an "in" constraint to the named property
	 * @param propertyName
	 * @param values
	 * @return ExpressionIntf
	 */
    public static Expression in(String propertyName, Collection values) {
        return new Expression(net.sf.hibernate.expression.Expression.in(propertyName, values));
    }
    /**
	 * Apply an "is null" constraint to the named property
	 * @return ExpressionIntf
	 */
    public static Expression isNull(String propertyName) {
        return new Expression(net.sf.hibernate.expression.Expression.isNull(propertyName));
    }
    /**
	 * Apply an "equal" constraint to two properties
	 */
    public static Expression eqProperty(String propertyName, String otherPropertyName) {
        return new Expression(net.sf.hibernate.expression.Expression.eqProperty(propertyName, otherPropertyName));
    }
    /**
	 * Apply a "less than" constraint to two properties
	 */
    public static Expression ltProperty(String propertyName, String otherPropertyName) {
        return new Expression(net.sf.hibernate.expression.Expression.ltProperty(propertyName, otherPropertyName));
    }
    /**
	 * Apply a "less than or equal" constraint to two properties
	 */
    public static Expression leProperty(String propertyName, String otherPropertyName) {
        return new Expression(net.sf.hibernate.expression.Expression.leProperty(propertyName, otherPropertyName));
    }
    /**
	 * Apply an "is not null" constraint to the named property
	 * @return ExpressionIntf
	 */
    public static Expression isNotNull(String propertyName) {
        return new Expression(net.sf.hibernate.expression.Expression.isNotNull(propertyName));
    }
    /**
	 * Return the conjuction of two expressions
	 *
	 * @param lhs
	 * @param rhs
	 * @return ExpressionIntf
	 */
    public static Expression and(Expression lhs, Expression rhs) {
        return new Expression(net.sf.hibernate.expression.Expression.and(lhs.getExpression(), rhs.getExpression()));
    }
    /**
	 * Return the disjuction of two expressions
	 *
	 * @param lhs
	 * @param rhs
	 * @return ExpressionIntf
	 */
    public static Expression or(Expression lhs, Expression rhs) {
        return new Expression(net.sf.hibernate.expression.Expression.or(lhs.getExpression(), rhs.getExpression()));
    }
    /**
	 * Return the negation of an expression
	 *
	 * @param expression
	 * @return ExpressionIntf
	 */
    public Expression not(Expression expression) {
        return new Expression(net.sf.hibernate.expression.Expression.not(expression.getExpression()));
    }
    /**
	 * Apply a constraint expressed in SQL. Any occurrences of <tt>$alias</tt>
	 * will be replaced by the table alias.
	 *
	 * @param sql
	 * @return ExpressionIntf
	 */
    public static Expression sql(String sql) {
        return new Expression(net.sf.hibernate.expression.Expression.sql(sql));
    }
    /**
	 * Apply an "equals" constraint to each property in the
	 * key set of a <tt>Map</tt>
	 *
	 * @param propertyNameValues a map from property names to values
	 * @return ExpressionIntf
	 */
    public static Expression allEq(Map propertyNameValues) {
        return new Expression(net.sf.hibernate.expression.Expression.allEq(propertyNameValues));
    }
}
