/**
 * This software program, Simple Data Access Layer (SDAL), is copyrighted by Object
 * Computing inc of St. Louis MO USA. It is provided under the open-source model
 * and is free of license fees. You are free to modify this code for your own use
 * but you may not claim copyright.
 *
 * Since SDAL is open source and free of licensing fees, you are free to use,
 * modify, and distribute the source code, as long as you include this copyright
 * statement.
 *
 * In particular, you can use SDAL to build proprietary software and are under no
 * obligation to redistribute any of your source code that is built using SDAL.
 * Note, however, that you may not do anything to the SDAL code, such as
 * copyrighting it yourself or claiming authorship of the SDAL code, that will
 * prevent SDAL from being distributed freely using an open source development
 * model.
 *
 * Warranty
 * LICENSED PRODUCT, SDAL, IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE,
 * NONINFRINGEMENT, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Support
 * LICENSED PRODUCT, SDAL, IS PROVIDED WITH NO SUPPORT AND WITHOUT ANY OBLIGATION ON THE
 * PART OF OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES TO ASSIST IN ITS USE,
 * CORRECTION, MODIFICATION OR ENHANCEMENT.
 *
 * Support may be available from OCI to users who have agreed to a support
 * contract.
 *
 * Liability
 * OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL HAVE NO LIABILITY WITH
 * RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
 * LICENSED PRODUCT OR ANY PART THEREOF.
 *
 * IN NO EVENT WILL OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE FOR ANY
 * LOST REVENUE OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL DAMAGES,
 * EVEN IF OCI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * Copyright OCI. St. Louis MO USA, 2004
 *
 */
package net.sf.hibernate;

public class MockSession implements Session {

    public boolean flushCalled;
    public Throwable flushException;
    public void flush() throws net.sf.hibernate.HibernateException {
        flushCalled = true;
        if (flushException != null) {
            if (flushException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) flushException;
            if (flushException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) flushException;
            if (flushException instanceof java.lang.Error)
                throw (java.lang.Error) flushException;
            throw new RuntimeException();
        }
    }

    public boolean setFlushModeCalled;
    public Throwable setFlushModeException;
    public net.sf.hibernate.FlushMode setFlushModeFlushMode;
    public void setFlushMode(net.sf.hibernate.FlushMode flushMode) {
        setFlushModeCalled = true;
        this.setFlushModeFlushMode = flushMode;
        if (setFlushModeException != null) {
            if (setFlushModeException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setFlushModeException;
            if (setFlushModeException instanceof java.lang.Error)
                throw (java.lang.Error) setFlushModeException;
            throw new RuntimeException();
        }
    }

    public boolean getFlushModeCalled;
    public net.sf.hibernate.FlushMode getFlushModeReturn;
    public Throwable getFlushModeException;
    public net.sf.hibernate.FlushMode getFlushMode() {
        getFlushModeCalled = true;
        if (getFlushModeException != null) {
            if (getFlushModeException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) getFlushModeException;
            if (getFlushModeException instanceof java.lang.Error)
                throw (java.lang.Error) getFlushModeException;
            throw new RuntimeException();
        }
        return this.getFlushModeReturn;
    }

    public boolean connectionCalled;
    public java.sql.Connection connectionReturn;
    public Throwable connectionException;
    public java.sql.Connection connection() throws net.sf.hibernate.HibernateException {
        connectionCalled = true;
        if (connectionException != null) {
            if (connectionException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) connectionException;
            if (connectionException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) connectionException;
            if (connectionException instanceof java.lang.Error)
                throw (java.lang.Error) connectionException;
            throw new RuntimeException();
        }
        return this.connectionReturn;
    }

    public boolean disconnectCalled;
    public java.sql.Connection disconnectReturn;
    public Throwable disconnectException;
    public java.sql.Connection disconnect() throws net.sf.hibernate.HibernateException {
        disconnectCalled = true;
        if (disconnectException != null) {
            if (disconnectException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) disconnectException;
            if (disconnectException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) disconnectException;
            if (disconnectException instanceof java.lang.Error)
                throw (java.lang.Error) disconnectException;
            throw new RuntimeException();
        }
        return this.disconnectReturn;
    }

    public boolean reconnectCalled;
    public Throwable reconnectException;
    public void reconnect() throws net.sf.hibernate.HibernateException {
        reconnectCalled = true;
        if (reconnectException != null) {
            if (reconnectException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) reconnectException;
            if (reconnectException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) reconnectException;
            if (reconnectException instanceof java.lang.Error)
                throw (java.lang.Error) reconnectException;
            throw new RuntimeException();
        }
    }

    public boolean reconnect2Called;
    public Throwable reconnect2Exception;
    public java.sql.Connection reconnect2Connection;
    public void reconnect(java.sql.Connection connection) throws net.sf.hibernate.HibernateException {
        reconnect2Called = true;
        this.reconnect2Connection = connection;
        if (reconnect2Exception != null) {
            if (reconnect2Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) reconnect2Exception;
            if (reconnect2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) reconnect2Exception;
            if (reconnect2Exception instanceof java.lang.Error)
                throw (java.lang.Error) reconnect2Exception;
            throw new RuntimeException();
        }
    }

    public boolean closeCalled;
    public java.sql.Connection closeReturn;
    public Throwable closeException;
    public java.sql.Connection close() throws net.sf.hibernate.HibernateException {
        closeCalled = true;
        if (closeException != null) {
            if (closeException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) closeException;
            if (closeException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) closeException;
            if (closeException instanceof java.lang.Error)
                throw (java.lang.Error) closeException;
            throw new RuntimeException();
        }
        return this.closeReturn;
    }

    public boolean isOpenCalled;
    public boolean isOpenReturn;
    public Throwable isOpenException;
    public boolean isOpen() {
        isOpenCalled = true;
        if (isOpenException != null) {
            if (isOpenException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) isOpenException;
            if (isOpenException instanceof java.lang.Error)
                throw (java.lang.Error) isOpenException;
            throw new RuntimeException();
        }
        return this.isOpenReturn;
    }

    public boolean isConnectedCalled;
    public boolean isConnectedReturn;
    public Throwable isConnectedException;
    public boolean isConnected() {
        isConnectedCalled = true;
        if (isConnectedException != null) {
            if (isConnectedException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) isConnectedException;
            if (isConnectedException instanceof java.lang.Error)
                throw (java.lang.Error) isConnectedException;
            throw new RuntimeException();
        }
        return this.isConnectedReturn;
    }

    public boolean getIdentifierCalled;
    public java.io.Serializable getIdentifierReturn;
    public Throwable getIdentifierException;
    public java.lang.Object getIdentifierObject;
    public java.io.Serializable getIdentifier(java.lang.Object object) throws net.sf.hibernate.HibernateException {
        getIdentifierCalled = true;
        this.getIdentifierObject = object;
        if (getIdentifierException != null) {
            if (getIdentifierException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) getIdentifierException;
            if (getIdentifierException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) getIdentifierException;
            if (getIdentifierException instanceof java.lang.Error)
                throw (java.lang.Error) getIdentifierException;
            throw new RuntimeException();
        }
        return this.getIdentifierReturn;
    }

    public boolean containsCalled;
    public boolean containsReturn;
    public Throwable containsException;
    public java.lang.Object containsObject;
    public boolean contains(java.lang.Object object) {
        containsCalled = true;
        this.containsObject = object;
        if (containsException != null) {
            if (containsException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) containsException;
            if (containsException instanceof java.lang.Error)
                throw (java.lang.Error) containsException;
            throw new RuntimeException();
        }
        return this.containsReturn;
    }

    public boolean evictCalled;
    public Throwable evictException;
    public java.lang.Object evictObject;
    public void evict(java.lang.Object object) throws net.sf.hibernate.HibernateException {
        evictCalled = true;
        this.evictObject = object;
        if (evictException != null) {
            if (evictException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) evictException;
            if (evictException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) evictException;
            if (evictException instanceof java.lang.Error)
                throw (java.lang.Error) evictException;
            throw new RuntimeException();
        }
    }

    public boolean loadCalled;
    public java.lang.Object loadReturn;
    public Throwable loadException;
    public java.lang.Class loadTheClass;
    public java.io.Serializable loadId;
    public net.sf.hibernate.LockMode loadLockMode;
    public java.lang.Object load(java.lang.Class theClass, java.io.Serializable id, net.sf.hibernate.LockMode lockMode) throws net.sf.hibernate.HibernateException {
        loadCalled = true;
        this.loadTheClass = theClass;
        this.loadId = id;
        this.loadLockMode = lockMode;
        if (loadException != null) {
            if (loadException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) loadException;
            if (loadException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) loadException;
            if (loadException instanceof java.lang.Error)
                throw (java.lang.Error) loadException;
            throw new RuntimeException();
        }
        return this.loadReturn;
    }

    public boolean load2Called;
    public java.lang.Object load2Return;
    public Throwable load2Exception;
    public java.lang.Class load2TheClass;
    public java.io.Serializable load2Id;
    public java.lang.Object load(java.lang.Class theClass, java.io.Serializable id) throws net.sf.hibernate.HibernateException {
        load2Called = true;
        this.load2TheClass = theClass;
        this.load2Id = id;
        if (load2Exception != null) {
            if (load2Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) load2Exception;
            if (load2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) load2Exception;
            if (load2Exception instanceof java.lang.Error)
                throw (java.lang.Error) load2Exception;
            throw new RuntimeException();
        }
        return this.load2Return;
    }

    public boolean load3Called;
    public Throwable load3Exception;
    public java.lang.Object load3Object;
    public java.io.Serializable load3Id;
    public void load(java.lang.Object object, java.io.Serializable id) throws net.sf.hibernate.HibernateException {
        load3Called = true;
        this.load3Object = object;
        this.load3Id = id;
        if (load3Exception != null) {
            if (load3Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) load3Exception;
            if (load3Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) load3Exception;
            if (load3Exception instanceof java.lang.Error)
                throw (java.lang.Error) load3Exception;
            throw new RuntimeException();
        }
    }

    public boolean saveCalled;
    public java.io.Serializable saveReturn;
    public Throwable saveException;
    public java.lang.Object saveObject;
    public java.io.Serializable save(java.lang.Object object) throws net.sf.hibernate.HibernateException {
        saveCalled = true;
        this.saveObject = object;
        if (saveException != null) {
            if (saveException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) saveException;
            if (saveException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) saveException;
            if (saveException instanceof java.lang.Error)
                throw (java.lang.Error) saveException;
            throw new RuntimeException();
        }
        return this.saveReturn;
    }

    public boolean save2Called;
    public Throwable save2Exception;
    public java.lang.Object save2Object;
    public java.io.Serializable save2Id;
    public void save(java.lang.Object object, java.io.Serializable id) throws net.sf.hibernate.HibernateException {
        save2Called = true;
        this.save2Object = object;
        this.save2Id = id;
        if (save2Exception != null) {
            if (save2Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) save2Exception;
            if (save2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) save2Exception;
            if (save2Exception instanceof java.lang.Error)
                throw (java.lang.Error) save2Exception;
            throw new RuntimeException();
        }
    }

    public boolean saveOrUpdateCalled;
    public Throwable saveOrUpdateException;
    public java.lang.Object saveOrUpdateObject;
    public void saveOrUpdate(java.lang.Object object) throws net.sf.hibernate.HibernateException {
        saveOrUpdateCalled = true;
        this.saveOrUpdateObject = object;
        if (saveOrUpdateException != null) {
            if (saveOrUpdateException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) saveOrUpdateException;
            if (saveOrUpdateException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) saveOrUpdateException;
            if (saveOrUpdateException instanceof java.lang.Error)
                throw (java.lang.Error) saveOrUpdateException;
            throw new RuntimeException();
        }
    }

    public boolean updateCalled;
    public Throwable updateException;
    public java.lang.Object updateObject;
    public void update(java.lang.Object object) throws net.sf.hibernate.HibernateException {
        updateCalled = true;
        this.updateObject = object;
        if (updateException != null) {
            if (updateException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) updateException;
            if (updateException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) updateException;
            if (updateException instanceof java.lang.Error)
                throw (java.lang.Error) updateException;
            throw new RuntimeException();
        }
    }

    public boolean update2Called;
    public Throwable update2Exception;
    public java.lang.Object update2Object;
    public java.io.Serializable update2Id;
    public void update(java.lang.Object object, java.io.Serializable id) throws net.sf.hibernate.HibernateException {
        update2Called = true;
        this.update2Object = object;
        this.update2Id = id;
        if (update2Exception != null) {
            if (update2Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) update2Exception;
            if (update2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) update2Exception;
            if (update2Exception instanceof java.lang.Error)
                throw (java.lang.Error) update2Exception;
            throw new RuntimeException();
        }
    }

    public boolean deleteCalled;
    public Throwable deleteException;
    public java.lang.Object deleteObject;
    public void delete(java.lang.Object object) throws net.sf.hibernate.HibernateException {
        deleteCalled = true;
        this.deleteObject = object;
        if (deleteException != null) {
            if (deleteException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) deleteException;
            if (deleteException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) deleteException;
            if (deleteException instanceof java.lang.Error)
                throw (java.lang.Error) deleteException;
            throw new RuntimeException();
        }
    }

    public boolean findCalled;
    public java.util.List findReturn;
    public Throwable findException;
    public java.lang.String findQuery;
    public java.util.List find(java.lang.String query) throws net.sf.hibernate.HibernateException {
        findCalled = true;
        this.findQuery = query;
        if (findException != null) {
            if (findException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) findException;
            if (findException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) findException;
            if (findException instanceof java.lang.Error)
                throw (java.lang.Error) findException;
            throw new RuntimeException();
        }
        return this.findReturn;
    }

    public boolean find2Called;
    public java.util.List find2Return;
    public Throwable find2Exception;
    public java.lang.String find2Query;
    public java.lang.Object find2Value;
    public net.sf.hibernate.type.Type find2Type;
    public java.util.List find(java.lang.String query, java.lang.Object value, net.sf.hibernate.type.Type type) throws net.sf.hibernate.HibernateException {
        find2Called = true;
        this.find2Query = query;
        this.find2Value = value;
        this.find2Type = type;
        if (find2Exception != null) {
            if (find2Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) find2Exception;
            if (find2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) find2Exception;
            if (find2Exception instanceof java.lang.Error)
                throw (java.lang.Error) find2Exception;
            throw new RuntimeException();
        }
        return this.find2Return;
    }

    public boolean find3Called;
    public java.util.List find3Return;
    public Throwable find3Exception;
    public java.lang.String find3Query;
    public java.lang.Object[] find3Values;
    public net.sf.hibernate.type.Type[] find3Types;
    public java.util.List find(java.lang.String query, java.lang.Object[] values, net.sf.hibernate.type.Type[] types) throws net.sf.hibernate.HibernateException {
        find3Called = true;
        this.find3Query = query;
        this.find3Values = values;
        this.find3Types = types;
        if (find3Exception != null) {
            if (find3Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) find3Exception;
            if (find3Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) find3Exception;
            if (find3Exception instanceof java.lang.Error)
                throw (java.lang.Error) find3Exception;
            throw new RuntimeException();
        }
        return this.find3Return;
    }

    public boolean iterateCalled;
    public java.util.Iterator iterateReturn;
    public Throwable iterateException;
    public java.lang.String iterateQuery;
    public java.util.Iterator iterate(java.lang.String query) throws net.sf.hibernate.HibernateException {
        iterateCalled = true;
        this.iterateQuery = query;
        if (iterateException != null) {
            if (iterateException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) iterateException;
            if (iterateException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) iterateException;
            if (iterateException instanceof java.lang.Error)
                throw (java.lang.Error) iterateException;
            throw new RuntimeException();
        }
        return this.iterateReturn;
    }

    public boolean iterate2Called;
    public java.util.Iterator iterate2Return;
    public Throwable iterate2Exception;
    public java.lang.String iterate2Query;
    public java.lang.Object iterate2Value;
    public net.sf.hibernate.type.Type iterate2Type;
    public java.util.Iterator iterate(java.lang.String query, java.lang.Object value, net.sf.hibernate.type.Type type) throws net.sf.hibernate.HibernateException {
        iterate2Called = true;
        this.iterate2Query = query;
        this.iterate2Value = value;
        this.iterate2Type = type;
        if (iterate2Exception != null) {
            if (iterate2Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) iterate2Exception;
            if (iterate2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) iterate2Exception;
            if (iterate2Exception instanceof java.lang.Error)
                throw (java.lang.Error) iterate2Exception;
            throw new RuntimeException();
        }
        return this.iterate2Return;
    }

    public boolean iterate3Called;
    public java.util.Iterator iterate3Return;
    public Throwable iterate3Exception;
    public java.lang.String iterate3Query;
    public java.lang.Object[] iterate3Values;
    public net.sf.hibernate.type.Type[] iterate3Types;
    public java.util.Iterator iterate(java.lang.String query, java.lang.Object[] values, net.sf.hibernate.type.Type[] types) throws net.sf.hibernate.HibernateException {
        iterate3Called = true;
        this.iterate3Query = query;
        this.iterate3Values = values;
        this.iterate3Types = types;
        if (iterate3Exception != null) {
            if (iterate3Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) iterate3Exception;
            if (iterate3Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) iterate3Exception;
            if (iterate3Exception instanceof java.lang.Error)
                throw (java.lang.Error) iterate3Exception;
            throw new RuntimeException();
        }
        return this.iterate3Return;
    }

    public boolean filterCalled;
    public java.util.Collection filterReturn;
    public Throwable filterException;
    public java.lang.Object filterCollection;
    public java.lang.String filterFilter;
    public java.util.Collection filter(java.lang.Object collection, java.lang.String filter) throws net.sf.hibernate.HibernateException {
        filterCalled = true;
        this.filterCollection = collection;
        this.filterFilter = filter;
        if (filterException != null) {
            if (filterException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) filterException;
            if (filterException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) filterException;
            if (filterException instanceof java.lang.Error)
                throw (java.lang.Error) filterException;
            throw new RuntimeException();
        }
        return this.filterReturn;
    }

    public boolean filter2Called;
    public java.util.Collection filter2Return;
    public Throwable filter2Exception;
    public java.lang.Object filter2Collection;
    public java.lang.String filter2Filter;
    public java.lang.Object filter2Value;
    public net.sf.hibernate.type.Type filter2Type;
    public java.util.Collection filter(java.lang.Object collection, java.lang.String filter, java.lang.Object value, net.sf.hibernate.type.Type type) throws net.sf.hibernate.HibernateException {
        filter2Called = true;
        this.filter2Collection = collection;
        this.filter2Filter = filter;
        this.filter2Value = value;
        this.filter2Type = type;
        if (filter2Exception != null) {
            if (filter2Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) filter2Exception;
            if (filter2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) filter2Exception;
            if (filter2Exception instanceof java.lang.Error)
                throw (java.lang.Error) filter2Exception;
            throw new RuntimeException();
        }
        return this.filter2Return;
    }

    public boolean filter3Called;
    public java.util.Collection filter3Return;
    public Throwable filter3Exception;
    public java.lang.Object filter3Collection;
    public java.lang.String filter3Filter;
    public java.lang.Object[] filter3Values;
    public net.sf.hibernate.type.Type[] filter3Types;
    public java.util.Collection filter(java.lang.Object collection, java.lang.String filter, java.lang.Object[] values, net.sf.hibernate.type.Type[] types) throws net.sf.hibernate.HibernateException {
        filter3Called = true;
        this.filter3Collection = collection;
        this.filter3Filter = filter;
        this.filter3Values = values;
        this.filter3Types = types;
        if (filter3Exception != null) {
            if (filter3Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) filter3Exception;
            if (filter3Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) filter3Exception;
            if (filter3Exception instanceof java.lang.Error)
                throw (java.lang.Error) filter3Exception;
            throw new RuntimeException();
        }
        return this.filter3Return;
    }

    public boolean delete2Called;
    public int delete2Return;
    public Throwable delete2Exception;
    public java.lang.String delete2Query;
    public int delete(java.lang.String query) throws net.sf.hibernate.HibernateException {
        delete2Called = true;
        this.delete2Query = query;
        if (delete2Exception != null) {
            if (delete2Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) delete2Exception;
            if (delete2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) delete2Exception;
            if (delete2Exception instanceof java.lang.Error)
                throw (java.lang.Error) delete2Exception;
            throw new RuntimeException();
        }
        return this.delete2Return;
    }

    public boolean delete3Called;
    public int delete3Return;
    public Throwable delete3Exception;
    public java.lang.String delete3Query;
    public java.lang.Object delete3Value;
    public net.sf.hibernate.type.Type delete3Type;
    public int delete(java.lang.String query, java.lang.Object value, net.sf.hibernate.type.Type type) throws net.sf.hibernate.HibernateException {
        delete3Called = true;
        this.delete3Query = query;
        this.delete3Value = value;
        this.delete3Type = type;
        if (delete3Exception != null) {
            if (delete3Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) delete3Exception;
            if (delete3Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) delete3Exception;
            if (delete3Exception instanceof java.lang.Error)
                throw (java.lang.Error) delete3Exception;
            throw new RuntimeException();
        }
        return this.delete3Return;
    }

    public boolean delete4Called;
    public int delete4Return;
    public Throwable delete4Exception;
    public java.lang.String delete4Query;
    public java.lang.Object[] delete4Values;
    public net.sf.hibernate.type.Type[] delete4Types;
    public int delete(java.lang.String query, java.lang.Object[] values, net.sf.hibernate.type.Type[] types) throws net.sf.hibernate.HibernateException {
        delete4Called = true;
        this.delete4Query = query;
        this.delete4Values = values;
        this.delete4Types = types;
        if (delete4Exception != null) {
            if (delete4Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) delete4Exception;
            if (delete4Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) delete4Exception;
            if (delete4Exception instanceof java.lang.Error)
                throw (java.lang.Error) delete4Exception;
            throw new RuntimeException();
        }
        return this.delete4Return;
    }

    public boolean lockCalled;
    public Throwable lockException;
    public java.lang.Object lockObject;
    public net.sf.hibernate.LockMode lockLockMode;
    public void lock(java.lang.Object object, net.sf.hibernate.LockMode lockMode) throws net.sf.hibernate.HibernateException {
        lockCalled = true;
        this.lockObject = object;
        this.lockLockMode = lockMode;
        if (lockException != null) {
            if (lockException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) lockException;
            if (lockException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) lockException;
            if (lockException instanceof java.lang.Error)
                throw (java.lang.Error) lockException;
            throw new RuntimeException();
        }
    }

    public boolean refreshCalled;
    public Throwable refreshException;
    public java.lang.Object refreshObject;
    public void refresh(java.lang.Object object) throws net.sf.hibernate.HibernateException {
        refreshCalled = true;
        this.refreshObject = object;
        if (refreshException != null) {
            if (refreshException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) refreshException;
            if (refreshException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) refreshException;
            if (refreshException instanceof java.lang.Error)
                throw (java.lang.Error) refreshException;
            throw new RuntimeException();
        }
    }

    public boolean refresh2Called;
    public Throwable refresh2Exception;
    public java.lang.Object refresh2Object;
    public net.sf.hibernate.LockMode refresh2LockMode;
    public void refresh(java.lang.Object object, net.sf.hibernate.LockMode lockMode) throws net.sf.hibernate.HibernateException {
        refresh2Called = true;
        this.refresh2Object = object;
        this.refresh2LockMode = lockMode;
        if (refresh2Exception != null) {
            if (refresh2Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) refresh2Exception;
            if (refresh2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) refresh2Exception;
            if (refresh2Exception instanceof java.lang.Error)
                throw (java.lang.Error) refresh2Exception;
            throw new RuntimeException();
        }
    }

    public boolean getCurrentLockModeCalled;
    public net.sf.hibernate.LockMode getCurrentLockModeReturn;
    public Throwable getCurrentLockModeException;
    public java.lang.Object getCurrentLockModeObject;
    public net.sf.hibernate.LockMode getCurrentLockMode(java.lang.Object object) throws net.sf.hibernate.HibernateException {
        getCurrentLockModeCalled = true;
        this.getCurrentLockModeObject = object;
        if (getCurrentLockModeException != null) {
            if (getCurrentLockModeException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) getCurrentLockModeException;
            if (getCurrentLockModeException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) getCurrentLockModeException;
            if (getCurrentLockModeException instanceof java.lang.Error)
                throw (java.lang.Error) getCurrentLockModeException;
            throw new RuntimeException();
        }
        return this.getCurrentLockModeReturn;
    }

    public boolean beginTransactionCalled;
    public net.sf.hibernate.Transaction beginTransactionReturn;
    public Throwable beginTransactionException;
    public net.sf.hibernate.Transaction beginTransaction() throws net.sf.hibernate.HibernateException {
        beginTransactionCalled = true;
        if (beginTransactionException != null) {
            if (beginTransactionException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) beginTransactionException;
            if (beginTransactionException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) beginTransactionException;
            if (beginTransactionException instanceof java.lang.Error)
                throw (java.lang.Error) beginTransactionException;
            throw new RuntimeException();
        }
        return this.beginTransactionReturn;
    }

    public boolean createCriteriaCalled;
    public net.sf.hibernate.Criteria createCriteriaReturn;
    public Throwable createCriteriaException;
    public java.lang.Class createCriteriaPersistentClass;
    public net.sf.hibernate.Criteria createCriteria(java.lang.Class persistentClass) {
        createCriteriaCalled = true;
        this.createCriteriaPersistentClass = persistentClass;
        if (createCriteriaException != null) {
            if (createCriteriaException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) createCriteriaException;
            if (createCriteriaException instanceof java.lang.Error)
                throw (java.lang.Error) createCriteriaException;
            throw new RuntimeException();
        }
        return this.createCriteriaReturn;
    }

    public boolean createQueryCalled;
    public net.sf.hibernate.Query createQueryReturn;
    public Throwable createQueryException;
    public java.lang.String createQueryQueryString;
    public net.sf.hibernate.Query createQuery(java.lang.String queryString) throws net.sf.hibernate.HibernateException {
        createQueryCalled = true;
        this.createQueryQueryString = queryString;
        if (createQueryException != null) {
            if (createQueryException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) createQueryException;
            if (createQueryException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) createQueryException;
            if (createQueryException instanceof java.lang.Error)
                throw (java.lang.Error) createQueryException;
            throw new RuntimeException();
        }
        return this.createQueryReturn;
    }

    public boolean createFilterCalled;
    public net.sf.hibernate.Query createFilterReturn;
    public Throwable createFilterException;
    public java.lang.Object createFilterCollection;
    public java.lang.String createFilterQueryString;
    public net.sf.hibernate.Query createFilter(java.lang.Object collection, java.lang.String queryString) throws net.sf.hibernate.HibernateException {
        createFilterCalled = true;
        this.createFilterCollection = collection;
        this.createFilterQueryString = queryString;
        if (createFilterException != null) {
            if (createFilterException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) createFilterException;
            if (createFilterException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) createFilterException;
            if (createFilterException instanceof java.lang.Error)
                throw (java.lang.Error) createFilterException;
            throw new RuntimeException();
        }
        return this.createFilterReturn;
    }

    public boolean getNamedQueryCalled;
    public net.sf.hibernate.Query getNamedQueryReturn;
    public Throwable getNamedQueryException;
    public java.lang.String getNamedQueryQueryName;
    public net.sf.hibernate.Query getNamedQuery(java.lang.String queryName) throws net.sf.hibernate.HibernateException {
        getNamedQueryCalled = true;
        this.getNamedQueryQueryName = queryName;
        if (getNamedQueryException != null) {
            if (getNamedQueryException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) getNamedQueryException;
            if (getNamedQueryException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) getNamedQueryException;
            if (getNamedQueryException instanceof java.lang.Error)
                throw (java.lang.Error) getNamedQueryException;
            throw new RuntimeException();
        }
        return this.getNamedQueryReturn;
    }

}