/**
 * This software program, Simple Data Access Layer (SDAL), is copyrighted by Object
 * Computing inc of St. Louis MO USA. It is provided under the open-source model
 * and is free of license fees. You are free to modify this code for your own use
 * but you may not claim copyright.
 *
 * Since SDAL is open source and free of licensing fees, you are free to use,
 * modify, and distribute the source code, as long as you include this copyright
 * statement.
 *
 * In particular, you can use SDAL to build proprietary software and are under no
 * obligation to redistribute any of your source code that is built using SDAL.
 * Note, however, that you may not do anything to the SDAL code, such as
 * copyrighting it yourself or claiming authorship of the SDAL code, that will
 * prevent SDAL from being distributed freely using an open source development
 * model.
 *
 * Warranty
 * LICENSED PRODUCT, SDAL, IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE,
 * NONINFRINGEMENT, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Support
 * LICENSED PRODUCT, SDAL, IS PROVIDED WITH NO SUPPORT AND WITHOUT ANY OBLIGATION ON THE
 * PART OF OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES TO ASSIST IN ITS USE,
 * CORRECTION, MODIFICATION OR ENHANCEMENT.
 *
 * Support may be available from OCI to users who have agreed to a support
 * contract.
 *
 * Liability
 * OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL HAVE NO LIABILITY WITH
 * RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
 * LICENSED PRODUCT OR ANY PART THEREOF.
 *
 * IN NO EVENT WILL OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE FOR ANY
 * LOST REVENUE OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL DAMAGES,
 * EVEN IF OCI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * Copyright OCI. St. Louis MO USA, 2004
 *
 */
package net.sf.hibernate;

public class MockTransaction implements Transaction {

    public boolean commitCalled;
    public Throwable commitException;
    public void commit() throws net.sf.hibernate.HibernateException {
        commitCalled = true;
        if (commitException != null) {
            if (commitException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) commitException;
            if (commitException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) commitException;
            if (commitException instanceof java.lang.Error)
                throw (java.lang.Error) commitException;
            throw new RuntimeException();
        }
    }

    public boolean rollbackCalled;
    public Throwable rollbackException;
    public void rollback() throws net.sf.hibernate.HibernateException {
        rollbackCalled = true;
        if (rollbackException != null) {
            if (rollbackException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) rollbackException;
            if (rollbackException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) rollbackException;
            if (rollbackException instanceof java.lang.Error)
                throw (java.lang.Error) rollbackException;
            throw new RuntimeException();
        }
    }

    public boolean wasRolledBackCalled;
    public boolean wasRolledBackReturn;
    public Throwable wasRolledBackException;
    public boolean wasRolledBack() throws net.sf.hibernate.HibernateException {
        wasRolledBackCalled = true;
        if (wasRolledBackException != null) {
            if (wasRolledBackException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) wasRolledBackException;
            if (wasRolledBackException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) wasRolledBackException;
            if (wasRolledBackException instanceof java.lang.Error)
                throw (java.lang.Error) wasRolledBackException;
            throw new RuntimeException();
        }
        return this.wasRolledBackReturn;
    }

    public boolean wasCommittedCalled;
    public boolean wasCommittedReturn;
    public Throwable wasCommittedException;
    public boolean wasCommitted() throws net.sf.hibernate.HibernateException {
        wasCommittedCalled = true;
        if (wasCommittedException != null) {
            if (wasCommittedException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) wasCommittedException;
            if (wasCommittedException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) wasCommittedException;
            if (wasCommittedException instanceof java.lang.Error)
                throw (java.lang.Error) wasCommittedException;
            throw new RuntimeException();
        }
        return this.wasCommittedReturn;
    }

}