/**
 * This software program, Simple Data Access Layer (SDAL), is copyrighted by Object
 * Computing inc of St. Louis MO USA. It is provided under the open-source model
 * and is free of license fees. You are free to modify this code for your own use
 * but you may not claim copyright.
 *
 * Since SDAL is open source and free of licensing fees, you are free to use,
 * modify, and distribute the source code, as long as you include this copyright
 * statement.
 *
 * In particular, you can use SDAL to build proprietary software and are under no
 * obligation to redistribute any of your source code that is built using SDAL.
 * Note, however, that you may not do anything to the SDAL code, such as
 * copyrighting it yourself or claiming authorship of the SDAL code, that will
 * prevent SDAL from being distributed freely using an open source development
 * model.
 *
 * Warranty
 * LICENSED PRODUCT, SDAL, IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE,
 * NONINFRINGEMENT, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Support
 * LICENSED PRODUCT, SDAL, IS PROVIDED WITH NO SUPPORT AND WITHOUT ANY OBLIGATION ON THE
 * PART OF OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES TO ASSIST IN ITS USE,
 * CORRECTION, MODIFICATION OR ENHANCEMENT.
 *
 * Support may be available from OCI to users who have agreed to a support
 * contract.
 *
 * Liability
 * OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL HAVE NO LIABILITY WITH
 * RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
 * LICENSED PRODUCT OR ANY PART THEREOF.
 *
 * IN NO EVENT WILL OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE FOR ANY
 * LOST REVENUE OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL DAMAGES,
 * EVEN IF OCI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * Copyright OCI. St. Louis MO USA, 2004
 *
 */
package com.ociweb.service;

import com.ociweb.service.LookupException;

import java.util.Collection;
import java.util.Locale;
import java.util.Date;
import java.util.Calendar;
import java.io.Serializable;
import java.math.BigDecimal;

public interface Query extends CommonQuery {

    Query setParameter(int i, Object o) throws LookupException;

    Query setParameter(String s, Object o) throws LookupException;

    Query setParameterList(String s, Collection collection) throws LookupException;

    Query setParameterList(String s, Object[] objects) throws LookupException;

    Query setProperties(Object o) throws LookupException;

    Query setString(int i, String s);

    Query setCharacter(int i, char c);

    Query setBoolean(int i, boolean b);

    Query setByte(int i, byte b);

    Query setShort(int i, short i1);

    Query setInteger(int i, int i1);

    Query setLong(int i, long l);

    Query setFloat(int i, float v);

    Query setDouble(int i, double v);

    Query setBinary(int i, byte[] bytes);

    Query setSerializable(int i, Serializable serializable);

    Query setLocale(int i, Locale locale);

    Query setBigDecimal(int i, BigDecimal bigDecimal);

    Query setDate(int i, Date date);

    Query setTime(int i, Date date);

    Query setTimestamp(int i, Date date);

    Query setCalendar(int i, Calendar calendar);

    Query setCalendarDate(int i, Calendar calendar);

    Query setString(String s, String s1);

    Query setCharacter(String s, char c);

    Query setBoolean(String s, boolean b);

    Query setByte(String s, byte b);

    Query setShort(String s, short i);

    Query setInteger(String s, int i);

    Query setLong(String s, long l);

    Query setFloat(String s, float v);

    Query setDouble(String s, double v);

    Query setBinary(String s, byte[] bytes);

    Query setSerializable(String s, Serializable serializable);

    Query setLocale(String s, Locale locale);

    Query setBigDecimal(String s, BigDecimal bigDecimal);

    Query setDate(String s, Date date);

    Query setTime(String s, Date date);

    Query setTimestamp(String s, Date date);

    Query setCalendar(String s, Calendar calendar);

    Query setCalendarDate(String s, Calendar calendar);

    Query setEntity(int i, Object o);

    Query setEntity(String s, Object o);
}
