/**
 * This software program, Simple Data Access Layer (SDAL), is copyrighted by Object
 * Computing inc of St. Louis MO USA. It is provided under the open-source model
 * and is free of license fees. You are free to modify this code for your own use
 * but you may not claim copyright.
 *
 * Since SDAL is open source and free of licensing fees, you are free to use,
 * modify, and distribute the source code, as long as you include this copyright
 * statement.
 *
 * In particular, you can use SDAL to build proprietary software and are under no
 * obligation to redistribute any of your source code that is built using SDAL.
 * Note, however, that you may not do anything to the SDAL code, such as
 * copyrighting it yourself or claiming authorship of the SDAL code, that will
 * prevent SDAL from being distributed freely using an open source development
 * model.
 *
 * Warranty
 * LICENSED PRODUCT, SDAL, IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE,
 * NONINFRINGEMENT, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Support
 * LICENSED PRODUCT, SDAL, IS PROVIDED WITH NO SUPPORT AND WITHOUT ANY OBLIGATION ON THE
 * PART OF OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES TO ASSIST IN ITS USE,
 * CORRECTION, MODIFICATION OR ENHANCEMENT.
 *
 * Support may be available from OCI to users who have agreed to a support
 * contract.
 *
 * Liability
 * OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL HAVE NO LIABILITY WITH
 * RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
 * LICENSED PRODUCT OR ANY PART THEREOF.
 *
 * IN NO EVENT WILL OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE FOR ANY
 * LOST REVENUE OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL DAMAGES,
 * EVEN IF OCI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * Copyright OCI. St. Louis MO USA, 2004
 *
 */
package com.ociweb.service;

public class MockQueryFactory implements QueryFactory {

    public boolean newQueryCalled;
    public com.ociweb.service.Query newQueryReturn;
    public Throwable newQueryException;
    public java.lang.String newQueryQuery;
    public com.ociweb.service.Query newQuery(java.lang.String query) throws com.ociweb.service.LookupException {
        newQueryCalled = true;
        this.newQueryQuery = query;
        if (newQueryException != null) {
            if (newQueryException instanceof com.ociweb.service.LookupException)
                throw (com.ociweb.service.LookupException) newQueryException;
            if (newQueryException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) newQueryException;
            if (newQueryException instanceof java.lang.Error)
                throw (java.lang.Error) newQueryException;
            throw new RuntimeException();
        }
        return this.newQueryReturn;
    }

    public boolean getNamedQueryCalled;
    public com.ociweb.service.Query getNamedQueryReturn;
    public Throwable getNamedQueryException;
    public java.lang.String getNamedQueryName;
    public com.ociweb.service.Query getNamedQuery(java.lang.String name) throws com.ociweb.service.LookupException {
        getNamedQueryCalled = true;
        this.getNamedQueryName = name;
        if (getNamedQueryException != null) {
            if (getNamedQueryException instanceof com.ociweb.service.LookupException)
                throw (com.ociweb.service.LookupException) getNamedQueryException;
            if (getNamedQueryException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) getNamedQueryException;
            if (getNamedQueryException instanceof java.lang.Error)
                throw (java.lang.Error) getNamedQueryException;
            throw new RuntimeException();
        }
        return this.getNamedQueryReturn;
    }

    public boolean newCriteriaQueryCalled;
    public com.ociweb.service.CriteriaQuery newCriteriaQueryReturn;
    public Throwable newCriteriaQueryException;
    public java.lang.Class newCriteriaQueryDomainClass;
    public com.ociweb.service.CriteriaQuery newCriteriaQuery(java.lang.Class domainClass) {
        newCriteriaQueryCalled = true;
        this.newCriteriaQueryDomainClass = domainClass;
        if (newCriteriaQueryException != null) {
            if (newCriteriaQueryException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) newCriteriaQueryException;
            if (newCriteriaQueryException instanceof java.lang.Error)
                throw (java.lang.Error) newCriteriaQueryException;
            throw new RuntimeException();
        }
        return this.newCriteriaQueryReturn;
    }

}