/**
 * This software program, Simple Data Access Layer (SDAL), is copyrighted by Object
 * Computing inc of St. Louis MO USA. It is provided under the open-source model
 * and is free of license fees. You are free to modify this code for your own use
 * but you may not claim copyright.
 *
 * Since SDAL is open source and free of licensing fees, you are free to use,
 * modify, and distribute the source code, as long as you include this copyright
 * statement.
 *
 * In particular, you can use SDAL to build proprietary software and are under no
 * obligation to redistribute any of your source code that is built using SDAL.
 * Note, however, that you may not do anything to the SDAL code, such as
 * copyrighting it yourself or claiming authorship of the SDAL code, that will
 * prevent SDAL from being distributed freely using an open source development
 * model.
 *
 * Warranty
 * LICENSED PRODUCT, SDAL, IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE,
 * NONINFRINGEMENT, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Support
 * LICENSED PRODUCT, SDAL, IS PROVIDED WITH NO SUPPORT AND WITHOUT ANY OBLIGATION ON THE
 * PART OF OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES TO ASSIST IN ITS USE,
 * CORRECTION, MODIFICATION OR ENHANCEMENT.
 *
 * Support may be available from OCI to users who have agreed to a support
 * contract.
 *
 * Liability
 * OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL HAVE NO LIABILITY WITH
 * RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
 * LICENSED PRODUCT OR ANY PART THEREOF.
 *
 * IN NO EVENT WILL OCI OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE FOR ANY
 * LOST REVENUE OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL DAMAGES,
 * EVEN IF OCI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * Copyright OCI. St. Louis MO USA, 2004
 *
 */
package net.sf.hibernate;

public class MockQuery implements Query {

    public boolean getQueryStringCalled;
    public java.lang.String getQueryStringReturn;
    public Throwable getQueryStringException;
    public java.lang.String getQueryString() {
        getQueryStringCalled = true;
        if (getQueryStringException != null) {
            if (getQueryStringException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) getQueryStringException;
            if (getQueryStringException instanceof java.lang.Error)
                throw (java.lang.Error) getQueryStringException;
            throw new RuntimeException();
        }
        return this.getQueryStringReturn;
    }

    public boolean getReturnTypesCalled;
    public net.sf.hibernate.type.Type[] getReturnTypesReturn;
    public Throwable getReturnTypesException;
    public net.sf.hibernate.type.Type[] getReturnTypes() throws net.sf.hibernate.HibernateException {
        getReturnTypesCalled = true;
        if (getReturnTypesException != null) {
            if (getReturnTypesException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) getReturnTypesException;
            if (getReturnTypesException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) getReturnTypesException;
            if (getReturnTypesException instanceof java.lang.Error)
                throw (java.lang.Error) getReturnTypesException;
            throw new RuntimeException();
        }
        return this.getReturnTypesReturn;
    }

    public boolean getNamedParametersCalled;
    public java.lang.String[] getNamedParametersReturn;
    public Throwable getNamedParametersException;
    public java.lang.String[] getNamedParameters() throws net.sf.hibernate.HibernateException {
        getNamedParametersCalled = true;
        if (getNamedParametersException != null) {
            if (getNamedParametersException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) getNamedParametersException;
            if (getNamedParametersException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) getNamedParametersException;
            if (getNamedParametersException instanceof java.lang.Error)
                throw (java.lang.Error) getNamedParametersException;
            throw new RuntimeException();
        }
        return this.getNamedParametersReturn;
    }

    public boolean iterateCalled;
    public java.util.Iterator iterateReturn;
    public Throwable iterateException;
    public java.util.Iterator iterate() throws net.sf.hibernate.HibernateException {
        iterateCalled = true;
        if (iterateException != null) {
            if (iterateException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) iterateException;
            if (iterateException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) iterateException;
            if (iterateException instanceof java.lang.Error)
                throw (java.lang.Error) iterateException;
            throw new RuntimeException();
        }
        return this.iterateReturn;
    }

    public boolean scrollCalled;
    public net.sf.hibernate.ScrollableResults scrollReturn;
    public Throwable scrollException;
    public net.sf.hibernate.ScrollableResults scroll() throws net.sf.hibernate.HibernateException {
        scrollCalled = true;
        if (scrollException != null) {
            if (scrollException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) scrollException;
            if (scrollException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) scrollException;
            if (scrollException instanceof java.lang.Error)
                throw (java.lang.Error) scrollException;
            throw new RuntimeException();
        }
        return this.scrollReturn;
    }

    public boolean listCalled;
    public java.util.List listReturn;
    public Throwable listException;
    public java.util.List list() throws net.sf.hibernate.HibernateException {
        listCalled = true;
        if (listException != null) {
            if (listException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) listException;
            if (listException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) listException;
            if (listException instanceof java.lang.Error)
                throw (java.lang.Error) listException;
            throw new RuntimeException();
        }
        return this.listReturn;
    }

    public boolean setMaxResultsCalled;
    public net.sf.hibernate.Query setMaxResultsReturn;
    public Throwable setMaxResultsException;
    public int setMaxResultsMaxResults;
    public net.sf.hibernate.Query setMaxResults(int maxResults) {
        setMaxResultsCalled = true;
        this.setMaxResultsMaxResults = maxResults;
        if (setMaxResultsException != null) {
            if (setMaxResultsException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setMaxResultsException;
            if (setMaxResultsException instanceof java.lang.Error)
                throw (java.lang.Error) setMaxResultsException;
            throw new RuntimeException();
        }
        return this.setMaxResultsReturn;
    }

    public boolean setFirstResultCalled;
    public net.sf.hibernate.Query setFirstResultReturn;
    public Throwable setFirstResultException;
    public int setFirstResultFirstResult;
    public net.sf.hibernate.Query setFirstResult(int firstResult) {
        setFirstResultCalled = true;
        this.setFirstResultFirstResult = firstResult;
        if (setFirstResultException != null) {
            if (setFirstResultException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setFirstResultException;
            if (setFirstResultException instanceof java.lang.Error)
                throw (java.lang.Error) setFirstResultException;
            throw new RuntimeException();
        }
        return this.setFirstResultReturn;
    }

    public boolean setTimeoutCalled;
    public net.sf.hibernate.Query setTimeoutReturn;
    public Throwable setTimeoutException;
    public int setTimeoutTimeout;
    public net.sf.hibernate.Query setTimeout(int timeout) {
        setTimeoutCalled = true;
        this.setTimeoutTimeout = timeout;
        if (setTimeoutException != null) {
            if (setTimeoutException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setTimeoutException;
            if (setTimeoutException instanceof java.lang.Error)
                throw (java.lang.Error) setTimeoutException;
            throw new RuntimeException();
        }
        return this.setTimeoutReturn;
    }

    public boolean setLockModeCalled;
    public Throwable setLockModeException;
    public java.lang.String setLockModeAlias;
    public net.sf.hibernate.LockMode setLockModeLockMode;
    public void setLockMode(java.lang.String alias, net.sf.hibernate.LockMode lockMode) {
        setLockModeCalled = true;
        this.setLockModeAlias = alias;
        this.setLockModeLockMode = lockMode;
        if (setLockModeException != null) {
            if (setLockModeException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setLockModeException;
            if (setLockModeException instanceof java.lang.Error)
                throw (java.lang.Error) setLockModeException;
            throw new RuntimeException();
        }
    }

    public boolean setParameterCalled;
    public net.sf.hibernate.Query setParameterReturn;
    public Throwable setParameterException;
    public int setParameterPosition;
    public java.lang.Object setParameterVal;
    public net.sf.hibernate.type.Type setParameterType;
    public net.sf.hibernate.Query setParameter(int position, java.lang.Object val, net.sf.hibernate.type.Type type) {
        setParameterCalled = true;
        this.setParameterPosition = position;
        this.setParameterVal = val;
        this.setParameterType = type;
        if (setParameterException != null) {
            if (setParameterException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setParameterException;
            if (setParameterException instanceof java.lang.Error)
                throw (java.lang.Error) setParameterException;
            throw new RuntimeException();
        }
        return this.setParameterReturn;
    }

    public boolean setParameter2Called;
    public net.sf.hibernate.Query setParameter2Return;
    public Throwable setParameter2Exception;
    public java.lang.String setParameter2Name;
    public java.lang.Object setParameter2Val;
    public net.sf.hibernate.type.Type setParameter2Type;
    public net.sf.hibernate.Query setParameter(java.lang.String name, java.lang.Object val, net.sf.hibernate.type.Type type) {
        setParameter2Called = true;
        this.setParameter2Name = name;
        this.setParameter2Val = val;
        this.setParameter2Type = type;
        if (setParameter2Exception != null) {
            if (setParameter2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setParameter2Exception;
            if (setParameter2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setParameter2Exception;
            throw new RuntimeException();
        }
        return this.setParameter2Return;
    }

    public boolean setParameter3Called;
    public net.sf.hibernate.Query setParameter3Return;
    public Throwable setParameter3Exception;
    public int setParameter3Position;
    public java.lang.Object setParameter3Val;
    public net.sf.hibernate.Query setParameter(int position, java.lang.Object val) throws net.sf.hibernate.HibernateException {
        setParameter3Called = true;
        this.setParameter3Position = position;
        this.setParameter3Val = val;
        if (setParameter3Exception != null) {
            if (setParameter3Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) setParameter3Exception;
            if (setParameter3Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setParameter3Exception;
            if (setParameter3Exception instanceof java.lang.Error)
                throw (java.lang.Error) setParameter3Exception;
            throw new RuntimeException();
        }
        return this.setParameter3Return;
    }

    public boolean setParameter4Called;
    public net.sf.hibernate.Query setParameter4Return;
    public Throwable setParameter4Exception;
    public java.lang.String setParameter4Name;
    public java.lang.Object setParameter4Val;
    public net.sf.hibernate.Query setParameter(java.lang.String name, java.lang.Object val) throws net.sf.hibernate.HibernateException {
        setParameter4Called = true;
        this.setParameter4Name = name;
        this.setParameter4Val = val;
        if (setParameter4Exception != null) {
            if (setParameter4Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) setParameter4Exception;
            if (setParameter4Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setParameter4Exception;
            if (setParameter4Exception instanceof java.lang.Error)
                throw (java.lang.Error) setParameter4Exception;
            throw new RuntimeException();
        }
        return this.setParameter4Return;
    }

    public boolean setParameterListCalled;
    public net.sf.hibernate.Query setParameterListReturn;
    public Throwable setParameterListException;
    public java.lang.String setParameterListName;
    public java.util.Collection setParameterListVals;
    public net.sf.hibernate.type.Type setParameterListType;
    public net.sf.hibernate.Query setParameterList(java.lang.String name, java.util.Collection vals, net.sf.hibernate.type.Type type) throws net.sf.hibernate.HibernateException {
        setParameterListCalled = true;
        this.setParameterListName = name;
        this.setParameterListVals = vals;
        this.setParameterListType = type;
        if (setParameterListException != null) {
            if (setParameterListException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) setParameterListException;
            if (setParameterListException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setParameterListException;
            if (setParameterListException instanceof java.lang.Error)
                throw (java.lang.Error) setParameterListException;
            throw new RuntimeException();
        }
        return this.setParameterListReturn;
    }

    public boolean setParameterList2Called;
    public net.sf.hibernate.Query setParameterList2Return;
    public Throwable setParameterList2Exception;
    public java.lang.String setParameterList2Name;
    public java.util.Collection setParameterList2Vals;
    public net.sf.hibernate.Query setParameterList(java.lang.String name, java.util.Collection vals) throws net.sf.hibernate.HibernateException {
        setParameterList2Called = true;
        this.setParameterList2Name = name;
        this.setParameterList2Vals = vals;
        if (setParameterList2Exception != null) {
            if (setParameterList2Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) setParameterList2Exception;
            if (setParameterList2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setParameterList2Exception;
            if (setParameterList2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setParameterList2Exception;
            throw new RuntimeException();
        }
        return this.setParameterList2Return;
    }

    public boolean setParameterList3Called;
    public net.sf.hibernate.Query setParameterList3Return;
    public Throwable setParameterList3Exception;
    public java.lang.String setParameterList3Name;
    public java.lang.Object[] setParameterList3Vals;
    public net.sf.hibernate.type.Type setParameterList3Type;
    public net.sf.hibernate.Query setParameterList(java.lang.String name, java.lang.Object[] vals, net.sf.hibernate.type.Type type) throws net.sf.hibernate.HibernateException {
        setParameterList3Called = true;
        this.setParameterList3Name = name;
        this.setParameterList3Vals = vals;
        this.setParameterList3Type = type;
        if (setParameterList3Exception != null) {
            if (setParameterList3Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) setParameterList3Exception;
            if (setParameterList3Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setParameterList3Exception;
            if (setParameterList3Exception instanceof java.lang.Error)
                throw (java.lang.Error) setParameterList3Exception;
            throw new RuntimeException();
        }
        return this.setParameterList3Return;
    }

    public boolean setParameterList4Called;
    public net.sf.hibernate.Query setParameterList4Return;
    public Throwable setParameterList4Exception;
    public java.lang.String setParameterList4Name;
    public java.lang.Object[] setParameterList4Vals;
    public net.sf.hibernate.Query setParameterList(java.lang.String name, java.lang.Object[] vals) throws net.sf.hibernate.HibernateException {
        setParameterList4Called = true;
        this.setParameterList4Name = name;
        this.setParameterList4Vals = vals;
        if (setParameterList4Exception != null) {
            if (setParameterList4Exception instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) setParameterList4Exception;
            if (setParameterList4Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setParameterList4Exception;
            if (setParameterList4Exception instanceof java.lang.Error)
                throw (java.lang.Error) setParameterList4Exception;
            throw new RuntimeException();
        }
        return this.setParameterList4Return;
    }

    public boolean setPropertiesCalled;
    public net.sf.hibernate.Query setPropertiesReturn;
    public Throwable setPropertiesException;
    public java.lang.Object setPropertiesBean;
    public net.sf.hibernate.Query setProperties(java.lang.Object bean) throws net.sf.hibernate.HibernateException {
        setPropertiesCalled = true;
        this.setPropertiesBean = bean;
        if (setPropertiesException != null) {
            if (setPropertiesException instanceof net.sf.hibernate.HibernateException)
                throw (net.sf.hibernate.HibernateException) setPropertiesException;
            if (setPropertiesException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setPropertiesException;
            if (setPropertiesException instanceof java.lang.Error)
                throw (java.lang.Error) setPropertiesException;
            throw new RuntimeException();
        }
        return this.setPropertiesReturn;
    }

    public boolean setStringCalled;
    public net.sf.hibernate.Query setStringReturn;
    public Throwable setStringException;
    public int setStringPosition;
    public java.lang.String setStringVal;
    public net.sf.hibernate.Query setString(int position, java.lang.String val) {
        setStringCalled = true;
        this.setStringPosition = position;
        this.setStringVal = val;
        if (setStringException != null) {
            if (setStringException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setStringException;
            if (setStringException instanceof java.lang.Error)
                throw (java.lang.Error) setStringException;
            throw new RuntimeException();
        }
        return this.setStringReturn;
    }

    public boolean setCharacterCalled;
    public net.sf.hibernate.Query setCharacterReturn;
    public Throwable setCharacterException;
    public int setCharacterPosition;
    public char setCharacterVal;
    public net.sf.hibernate.Query setCharacter(int position, char val) {
        setCharacterCalled = true;
        this.setCharacterPosition = position;
        this.setCharacterVal = val;
        if (setCharacterException != null) {
            if (setCharacterException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setCharacterException;
            if (setCharacterException instanceof java.lang.Error)
                throw (java.lang.Error) setCharacterException;
            throw new RuntimeException();
        }
        return this.setCharacterReturn;
    }

    public boolean setBooleanCalled;
    public net.sf.hibernate.Query setBooleanReturn;
    public Throwable setBooleanException;
    public int setBooleanPosition;
    public boolean setBooleanVal;
    public net.sf.hibernate.Query setBoolean(int position, boolean val) {
        setBooleanCalled = true;
        this.setBooleanPosition = position;
        this.setBooleanVal = val;
        if (setBooleanException != null) {
            if (setBooleanException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setBooleanException;
            if (setBooleanException instanceof java.lang.Error)
                throw (java.lang.Error) setBooleanException;
            throw new RuntimeException();
        }
        return this.setBooleanReturn;
    }

    public boolean setByteCalled;
    public net.sf.hibernate.Query setByteReturn;
    public Throwable setByteException;
    public int setBytePosition;
    public byte setByteVal;
    public net.sf.hibernate.Query setByte(int position, byte val) {
        setByteCalled = true;
        this.setBytePosition = position;
        this.setByteVal = val;
        if (setByteException != null) {
            if (setByteException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setByteException;
            if (setByteException instanceof java.lang.Error)
                throw (java.lang.Error) setByteException;
            throw new RuntimeException();
        }
        return this.setByteReturn;
    }

    public boolean setShortCalled;
    public net.sf.hibernate.Query setShortReturn;
    public Throwable setShortException;
    public int setShortPosition;
    public short setShortVal;
    public net.sf.hibernate.Query setShort(int position, short val) {
        setShortCalled = true;
        this.setShortPosition = position;
        this.setShortVal = val;
        if (setShortException != null) {
            if (setShortException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setShortException;
            if (setShortException instanceof java.lang.Error)
                throw (java.lang.Error) setShortException;
            throw new RuntimeException();
        }
        return this.setShortReturn;
    }

    public boolean setIntegerCalled;
    public net.sf.hibernate.Query setIntegerReturn;
    public Throwable setIntegerException;
    public int setIntegerPosition;
    public int setIntegerVal;
    public net.sf.hibernate.Query setInteger(int position, int val) {
        setIntegerCalled = true;
        this.setIntegerPosition = position;
        this.setIntegerVal = val;
        if (setIntegerException != null) {
            if (setIntegerException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setIntegerException;
            if (setIntegerException instanceof java.lang.Error)
                throw (java.lang.Error) setIntegerException;
            throw new RuntimeException();
        }
        return this.setIntegerReturn;
    }

    public boolean setLongCalled;
    public net.sf.hibernate.Query setLongReturn;
    public Throwable setLongException;
    public int setLongPosition;
    public long setLongVal;
    public net.sf.hibernate.Query setLong(int position, long val) {
        setLongCalled = true;
        this.setLongPosition = position;
        this.setLongVal = val;
        if (setLongException != null) {
            if (setLongException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setLongException;
            if (setLongException instanceof java.lang.Error)
                throw (java.lang.Error) setLongException;
            throw new RuntimeException();
        }
        return this.setLongReturn;
    }

    public boolean setFloatCalled;
    public net.sf.hibernate.Query setFloatReturn;
    public Throwable setFloatException;
    public int setFloatPosition;
    public float setFloatVal;
    public net.sf.hibernate.Query setFloat(int position, float val) {
        setFloatCalled = true;
        this.setFloatPosition = position;
        this.setFloatVal = val;
        if (setFloatException != null) {
            if (setFloatException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setFloatException;
            if (setFloatException instanceof java.lang.Error)
                throw (java.lang.Error) setFloatException;
            throw new RuntimeException();
        }
        return this.setFloatReturn;
    }

    public boolean setDoubleCalled;
    public net.sf.hibernate.Query setDoubleReturn;
    public Throwable setDoubleException;
    public int setDoublePosition;
    public double setDoubleVal;
    public net.sf.hibernate.Query setDouble(int position, double val) {
        setDoubleCalled = true;
        this.setDoublePosition = position;
        this.setDoubleVal = val;
        if (setDoubleException != null) {
            if (setDoubleException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setDoubleException;
            if (setDoubleException instanceof java.lang.Error)
                throw (java.lang.Error) setDoubleException;
            throw new RuntimeException();
        }
        return this.setDoubleReturn;
    }

    public boolean setBinaryCalled;
    public net.sf.hibernate.Query setBinaryReturn;
    public Throwable setBinaryException;
    public int setBinaryPosition;
    public byte[] setBinaryVal;
    public net.sf.hibernate.Query setBinary(int position, byte[] val) {
        setBinaryCalled = true;
        this.setBinaryPosition = position;
        this.setBinaryVal = val;
        if (setBinaryException != null) {
            if (setBinaryException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setBinaryException;
            if (setBinaryException instanceof java.lang.Error)
                throw (java.lang.Error) setBinaryException;
            throw new RuntimeException();
        }
        return this.setBinaryReturn;
    }

    public boolean setSerializableCalled;
    public net.sf.hibernate.Query setSerializableReturn;
    public Throwable setSerializableException;
    public int setSerializablePosition;
    public java.io.Serializable setSerializableVal;
    public net.sf.hibernate.Query setSerializable(int position, java.io.Serializable val) {
        setSerializableCalled = true;
        this.setSerializablePosition = position;
        this.setSerializableVal = val;
        if (setSerializableException != null) {
            if (setSerializableException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setSerializableException;
            if (setSerializableException instanceof java.lang.Error)
                throw (java.lang.Error) setSerializableException;
            throw new RuntimeException();
        }
        return this.setSerializableReturn;
    }

    public boolean setLocaleCalled;
    public net.sf.hibernate.Query setLocaleReturn;
    public Throwable setLocaleException;
    public int setLocalePosition;
    public java.util.Locale setLocaleLocale;
    public net.sf.hibernate.Query setLocale(int position, java.util.Locale locale) {
        setLocaleCalled = true;
        this.setLocalePosition = position;
        this.setLocaleLocale = locale;
        if (setLocaleException != null) {
            if (setLocaleException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setLocaleException;
            if (setLocaleException instanceof java.lang.Error)
                throw (java.lang.Error) setLocaleException;
            throw new RuntimeException();
        }
        return this.setLocaleReturn;
    }

    public boolean setBigDecimalCalled;
    public net.sf.hibernate.Query setBigDecimalReturn;
    public Throwable setBigDecimalException;
    public int setBigDecimalPosition;
    public java.math.BigDecimal setBigDecimalNumber;
    public net.sf.hibernate.Query setBigDecimal(int position, java.math.BigDecimal number) {
        setBigDecimalCalled = true;
        this.setBigDecimalPosition = position;
        this.setBigDecimalNumber = number;
        if (setBigDecimalException != null) {
            if (setBigDecimalException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setBigDecimalException;
            if (setBigDecimalException instanceof java.lang.Error)
                throw (java.lang.Error) setBigDecimalException;
            throw new RuntimeException();
        }
        return this.setBigDecimalReturn;
    }

    public boolean setDateCalled;
    public net.sf.hibernate.Query setDateReturn;
    public Throwable setDateException;
    public int setDatePosition;
    public java.util.Date setDateDate;
    public net.sf.hibernate.Query setDate(int position, java.util.Date date) {
        setDateCalled = true;
        this.setDatePosition = position;
        this.setDateDate = date;
        if (setDateException != null) {
            if (setDateException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setDateException;
            if (setDateException instanceof java.lang.Error)
                throw (java.lang.Error) setDateException;
            throw new RuntimeException();
        }
        return this.setDateReturn;
    }

    public boolean setTimeCalled;
    public net.sf.hibernate.Query setTimeReturn;
    public Throwable setTimeException;
    public int setTimePosition;
    public java.util.Date setTimeDate;
    public net.sf.hibernate.Query setTime(int position, java.util.Date date) {
        setTimeCalled = true;
        this.setTimePosition = position;
        this.setTimeDate = date;
        if (setTimeException != null) {
            if (setTimeException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setTimeException;
            if (setTimeException instanceof java.lang.Error)
                throw (java.lang.Error) setTimeException;
            throw new RuntimeException();
        }
        return this.setTimeReturn;
    }

    public boolean setTimestampCalled;
    public net.sf.hibernate.Query setTimestampReturn;
    public Throwable setTimestampException;
    public int setTimestampPosition;
    public java.util.Date setTimestampDate;
    public net.sf.hibernate.Query setTimestamp(int position, java.util.Date date) {
        setTimestampCalled = true;
        this.setTimestampPosition = position;
        this.setTimestampDate = date;
        if (setTimestampException != null) {
            if (setTimestampException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setTimestampException;
            if (setTimestampException instanceof java.lang.Error)
                throw (java.lang.Error) setTimestampException;
            throw new RuntimeException();
        }
        return this.setTimestampReturn;
    }

    public boolean setCalendarCalled;
    public net.sf.hibernate.Query setCalendarReturn;
    public Throwable setCalendarException;
    public int setCalendarPosition;
    public java.util.Calendar setCalendarCalendar;
    public net.sf.hibernate.Query setCalendar(int position, java.util.Calendar calendar) {
        setCalendarCalled = true;
        this.setCalendarPosition = position;
        this.setCalendarCalendar = calendar;
        if (setCalendarException != null) {
            if (setCalendarException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setCalendarException;
            if (setCalendarException instanceof java.lang.Error)
                throw (java.lang.Error) setCalendarException;
            throw new RuntimeException();
        }
        return this.setCalendarReturn;
    }

    public boolean setCalendarDateCalled;
    public net.sf.hibernate.Query setCalendarDateReturn;
    public Throwable setCalendarDateException;
    public int setCalendarDatePosition;
    public java.util.Calendar setCalendarDateCalendar;
    public net.sf.hibernate.Query setCalendarDate(int position, java.util.Calendar calendar) {
        setCalendarDateCalled = true;
        this.setCalendarDatePosition = position;
        this.setCalendarDateCalendar = calendar;
        if (setCalendarDateException != null) {
            if (setCalendarDateException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setCalendarDateException;
            if (setCalendarDateException instanceof java.lang.Error)
                throw (java.lang.Error) setCalendarDateException;
            throw new RuntimeException();
        }
        return this.setCalendarDateReturn;
    }

    public boolean setString2Called;
    public net.sf.hibernate.Query setString2Return;
    public Throwable setString2Exception;
    public java.lang.String setString2Name;
    public java.lang.String setString2Val;
    public net.sf.hibernate.Query setString(java.lang.String name, java.lang.String val) {
        setString2Called = true;
        this.setString2Name = name;
        this.setString2Val = val;
        if (setString2Exception != null) {
            if (setString2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setString2Exception;
            if (setString2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setString2Exception;
            throw new RuntimeException();
        }
        return this.setString2Return;
    }

    public boolean setCharacter2Called;
    public net.sf.hibernate.Query setCharacter2Return;
    public Throwable setCharacter2Exception;
    public java.lang.String setCharacter2Name;
    public char setCharacter2Val;
    public net.sf.hibernate.Query setCharacter(java.lang.String name, char val) {
        setCharacter2Called = true;
        this.setCharacter2Name = name;
        this.setCharacter2Val = val;
        if (setCharacter2Exception != null) {
            if (setCharacter2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setCharacter2Exception;
            if (setCharacter2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setCharacter2Exception;
            throw new RuntimeException();
        }
        return this.setCharacter2Return;
    }

    public boolean setBoolean2Called;
    public net.sf.hibernate.Query setBoolean2Return;
    public Throwable setBoolean2Exception;
    public java.lang.String setBoolean2Name;
    public boolean setBoolean2Val;
    public net.sf.hibernate.Query setBoolean(java.lang.String name, boolean val) {
        setBoolean2Called = true;
        this.setBoolean2Name = name;
        this.setBoolean2Val = val;
        if (setBoolean2Exception != null) {
            if (setBoolean2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setBoolean2Exception;
            if (setBoolean2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setBoolean2Exception;
            throw new RuntimeException();
        }
        return this.setBoolean2Return;
    }

    public boolean setByte2Called;
    public net.sf.hibernate.Query setByte2Return;
    public Throwable setByte2Exception;
    public java.lang.String setByte2Name;
    public byte setByte2Val;
    public net.sf.hibernate.Query setByte(java.lang.String name, byte val) {
        setByte2Called = true;
        this.setByte2Name = name;
        this.setByte2Val = val;
        if (setByte2Exception != null) {
            if (setByte2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setByte2Exception;
            if (setByte2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setByte2Exception;
            throw new RuntimeException();
        }
        return this.setByte2Return;
    }

    public boolean setShort2Called;
    public net.sf.hibernate.Query setShort2Return;
    public Throwable setShort2Exception;
    public java.lang.String setShort2Name;
    public short setShort2Val;
    public net.sf.hibernate.Query setShort(java.lang.String name, short val) {
        setShort2Called = true;
        this.setShort2Name = name;
        this.setShort2Val = val;
        if (setShort2Exception != null) {
            if (setShort2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setShort2Exception;
            if (setShort2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setShort2Exception;
            throw new RuntimeException();
        }
        return this.setShort2Return;
    }

    public boolean setInteger2Called;
    public net.sf.hibernate.Query setInteger2Return;
    public Throwable setInteger2Exception;
    public java.lang.String setInteger2Name;
    public int setInteger2Val;
    public net.sf.hibernate.Query setInteger(java.lang.String name, int val) {
        setInteger2Called = true;
        this.setInteger2Name = name;
        this.setInteger2Val = val;
        if (setInteger2Exception != null) {
            if (setInteger2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setInteger2Exception;
            if (setInteger2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setInteger2Exception;
            throw new RuntimeException();
        }
        return this.setInteger2Return;
    }

    public boolean setLong2Called;
    public net.sf.hibernate.Query setLong2Return;
    public Throwable setLong2Exception;
    public java.lang.String setLong2Name;
    public long setLong2Val;
    public net.sf.hibernate.Query setLong(java.lang.String name, long val) {
        setLong2Called = true;
        this.setLong2Name = name;
        this.setLong2Val = val;
        if (setLong2Exception != null) {
            if (setLong2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setLong2Exception;
            if (setLong2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setLong2Exception;
            throw new RuntimeException();
        }
        return this.setLong2Return;
    }

    public boolean setFloat2Called;
    public net.sf.hibernate.Query setFloat2Return;
    public Throwable setFloat2Exception;
    public java.lang.String setFloat2Name;
    public float setFloat2Val;
    public net.sf.hibernate.Query setFloat(java.lang.String name, float val) {
        setFloat2Called = true;
        this.setFloat2Name = name;
        this.setFloat2Val = val;
        if (setFloat2Exception != null) {
            if (setFloat2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setFloat2Exception;
            if (setFloat2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setFloat2Exception;
            throw new RuntimeException();
        }
        return this.setFloat2Return;
    }

    public boolean setDouble2Called;
    public net.sf.hibernate.Query setDouble2Return;
    public Throwable setDouble2Exception;
    public java.lang.String setDouble2Name;
    public double setDouble2Val;
    public net.sf.hibernate.Query setDouble(java.lang.String name, double val) {
        setDouble2Called = true;
        this.setDouble2Name = name;
        this.setDouble2Val = val;
        if (setDouble2Exception != null) {
            if (setDouble2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setDouble2Exception;
            if (setDouble2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setDouble2Exception;
            throw new RuntimeException();
        }
        return this.setDouble2Return;
    }

    public boolean setBinary2Called;
    public net.sf.hibernate.Query setBinary2Return;
    public Throwable setBinary2Exception;
    public java.lang.String setBinary2Name;
    public byte[] setBinary2Val;
    public net.sf.hibernate.Query setBinary(java.lang.String name, byte[] val) {
        setBinary2Called = true;
        this.setBinary2Name = name;
        this.setBinary2Val = val;
        if (setBinary2Exception != null) {
            if (setBinary2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setBinary2Exception;
            if (setBinary2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setBinary2Exception;
            throw new RuntimeException();
        }
        return this.setBinary2Return;
    }

    public boolean setSerializable2Called;
    public net.sf.hibernate.Query setSerializable2Return;
    public Throwable setSerializable2Exception;
    public java.lang.String setSerializable2Name;
    public java.io.Serializable setSerializable2Val;
    public net.sf.hibernate.Query setSerializable(java.lang.String name, java.io.Serializable val) {
        setSerializable2Called = true;
        this.setSerializable2Name = name;
        this.setSerializable2Val = val;
        if (setSerializable2Exception != null) {
            if (setSerializable2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setSerializable2Exception;
            if (setSerializable2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setSerializable2Exception;
            throw new RuntimeException();
        }
        return this.setSerializable2Return;
    }

    public boolean setLocale2Called;
    public net.sf.hibernate.Query setLocale2Return;
    public Throwable setLocale2Exception;
    public java.lang.String setLocale2Name;
    public java.util.Locale setLocale2Locale;
    public net.sf.hibernate.Query setLocale(java.lang.String name, java.util.Locale locale) {
        setLocale2Called = true;
        this.setLocale2Name = name;
        this.setLocale2Locale = locale;
        if (setLocale2Exception != null) {
            if (setLocale2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setLocale2Exception;
            if (setLocale2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setLocale2Exception;
            throw new RuntimeException();
        }
        return this.setLocale2Return;
    }

    public boolean setBigDecimal2Called;
    public net.sf.hibernate.Query setBigDecimal2Return;
    public Throwable setBigDecimal2Exception;
    public java.lang.String setBigDecimal2Name;
    public java.math.BigDecimal setBigDecimal2Number;
    public net.sf.hibernate.Query setBigDecimal(java.lang.String name, java.math.BigDecimal number) {
        setBigDecimal2Called = true;
        this.setBigDecimal2Name = name;
        this.setBigDecimal2Number = number;
        if (setBigDecimal2Exception != null) {
            if (setBigDecimal2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setBigDecimal2Exception;
            if (setBigDecimal2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setBigDecimal2Exception;
            throw new RuntimeException();
        }
        return this.setBigDecimal2Return;
    }

    public boolean setDate2Called;
    public net.sf.hibernate.Query setDate2Return;
    public Throwable setDate2Exception;
    public java.lang.String setDate2Name;
    public java.util.Date setDate2Date;
    public net.sf.hibernate.Query setDate(java.lang.String name, java.util.Date date) {
        setDate2Called = true;
        this.setDate2Name = name;
        this.setDate2Date = date;
        if (setDate2Exception != null) {
            if (setDate2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setDate2Exception;
            if (setDate2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setDate2Exception;
            throw new RuntimeException();
        }
        return this.setDate2Return;
    }

    public boolean setTime2Called;
    public net.sf.hibernate.Query setTime2Return;
    public Throwable setTime2Exception;
    public java.lang.String setTime2Name;
    public java.util.Date setTime2Date;
    public net.sf.hibernate.Query setTime(java.lang.String name, java.util.Date date) {
        setTime2Called = true;
        this.setTime2Name = name;
        this.setTime2Date = date;
        if (setTime2Exception != null) {
            if (setTime2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setTime2Exception;
            if (setTime2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setTime2Exception;
            throw new RuntimeException();
        }
        return this.setTime2Return;
    }

    public boolean setTimestamp2Called;
    public net.sf.hibernate.Query setTimestamp2Return;
    public Throwable setTimestamp2Exception;
    public java.lang.String setTimestamp2Name;
    public java.util.Date setTimestamp2Date;
    public net.sf.hibernate.Query setTimestamp(java.lang.String name, java.util.Date date) {
        setTimestamp2Called = true;
        this.setTimestamp2Name = name;
        this.setTimestamp2Date = date;
        if (setTimestamp2Exception != null) {
            if (setTimestamp2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setTimestamp2Exception;
            if (setTimestamp2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setTimestamp2Exception;
            throw new RuntimeException();
        }
        return this.setTimestamp2Return;
    }

    public boolean setCalendar2Called;
    public net.sf.hibernate.Query setCalendar2Return;
    public Throwable setCalendar2Exception;
    public java.lang.String setCalendar2Name;
    public java.util.Calendar setCalendar2Calendar;
    public net.sf.hibernate.Query setCalendar(java.lang.String name, java.util.Calendar calendar) {
        setCalendar2Called = true;
        this.setCalendar2Name = name;
        this.setCalendar2Calendar = calendar;
        if (setCalendar2Exception != null) {
            if (setCalendar2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setCalendar2Exception;
            if (setCalendar2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setCalendar2Exception;
            throw new RuntimeException();
        }
        return this.setCalendar2Return;
    }

    public boolean setCalendarDate2Called;
    public net.sf.hibernate.Query setCalendarDate2Return;
    public Throwable setCalendarDate2Exception;
    public java.lang.String setCalendarDate2Name;
    public java.util.Calendar setCalendarDate2Calendar;
    public net.sf.hibernate.Query setCalendarDate(java.lang.String name, java.util.Calendar calendar) {
        setCalendarDate2Called = true;
        this.setCalendarDate2Name = name;
        this.setCalendarDate2Calendar = calendar;
        if (setCalendarDate2Exception != null) {
            if (setCalendarDate2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setCalendarDate2Exception;
            if (setCalendarDate2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setCalendarDate2Exception;
            throw new RuntimeException();
        }
        return this.setCalendarDate2Return;
    }

    public boolean setEntityCalled;
    public net.sf.hibernate.Query setEntityReturn;
    public Throwable setEntityException;
    public int setEntityPosition;
    public java.lang.Object setEntityVal;
    public net.sf.hibernate.Query setEntity(int position, java.lang.Object val) {
        setEntityCalled = true;
        this.setEntityPosition = position;
        this.setEntityVal = val;
        if (setEntityException != null) {
            if (setEntityException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setEntityException;
            if (setEntityException instanceof java.lang.Error)
                throw (java.lang.Error) setEntityException;
            throw new RuntimeException();
        }
        return this.setEntityReturn;
    }

    public boolean setEnumCalled;
    public net.sf.hibernate.Query setEnumReturn;
    public Throwable setEnumException;
    public int setEnumPosition;
    public java.lang.Object setEnumVal;
    public net.sf.hibernate.Query setEnum(int position, java.lang.Object val) throws net.sf.hibernate.MappingException {
        setEnumCalled = true;
        this.setEnumPosition = position;
        this.setEnumVal = val;
        if (setEnumException != null) {
            if (setEnumException instanceof net.sf.hibernate.MappingException)
                throw (net.sf.hibernate.MappingException) setEnumException;
            if (setEnumException instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setEnumException;
            if (setEnumException instanceof java.lang.Error)
                throw (java.lang.Error) setEnumException;
            throw new RuntimeException();
        }
        return this.setEnumReturn;
    }

    public boolean setEntity2Called;
    public net.sf.hibernate.Query setEntity2Return;
    public Throwable setEntity2Exception;
    public java.lang.String setEntity2Name;
    public java.lang.Object setEntity2Val;
    public net.sf.hibernate.Query setEntity(java.lang.String name, java.lang.Object val) {
        setEntity2Called = true;
        this.setEntity2Name = name;
        this.setEntity2Val = val;
        if (setEntity2Exception != null) {
            if (setEntity2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setEntity2Exception;
            if (setEntity2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setEntity2Exception;
            throw new RuntimeException();
        }
        return this.setEntity2Return;
    }

    public boolean setEnum2Called;
    public net.sf.hibernate.Query setEnum2Return;
    public Throwable setEnum2Exception;
    public java.lang.String setEnum2Name;
    public java.lang.Object setEnum2Val;
    public net.sf.hibernate.Query setEnum(java.lang.String name, java.lang.Object val) throws net.sf.hibernate.MappingException {
        setEnum2Called = true;
        this.setEnum2Name = name;
        this.setEnum2Val = val;
        if (setEnum2Exception != null) {
            if (setEnum2Exception instanceof net.sf.hibernate.MappingException)
                throw (net.sf.hibernate.MappingException) setEnum2Exception;
            if (setEnum2Exception instanceof java.lang.RuntimeException)
                throw (java.lang.RuntimeException) setEnum2Exception;
            if (setEnum2Exception instanceof java.lang.Error)
                throw (java.lang.Error) setEnum2Exception;
            throw new RuntimeException();
        }
        return this.setEnum2Return;
    }

}