// *******************************************************************
//
// (c) Copyright 2004, Object Computing, Inc.
// All Rights Reserved.
//
// *******************************************************************

package com.ociweb;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
  
public class DualHotelServer { 
  public static void main(String args[]) {
    try {

        // create and initialize the ORB and POA
        ORB orb = ORB.init(args, null);
        POA rootPOA = org.omg.PortableServer.POAHelper.narrow(
            orb.resolve_initial_references("RootPOA"));
 
        // Instantiate the Servant and activate the Tie
        HotelImpl hotelImpl = new DualHotelImpl(rootPOA);
        _HotelImpl_Tie tie = (_HotelImpl_Tie)Util.getTie(hotelImpl);

        //HotelImpl servant = new HotelImpl();
        byte[] id = rootPOA.activate_object(tie);
        
        // Publish the object reference in the Naming Service 
        NamingContextExt root = NamingContextExtHelper.narrow(
            orb.resolve_initial_references("NameService") );       
        root.rebind( root.to_name( "Hotel California" ),
                     rootPOA.id_to_reference(id) );

        // Publish the object reference in the RMI Registry
        Properties rmiProps = new Properties();
        rmiProps.put( "java.naming.factory.initial",
                      "com.sun.jndi.rmi.registry.RegistryContextFactory" );
        InitialContext rmiContext = new InitialContext( rmiProps );
        UnicastRemoteObject.exportObject( hotelImpl );
        rmiContext.rebind( "Hotel California", hotelImpl );

        // activate the RootPOA, and run
        rootPOA.the_POAManager().activate();

        System.out.println( "Ready" );
        orb.run(); 
    } catch (Exception e) {
      System.err.println("ERROR: " + e);
      e.printStackTrace(System.out);
    }
  }
}
