// *******************************************************************
//
// (c) Copyright 2004, Object Computing, Inc.
// All Rights Reserved.
//
// *******************************************************************

package com.ociweb;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class DualHotelImpl extends HotelImpl
{
    public DualHotelImpl(POA guestRoomPOA) throws RemoteException
    {
        super( guestRoomPOA );
    }

    protected void activateGuestRoom( GuestRoomImpl roomImpl ) 
        throws RemoteException, ServantAlreadyActive, WrongPolicy {
        
        super.activateGuestRoom( roomImpl );
        UnicastRemoteObject.exportObject( roomImpl );
    }

}
