// *******************************************************************
//
// (c) Copyright 2004, Object Computing, Inc.
// All Rights Reserved.
//
// *******************************************************************

package com.ociweb;

import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import javax.rmi.CORBA.Util;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class HotelImpl extends PortableRemoteObject implements HotelInterface
{
    private static final int NUMBER_OF_ROOMS = 500;
    private GuestRoomImpl[] rooms = new GuestRoomImpl[NUMBER_OF_ROOMS];

    private POA guestRoomPOA;

    public HotelImpl(POA guestRoomPOA) throws RemoteException
    {
        this.guestRoomPOA = guestRoomPOA;
    }

    public String getName() throws RemoteException
    {
        return "Hotel California";
    }
    public short getNumberOfRooms() throws RemoteException
    {
        return NUMBER_OF_ROOMS;
    }
    public GuestRoomInterface checkIn(short numNights) throws RemoteException
    { 
        // Determine if a room is available.  

        GuestRoomInterface availableRoom = null;

        short nextRoom = 0;
        while ( nextRoom < NUMBER_OF_ROOMS 
                && rooms[nextRoom] != null  
                && !rooms[nextRoom].isAvailable() ) {
            ++nextRoom;
        } // end of while ()
        
        if ( nextRoom < NUMBER_OF_ROOMS ) {
            if ( rooms[nextRoom] == null ) {
                rooms[nextRoom] = new GuestRoomImpl(nextRoom);
            } // end of if ()

            try {
                // activate GuestRoom
                activateGuestRoom( rooms[nextRoom] );
            }
            catch (Exception e) {
                // can't activate GuestRoom
                rooms[nextRoom] = null;
                System.err.println("ERROR: " + e );
                e.printStackTrace(System.err);
                return null;
            }

            rooms[nextRoom].checkIn( numNights );
            availableRoom = rooms[nextRoom];
        } // end of else
        
        return availableRoom;
    }

    public GuestRoomSummary[] getRoomSummaries() throws RemoteException {
        System.out.println( "Getting room summaries" );
        GuestRoomSummary[] summaries = new GuestRoomSummary[ rooms.length ];
        for ( int i = 0; i < summaries.length; ++i ) {
            if ( rooms[i] == null ) {
                summaries[i] = new GuestRoomSummary( 
                    (short)i,
                    GuestRoomImpl.getDefaultRate(),
                    false, // not in use
                    (float)0.0 );
            } else {
                boolean isInUse = !rooms[i].isAvailable();
                summaries[i] = new GuestRoomSummary( rooms[i].getRoomNumber(),
                                                     rooms[i].getRate(),
                                                     isInUse,
                                                     rooms[i].getBalance() );
            } // end of else
        } // end of for ()
        System.out.println( "Done getting room summaries" );
        return summaries;
    }

    protected void activateGuestRoom( GuestRoomImpl roomImpl )
        throws RemoteException, ServantAlreadyActive, WrongPolicy {

        _GuestRoomImpl_Tie tie 
            = (_GuestRoomImpl_Tie)Util.getTie( roomImpl );
        byte[] id = guestRoomPOA.activate_object(tie);
    }
}
