// *******************************************************************
//
// (c) Copyright 2004, Object Computing, Inc.
// All Rights Reserved.
//
// *******************************************************************

package com.ociweb;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
  
public class NSHotelServer { 
  public static void main(String args[]) {
    try {

        // create and initialize the ORB and POA
        ORB orb = ORB.init(args, null);
        POA rootPOA = org.omg.PortableServer.POAHelper.narrow(
            orb.resolve_initial_references("RootPOA"));
 
        // Instantiate the Servant and activate the Tie
        HotelImpl hotelImpl = new HotelImpl(rootPOA);
        _HotelImpl_Tie tie = (_HotelImpl_Tie)Util.getTie(hotelImpl);

        //HotelImpl servant = new HotelImpl();
        byte[] id = rootPOA.activate_object(tie);
        
        // Publish the reference in the Naming Service 
        NamingContextExt root = NamingContextExtHelper.narrow(
            orb.resolve_initial_references("NameService") );
        
        root.rebind( root.to_name( "Hotel California" ),
                     rootPOA.id_to_reference(id) );
            
        // activate the RootPOA, and run
        rootPOA.the_POAManager().activate();

        System.out.println( "Ready" );
        orb.run(); 
    } catch (Exception e) {
      System.err.println("ERROR: " + e);
      e.printStackTrace(System.out);
    }
  }
}
