// *******************************************************************
//
// (c) Copyright 2004, Object Computing, Inc.
// All Rights Reserved.
//
// *******************************************************************

package com.ociweb;

import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class GuestRoomImpl extends PortableRemoteObject 
    implements GuestRoomInterface
{
    private boolean isAvailable = true;
    private short   roomNumber;
    private float   rate        = 100.0f;
    private short   numNights;
    private float   balance     = 0.0f;

    GuestRoomImpl( short roomNumber ) throws RemoteException
    {
        this.roomNumber = roomNumber;
    }

    public void checkIn( short numNights )
    {
        System.out.println( "Checking in to room " + this.roomNumber );
        this.isAvailable = false;
        this.numNights = numNights;

        this.balance = this.numNights * this.rate;        
    }

    public short getRoomNumber() throws RemoteException
    {
        return this.roomNumber;
    }
    public static float getDefaultRate()
    {
        return 100.0f;
    }
    public float getRate() throws RemoteException
    {
        return this.rate;
    }
    public short getNumNights() throws RemoteException
    {
        return this.numNights;
    }
    public float getBalance() throws RemoteException
    {
        System.out.println( "Getting balance of room " + this.roomNumber );
        return this.balance;
    }

    public void chargeMeal( float amount ) throws RemoteException
    {
        System.out.println( "Charging meal to room " + this.roomNumber );
        this.balance += amount;
    }
    public void checkOut() throws RemoteException
    {
        System.out.println( "Checking out of room " + this.roomNumber );
        this.isAvailable = true;
        this.numNights = 0;
        this.balance = (float)0.0;
    }
    public boolean isAvailable() {
        return this.isAvailable;
    }
}
