// *******************************************************************
//
// (c) Copyright 2004, Object Computing, Inc.
// All Rights Reserved.
//
// *******************************************************************

package com.ociweb;

import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class HotelImpl extends PortableRemoteObject implements HotelInterface
{
    private static final int NUMBER_OF_ROOMS = 500;
    private GuestRoomImpl[] rooms = new GuestRoomImpl[NUMBER_OF_ROOMS];

    public HotelImpl() throws RemoteException
    {
    }

    public String getName() throws RemoteException
    {
        return "Hotel California";
    }
    public short getNumberOfRooms() throws RemoteException
    {
        return NUMBER_OF_ROOMS;
    }
    public GuestRoomInterface checkIn(short numNights) throws RemoteException
    { 
        // Determine if a room is available.  

        System.out.println( "Getting a room for " + numNights + " nights" );

        GuestRoomInterface availableRoom = null;

        short nextRoom = 0;
        while ( nextRoom < NUMBER_OF_ROOMS 
                && rooms[nextRoom] != null 
                && !rooms[nextRoom].isAvailable() ) {
            ++nextRoom;
        } // end of while ()
        
        if ( nextRoom < NUMBER_OF_ROOMS ) {
            if ( rooms[nextRoom] == null ) {
                rooms[nextRoom] = new GuestRoomImpl(nextRoom);
            } // end of if ()

            rooms[nextRoom].checkIn( numNights );
            availableRoom = rooms[nextRoom];
        } // end of else
        
        return availableRoom;
    }

    public GuestRoomSummary[] getRoomSummaries() throws RemoteException {
        System.out.println( "Getting room summaries" );
        GuestRoomSummary[] summaries = new GuestRoomSummary[ rooms.length ];
        for ( int i = 0; i < summaries.length; ++i ) {
            if ( rooms[i] == null ) {
                summaries[i] = new GuestRoomSummary( 
                    (short)i,
                    GuestRoomImpl.getDefaultRate(),
                    false, // not in use
                    (float)0.0 );
            } else {
                boolean isInUse = !rooms[i].isAvailable();
                summaries[i] = new GuestRoomSummary( rooms[i].getRoomNumber(),
                                                     rooms[i].getRate(),
                                                     isInUse,
                                                     rooms[i].getBalance() );
            } // end of else
        } // end of for ()
        System.out.println( "Done getting room summaries" );
        return summaries;
    }
}
