// *******************************************************************
//
// (c) Copyright 2004, Object Computing, Inc.
// All Rights Reserved.
//
// *******************************************************************

package com.ociweb;

import javax.rmi.PortableRemoteObject;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class HotelClient
{
  public static void main( String[] args )
  {
        Context ic;
        Object objref;
        HotelInterface hi;

        try {
            ic = new InitialContext();

            // Get the Object reference from the Name Service
            // using JNDI call.
            objref = ic.lookup("Hotel California");
            //System.out.println("Client: Obtained a ref. to Hello server.");

            // Narrow the object reference to the concrete type and
            // invoke the method.
            hi = (HotelInterface) PortableRemoteObject.narrow(
                objref, HotelInterface.class);

            System.out.println( "Stub class is a " 
                                + hi.getClass().getName() );

            //System.out.println(hi);
            // Invoke operations on the Hotel as if it were a local object.
            // Note that "name" attribute is accessed via "name()" method
            String hotelName = hi.getName();
            System.out.println("This is the Hotel " + hotelName );
            
            // Check into a room for 5 nights.
            short numNights = 5;
            GuestRoomInterface room = hi.checkIn(numNights);
            System.out.println( "Balance at checkout for room "
                                + room.getRoomNumber()
                              + " will be: " 
                              + room.getBalance() );
            
            System.out.println( "\n\nRooms-in-use Summary:" );
            GuestRoomSummary[] summaries = hi.getRoomSummaries();
            for ( int i = 0; i < summaries.length; ++i ) {
                if ( summaries[i].isInUse() ) {
                    System.out.println( "  Room " + summaries[i].getRoomNumber()
                                        + ", rate = " + summaries[i].getRate()
                                        + ", balance = " + summaries[i].getBalance() );                  
                } // end of if ()
              
            } // end of for ()                      

    } catch (NamingException e) {
        System.out.println("failed to lookup object reference");
        e.printStackTrace();
        return;
    } catch (ClassCastException e) {
        System.out.println("narrow failed");
        e.printStackTrace();
        return;
        } catch( Exception e ) {
            System.err.println( "Exception " + e + "Caught" );
            e.printStackTrace( );
            return;
        }
  } 
}
