
import java.util.StringTokenizer;

public class PigLatinTranslator {

    public String translate(String str) {
        str = str.toLowerCase();

        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(str);
        while (tokenizer.hasMoreTokens()) {
            result.append(translateWord(tokenizer.nextToken()));
            result.append(" ");
        }
        return result.toString();
    }

    //  Translates one word into Pig Latin. If the word begins with a
    //  vowel, the suffix "yay" is appended to the word.  Otherwise,
    //  the first letter or two are moved to the end of the word,
    //  and "ay" is appended.
    private String translateWord(String word) {
        if (beginsWithVowel(word)) {
            return word + "yay";
        } else if (beginsWithPrefix(word)) {
            return word.substring(2) + word.substring(0, 2) + "ay";
        } else {
            return word.substring(1) + word.charAt(0) + "ay";
        }
    }

    //  Determines if the specified word begins with a vowel.
    private boolean beginsWithVowel(String word) {
        return "aeiouAEIOU".indexOf(word.charAt(0)) != -1;
    }

    private static String[] prefixArray = {
        "bl", "pl", "br", "pr", "ch", "sh", "cl", "sl", "cr", "sp",
        "dr", "sr", "fl", "st", "fr", "th", "gl", "tr", "gr", "wh",
        "kl", "wr", "ph"
    };

    //  Determines if the specified word begins with a particular
    //  two-character prefix.
    private boolean beginsWithPrefix(String str) {
        for (int i = 0; i < prefixArray.length; i++) {
            String prefix = prefixArray[i];
            if (str.startsWith(prefix)) {
                return true;
            }
        }
        return false;
    }

}