package com.ociweb.mmapi;

import java.io.IOException;

import javax.microedition.lcdui.*;
import javax.microedition.media.*;
import javax.microedition.media.control.*;
import javax.microedition.midlet.*;

public class VideoMIDlet extends MIDlet implements CommandListener, PlayerListener {
	private Player videoPlayer;
    private List entryScreen;
    private Form busyForm = createBusyForm();
	
	protected void startApp() throws MIDletStateChangeException {
		if (entryScreen == null) {
			entryScreen = new List("Video", List.IMPLICIT);
			entryScreen.append("Full screen", null);
			entryScreen.append("Window", null);
			entryScreen.setCommandListener(this);
        }
        Display.getDisplay(this).setCurrent(entryScreen);
    }
    
    private void showDisplayInWindow() {
        Form videoForm = new Form("Please watch");
        videoForm.append("Check this out!");
        try {
            videoPlayer = Manager.createPlayer("http://localhost/Rabbit2004.mpg");
            videoPlayer.addPlayerListener(this);
            Display.getDisplay(this).setCurrent(busyForm);
            videoPlayer.realize();
            VideoControl videoControl = (VideoControl)videoPlayer.getControl("VideoControl");
            if (videoControl != null) {
                Item videoItem = (Item)videoControl.initDisplayMode(VideoControl.USE_GUI_PRIMITIVE, null);
                videoControl.setDisplaySize(75, 75);
                videoForm.append(videoItem);
                videoForm.append("Watch above");
                Display.getDisplay(this).setCurrent(videoForm);
            }

            videoPlayer.start();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (MediaException e) {
            e.printStackTrace();
        }
    }
    
    private void showFullScreenDisplay() {
        Canvas canvas = new Canvas() {
            protected void paint(Graphics g) {
                // We won't draw anything ourselves
            }
        };
        Display.getDisplay(this).setCurrent(canvas);
        try {
            videoPlayer = Manager.createPlayer("http://localhost/Rabbit2004.mpg");
            videoPlayer.addPlayerListener(this);
            Display.getDisplay(this).setCurrent(busyForm);
            videoPlayer.realize();
            VideoControl videoControl = (VideoControl)videoPlayer.getControl("VideoControl");
            videoControl.initDisplayMode(VideoControl.USE_DIRECT_VIDEO, canvas);
            videoControl.setVisible(true);
            videoPlayer.start();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (MediaException e) {
            e.printStackTrace();
        }
    }
    protected void pauseApp() {
        stopPlayer();
    }
    private void stopPlayer() {
        try {
            videoPlayer.stop();
        } catch (MediaException e) {
            e.printStackTrace();
        }
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        stopPlayer();
    }
    public void commandAction(Command arg0, Displayable arg1) {
        if (entryScreen.getSelectedIndex() == 0) {
            Thread fullScreenThread = new Thread() {
                public void run() {
                    showFullScreenDisplay();
                }
            };
            fullScreenThread.start();
        } else {
            Thread windowThread = new Thread() {
                public void run() {
                    showDisplayInWindow();
                }
            };
            windowThread.start();
        }
    }
    private Form createBusyForm() {
        Form form = new Form("Please wait...");
        form.append("Loading movie...");
        return form;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event == PlayerListener.END_OF_MEDIA) {
            Display.getDisplay(this).setCurrent(entryScreen);
        }
    }
}