/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.EOFException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.gjt.mm.mysql.Buffer;
import org.gjt.mm.mysql.Driver;
import org.gjt.mm.mysql.MysqlIO;
import org.gjt.mm.mysql.ResultSet;
import org.gjt.mm.mysql.Statement;

public abstract class Connection {
    MysqlIO _IO = null;
    private boolean _isClosed = true;
    private String _Host = null;
    private int _port = 3306;
    private String _User = null;
    private String _Password = null;
    protected String _Database = null;
    private boolean _autoCommit = true;
    private boolean _readOnly = false;
    private boolean _do_unicode = false;
    private String _Encoding = null;
    private String _MyURL = null;
    private int _max_rows = -1;
    private boolean _max_rows_changed = false;
    private Driver _MyDriver;
    private Hashtable _ServerVariables = null;
    private int _max_allowed_packet = 65536;
    private int _net_buffer_length = 16384;
    private boolean _use_fast_ping = false;
    private boolean _high_availability = false;
    private int _max_reconnects = 3;
    private double _initial_timeout = 2.0;
    private static final String _PING_COMMAND = "SELECT 1";
    private boolean transactionsSupported = false;
    private boolean relaxAutoCommit = false;
    private boolean useUltraDevWorkAround = false;

    public void connectionInit(String Host, int port, Properties Info, String Database, String Url, Driver D) throws SQLException {
        int n;
        this._Host = Host == null ? "localhost" : new String(Host);
        this._port = port;
        if (Database == null) {
            throw new SQLException("Malformed URL '" + Url + "'.", "S1000");
        }
        this._Database = new String(Database);
        this._MyURL = new String(Url);
        this._MyDriver = D;
        String U = Info.getProperty("user");
        String P = Info.getProperty("password");
        this._User = U == null || U.equals("") ? "nobody" : new String(U);
        this._Password = P == null ? "" : new String(P);
        if (Info.getProperty("relaxAutocommit") != null) {
            this.relaxAutoCommit = Info.getProperty("relaxAutocommit").toUpperCase().equals("TRUE");
        }
        if (Info.getProperty("autoReconnect") != null) {
            this._high_availability = Info.getProperty("autoReconnect").toUpperCase().equals("TRUE");
        }
        if (Info.getProperty("ultraDevHack") != null) {
            this.useUltraDevWorkAround = Info.getProperty("ultraDevHack").toUpperCase().equals("TRUE");
        }
        if (this._high_availability) {
            if (Info.getProperty("maxReconnects") != null) {
                try {
                    this._max_reconnects = n = Integer.parseInt(Info.getProperty("maxReconnects"));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Illegal parameter '" + Info.getProperty("maxReconnects") + "' for maxReconnects", "0S100");
                }
            }
            if (Info.getProperty("initialTimeout") != null) {
                try {
                    double n2;
                    this._initial_timeout = n2 = (double)Integer.parseInt(Info.getProperty("intialTimeout"));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Illegal parameter '" + Info.getProperty("initialTimeout") + "' for initialTimeout", "0S100");
                }
            }
        }
        if (Info.getProperty("maxRows") != null) {
            try {
                n = Integer.parseInt(Info.getProperty("maxRows"));
                if (n == 0) {
                    n = -1;
                }
                this._max_rows = n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Illegal parameter '" + Info.getProperty("maxRows") + "' for maxRows", "0S100");
            }
        }
        if (Info.getProperty("useUnicode") != null) {
            String UseUnicode = Info.getProperty("useUnicode").toUpperCase();
            if (UseUnicode.startsWith("TRUE")) {
                this._do_unicode = true;
            }
            if (Info.getProperty("characterEncoding") != null) {
                this._Encoding = Info.getProperty("characterEncoding");
                try {
                    String TestString = "abc";
                    TestString.getBytes(this._Encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException("Unsupported character encoding '" + this._Encoding + "'.", "0S100");
                }
            }
        }
        try {
            block42: {
                Statement Stmt;
                block41: {
                    this._IO = this.createNewIO(Host, port);
                    this._IO.init(this._User, this._Password);
                    if (this._Database.length() != 0) {
                        this._IO.sendCommand(2, this._Database, null);
                    }
                    this._isClosed = false;
                    this._ServerVariables = new Hashtable();
                    if (this._IO.versionMeetsMinimum(3, 22, 1)) {
                        this._use_fast_ping = true;
                    }
                    if (!this._IO.versionMeetsMinimum(3, 21, 22)) break block42;
                    Stmt = null;
                    ResultSet RS = null;
                    try {
                        Stmt = (Statement)((Object)this.createStatement());
                        RS = (ResultSet)((Object)Stmt.executeQuery("SHOW VARIABLES"));
                        while (RS.next()) {
                            this._ServerVariables.put(RS.getString(1), RS.getString(2));
                        }
                        Object var14_17 = null;
                        if (RS == null) break block41;
                    }
                    catch (Throwable throwable) {
                        Object var14_18 = null;
                        if (RS != null) {
                            try {
                                RS.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (Stmt != null) {
                            try {
                                Stmt.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        throw throwable;
                    }
                    try {
                        RS.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (Stmt != null) {
                    try {
                        Stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this._ServerVariables.containsKey("max_allowed_packet")) {
                    this._max_allowed_packet = Integer.parseInt((String)this._ServerVariables.get("max_allowed_packet"));
                }
                if (this._ServerVariables.containsKey("net_buffer_length")) {
                    this._net_buffer_length = Integer.parseInt((String)this._ServerVariables.get("net_buffer_length"));
                }
            }
            this.transactionsSupported = this._IO.versionMeetsMinimum(3, 23, 15);
            this._IO.resetMaxBuf();
        }
        catch (SQLException E) {
            throw E;
        }
        catch (Exception E) {
            throw new SQLException("Cannot connect to MySQL server on " + this._Host + ":" + this._port + ". Is there a MySQL server running on the machine/port you are trying to connect to? (" + E.getClass().getName() + ")", "08S01");
        }
    }

    public abstract java.sql.Statement createStatement() throws SQLException;

    public abstract PreparedStatement prepareStatement(String var1) throws SQLException;

    public CallableStatement prepareCall(String Sql) throws SQLException {
        if (this.useUltraDevWorkAround) {
            return new UltraDevWorkAround(this.prepareStatement(Sql));
        }
        throw new SQLException("Callable statments not suppoted.", "S1C00");
    }

    public String nativeSQL(String Sql) throws SQLException {
        return Sql;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.transactionsSupported) {
            String sql = "SET autocommit=" + (!autoCommit ? "0" : "1");
            this.execSQL(sql, -1);
            this._autoCommit = autoCommit;
        } else {
            if (!autoCommit && !this.relaxAutoCommit) {
                throw new SQLException("MySQL Versions Older than 3.23.15 do not support transactions", "08003");
            }
            this._autoCommit = autoCommit;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this._autoCommit;
    }

    public void commit() throws SQLException {
        if (this._autoCommit && !this.relaxAutoCommit) {
            throw new SQLException("Can't call commit when autocommit=true");
        }
        if (this.transactionsSupported) {
            this.execSQL("commit", -1);
        }
    }

    public void rollback() throws SQLException {
        if (this._autoCommit && !this.relaxAutoCommit) {
            throw new SQLException("Can't call commit when autocommit=true", "08003");
        }
        if (this.transactionsSupported) {
            this.execSQL("rollback", -1);
        }
        if (this._isClosed) {
            throw new SQLException("Rollback attempt on closed connection.", "08003");
        }
    }

    public void close() throws SQLException {
        if (this._IO != null) {
            try {
                this._IO.quit();
            }
            catch (Exception exception) {}
            this._IO = null;
        }
        this._isClosed = true;
    }

    public boolean isClosed() throws SQLException {
        if (!this._isClosed) {
            try {
                MysqlIO mysqlIO = this._IO;
                synchronized (mysqlIO) {
                    this.execSQL(_PING_COMMAND, -1);
                }
            }
            catch (Exception exception) {
                this._isClosed = true;
            }
        }
        return this._isClosed;
    }

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    public void setReadOnly(boolean readOnly) throws SQLException {
        this._readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this._readOnly;
    }

    public void setCatalog(String Catalog) throws SQLException {
        this.execSQL("USE " + Catalog, -1);
        this._Database = Catalog;
    }

    public String getCatalog() throws SQLException {
        return this._Database;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        throw new SQLException("Transaction Isolation Levels are not supported.", "S1C00");
    }

    public int getTransactionIsolation() throws SQLException {
        return 8;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    ResultSet execSQL(String Sql, int max_rows) throws SQLException {
        return this.execSQL(Sql, max_rows, null);
    }

    /*
     * Unable to fully structure code
     */
    ResultSet execSQL(String Sql, int max_rows, Buffer Packet) throws SQLException {
        var4_4 = this._IO;
        synchronized (var4_4) {
            block23: {
                if (this._high_availability) {
                    try {
                        if (this._use_fast_ping) {
                            this._IO.sendCommand(14, null, null);
                        } else {
                            this._IO.sqlQuery("SELECT 1", 50000000);
                        }
                        break block23;
                    }
                    catch (Exception v0) {
                        timeout = this._initial_timeout;
                        connection_good = false;
                        i = 0;
                        ** while (i < this._max_reconnects)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this._IO = this.createNewIO(this._Host, this._port);
                            this._IO.init(this._User, this._Password);
                            if (this._Database.length() != 0) {
                                this._IO.sendCommand(2, this._Database, null);
                            }
                            if (this._use_fast_ping) {
                                this._IO.sendCommand(14, null, null);
                            } else {
                                this._IO.sqlQuery("SELECT 1", 50000000);
                            }
                            connection_good = true;
                            break;
                        }
                        catch (Exception v1) {
                            try {
                                Thread.currentThread();
                                Thread.sleep((long)timeout * 1000L);
                                timeout *= timeout;
                            }
                            catch (InterruptedException v2) {}
                            ++i;
                        }
                        continue;
                    }
lbl43:
                    // 2 sources

                    if (!connection_good) {
                        throw new SQLException("Server connection failure during transaction. \nAttemtped reconnect " + this._max_reconnects + " times. Giving up.", "08001");
                    }
                }
            }
            try {
                v3 = real_max_rows = max_rows != -1 ? max_rows : 50000000;
                if (Packet == null) {
                    Encoding = null;
                    if (this.useUnicode()) {
                        Encoding = this.getEncoding();
                    }
                    return this._IO.sqlQuery(Sql, real_max_rows, Encoding, this);
                }
                return this._IO.sqlQueryDirect(Packet, real_max_rows, this);
            }
            catch (EOFException v4) {
                throw new SQLException("Lost connection to server during query", "08007");
            }
            catch (SQLException SQLE) {
                throw SQLE;
            }
            catch (Exception E) {
                ExceptionType = E.getClass().getName();
                ExceptionMessage = E.getMessage();
                throw new SQLException("Error during query: Unexpected Exception: " + ExceptionType + " message given: " + ExceptionMessage, "S1000");
            }
        }
    }

    protected abstract MysqlIO createNewIO(String var1, int var2) throws Exception;

    String getURL() {
        return this._MyURL;
    }

    String getUser() {
        return this._User;
    }

    String getServerVersion() {
        return this._IO.getServerVersion();
    }

    int getServerMajorVersion() {
        return this._IO.getServerMajorVersion();
    }

    int getServerMinorVersion() {
        return this._IO.getServerMinorVersion();
    }

    int getServerSubMinorVersion() {
        return this._IO.getServerSubMinorVersion();
    }

    void maxRowsChanged() {
        this._max_rows_changed = true;
    }

    boolean useMaxRows() {
        return this._max_rows_changed;
    }

    public boolean useUnicode() {
        return this._do_unicode;
    }

    public String getEncoding() {
        return this._Encoding;
    }

    Object getMutex() {
        return this._IO;
    }

    int getMaxAllowedPacket() {
        return this._max_allowed_packet;
    }

    int getNetBufferLength() {
        return this._net_buffer_length;
    }

    class UltraDevWorkAround
    implements CallableStatement {
        PreparedStatement delegate = null;

        UltraDevWorkAround(PreparedStatement pstmt) {
            this.delegate = pstmt;
        }

        public void addBatch() throws SQLException {
            this.delegate.addBatch();
        }

        public void addBatch(String p1) throws SQLException {
            this.delegate.addBatch(p1);
        }

        public void cancel() throws SQLException {
            this.delegate.cancel();
        }

        public void clearBatch() throws SQLException {
            this.delegate.clearBatch();
        }

        public void clearParameters() throws SQLException {
            this.delegate.clearParameters();
        }

        public void clearWarnings() throws SQLException {
            this.delegate.clearWarnings();
        }

        public void close() throws SQLException {
            this.delegate.close();
        }

        public boolean execute() throws SQLException {
            return this.delegate.execute();
        }

        public boolean execute(String p1) throws SQLException {
            return this.delegate.execute(p1);
        }

        public int[] executeBatch() throws SQLException {
            return this.delegate.executeBatch();
        }

        public java.sql.ResultSet executeQuery() throws SQLException {
            return this.delegate.executeQuery();
        }

        public java.sql.ResultSet executeQuery(String p1) throws SQLException {
            return this.delegate.executeQuery(p1);
        }

        public int executeUpdate() throws SQLException {
            return this.delegate.executeUpdate();
        }

        public int executeUpdate(String p1) throws SQLException {
            return this.delegate.executeUpdate(p1);
        }

        public Array getArray(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public BigDecimal getBigDecimal(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public BigDecimal getBigDecimal(int p1, int p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Blob getBlob(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public boolean getBoolean(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public byte getByte(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public byte[] getBytes(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Clob getClob(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public java.sql.Connection getConnection() throws SQLException {
            return this.delegate.getConnection();
        }

        public Date getDate(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Date getDate(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public double getDouble(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getFetchDirection() throws SQLException {
            return this.delegate.getFetchDirection();
        }

        public int getFetchSize() throws SQLException {
            return this.delegate.getFetchSize();
        }

        public float getFloat(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getInt(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public long getLong(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getMaxFieldSize() throws SQLException {
            return this.delegate.getMaxFieldSize();
        }

        public int getMaxRows() throws SQLException {
            return this.delegate.getMaxRows();
        }

        public ResultSetMetaData getMetaData() throws SQLException {
            throw new SQLException("Not supported");
        }

        public boolean getMoreResults() throws SQLException {
            return this.delegate.getMoreResults();
        }

        public Object getObject(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Object getObject(int p1, Map p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getQueryTimeout() throws SQLException {
            return this.delegate.getQueryTimeout();
        }

        public Ref getRef(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public java.sql.ResultSet getResultSet() throws SQLException {
            return this.delegate.getResultSet();
        }

        public int getResultSetConcurrency() throws SQLException {
            return this.delegate.getResultSetConcurrency();
        }

        public int getResultSetType() throws SQLException {
            return this.delegate.getResultSetType();
        }

        public short getShort(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public String getString(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Time getTime(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Time getTime(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Timestamp getTimestamp(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Timestamp getTimestamp(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getUpdateCount() throws SQLException {
            return this.delegate.getUpdateCount();
        }

        public SQLWarning getWarnings() throws SQLException {
            return this.delegate.getWarnings();
        }

        public void registerOutParameter(int p1, int p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(int p1, int p2, int p3) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(int p1, int p2, String p3) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void setArray(int p1, Array p2) throws SQLException {
            this.delegate.setArray(p1, p2);
        }

        public void setAsciiStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setAsciiStream(p1, p2, p3);
        }

        public void setBigDecimal(int p1, BigDecimal p2) throws SQLException {
            this.delegate.setBigDecimal(p1, p2);
        }

        public void setBinaryStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setBinaryStream(p1, p2, p3);
        }

        public void setBlob(int p1, Blob p2) throws SQLException {
            this.delegate.setBlob(p1, p2);
        }

        public void setBoolean(int p1, boolean p2) throws SQLException {
            this.delegate.setBoolean(p1, p2);
        }

        public void setByte(int p1, byte p2) throws SQLException {
            this.delegate.setByte(p1, p2);
        }

        public void setBytes(int p1, byte[] p2) throws SQLException {
            this.delegate.setBytes(p1, p2);
        }

        public void setCharacterStream(int p1, Reader p2, int p3) throws SQLException {
            this.delegate.setCharacterStream(p1, p2, p3);
        }

        public void setClob(int p1, Clob p2) throws SQLException {
            this.delegate.setClob(p1, p2);
        }

        public void setCursorName(String p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void setDate(int p1, Date p2) throws SQLException {
            this.delegate.setDate(p1, p2);
        }

        public void setDate(int p1, Date p2, Calendar p3) throws SQLException {
            this.delegate.setDate(p1, p2, p3);
        }

        public void setDouble(int p1, double p2) throws SQLException {
            this.delegate.setDouble(p1, p2);
        }

        public void setEscapeProcessing(boolean p1) throws SQLException {
            this.delegate.setEscapeProcessing(p1);
        }

        public void setFetchDirection(int p1) throws SQLException {
            this.delegate.setFetchDirection(p1);
        }

        public void setFetchSize(int p1) throws SQLException {
            this.delegate.setFetchSize(p1);
        }

        public void setFloat(int p1, float p2) throws SQLException {
            this.delegate.setFloat(p1, p2);
        }

        public void setInt(int p1, int p2) throws SQLException {
            this.delegate.setInt(p1, p2);
        }

        public void setLong(int p1, long p2) throws SQLException {
            this.delegate.setLong(p1, p2);
        }

        public void setMaxFieldSize(int p1) throws SQLException {
            this.delegate.setMaxFieldSize(p1);
        }

        public void setMaxRows(int p1) throws SQLException {
            this.delegate.setMaxRows(p1);
        }

        public void setNull(int p1, int p2) throws SQLException {
            this.delegate.setNull(p1, p2);
        }

        public void setNull(int p1, int p2, String p3) throws SQLException {
            this.delegate.setNull(p1, p2, p3);
        }

        public void setObject(int p1, Object p2) throws SQLException {
            this.delegate.setObject(p1, p2);
        }

        public void setObject(int p1, Object p2, int p3) throws SQLException {
            this.delegate.setObject(p1, p2, p3);
        }

        public void setObject(int p1, Object p2, int p3, int p4) throws SQLException {
            this.delegate.setObject(p1, p2, p3, p4);
        }

        public void setQueryTimeout(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void setRef(int p1, Ref p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void setShort(int p1, short p2) throws SQLException {
            this.delegate.setShort(p1, p2);
        }

        public void setString(int p1, String p2) throws SQLException {
            this.delegate.setString(p1, p2);
        }

        public void setTime(int p1, Time p2) throws SQLException {
            this.delegate.setTime(p1, p2);
        }

        public void setTime(int p1, Time p2, Calendar p3) throws SQLException {
            this.delegate.setTime(p1, p2, p3);
        }

        public void setTimestamp(int p1, Timestamp p2) throws SQLException {
            this.delegate.setTimestamp(p1, p2);
        }

        public void setTimestamp(int p1, Timestamp p2, Calendar p3) throws SQLException {
            this.delegate.setTimestamp(p1, p2, p3);
        }

        public void setUnicodeStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setUnicodeStream(p1, p2, p3);
        }

        public boolean wasNull() throws SQLException {
            throw new SQLException("Not supported");
        }
    }
}

