/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.EscapeProcessor;
import org.gjt.mm.mysql.MysqlIO;
import org.gjt.mm.mysql.ResultSet;

public class Statement {
    protected Connection _Conn = null;
    ResultSet _Results = null;
    ResultSet _NextResults = null;
    SQLWarning _Warnings = null;
    int _timeout = 0;
    boolean _escapeProcessing = true;
    EscapeProcessor _Escaper = null;
    int _max_field_size = MysqlIO.MAXBUF;
    int _max_rows = -1;
    long _update_count = -1L;
    long _last_insert_id = -1L;
    String _Catalog = null;
    protected Vector _Batched = null;

    public Statement(Connection C, String Catalog) {
        this._Conn = C;
        this._Escaper = new EscapeProcessor();
        this._Catalog = Catalog;
        if (this._Conn != null) {
            this._max_field_size = this._Conn.getMaxAllowedPacket();
        }
    }

    public java.sql.ResultSet executeQuery(String Sql) throws SQLException {
        if (this._escapeProcessing) {
            Sql = this._Escaper.escapeSQL(Sql);
        }
        if (Sql.indexOf("||") != -1) {
            Sql = EscapeProcessor.doConcat(Sql);
        }
        if (this._Results != null) {
            this._Results.close();
        }
        Object object = this._Conn.getMutex();
        synchronized (object) {
            String OldCatalog = null;
            if (!this._Conn.getCatalog().equals(this._Catalog)) {
                OldCatalog = this._Conn.getCatalog();
                this._Conn.setCatalog(this._Catalog);
            }
            if (this._Conn.useMaxRows()) {
                if (Sql.toUpperCase().indexOf("LIMIT") != -1) {
                    this._Results = this._Conn.execSQL(Sql, this._max_rows);
                } else {
                    if (this._max_rows <= 0) {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + 50000000, -1);
                    } else {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this._max_rows, -1);
                    }
                    this._Results = this._Conn.execSQL(Sql, -1);
                    if (OldCatalog != null) {
                        this._Conn.setCatalog(OldCatalog);
                    }
                }
            } else {
                this._Results = this._Conn.execSQL(Sql, -1);
            }
            if (OldCatalog != null) {
                this._Conn.setCatalog(OldCatalog);
            }
        }
        this._last_insert_id = this._Results.getUpdateID();
        this._NextResults = this._Results;
        this._Results.setConnection(this._Conn);
        return (java.sql.ResultSet)((Object)this._Results);
    }

    public int executeUpdate(String Sql) throws SQLException {
        if (this._escapeProcessing) {
            Sql = this._Escaper.escapeSQL(Sql);
        }
        if (Sql.indexOf("||") != -1) {
            Sql = EscapeProcessor.doConcat(Sql);
        }
        ResultSet RS = null;
        Object object = this._Conn.getMutex();
        synchronized (object) {
            String OldCatalog = null;
            if (!this._Conn.getCatalog().equals(this._Catalog)) {
                OldCatalog = this._Conn.getCatalog();
                this._Conn.setCatalog(this._Catalog);
            }
            RS = this._Conn.execSQL(Sql, -1);
            RS.setConnection(this._Conn);
            if (OldCatalog != null) {
                this._Conn.setCatalog(OldCatalog);
            }
        }
        if (RS.reallyResult()) {
            throw new SQLException("Results returned for UPDATE ONLY.", "01S03");
        }
        this._update_count = RS.getUpdateCount();
        int truncated_update_count = 0;
        truncated_update_count = this._update_count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._update_count;
        this._last_insert_id = RS.getUpdateID();
        return truncated_update_count;
    }

    public void close() throws SQLException {
        this._Results = null;
        this._Conn = null;
        this._Warnings = null;
        this._Escaper = null;
    }

    public int getMaxFieldSize() throws SQLException {
        return this._max_field_size;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        int max_buf;
        int n = max_buf = this._Conn == null ? MysqlIO.MAXBUF : this._Conn.getMaxAllowedPacket();
        if (max > max_buf) {
            throw new SQLException("Can not set max field size > max allowed packet: " + max_buf, "S1009");
        }
        this._max_field_size = max;
    }

    public int getMaxRows() throws SQLException {
        if (this._max_rows <= 0) {
            return 0;
        }
        return this._max_rows;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max > 50000000) {
            throw new SQLException("setMaxRows() out of range. " + max + " > " + 50000000 + ".", "S1009");
        }
        if (max == 0) {
            max = -1;
        }
        this._max_rows = max;
        this._Conn.maxRowsChanged();
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this._escapeProcessing = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this._timeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this._timeout = seconds;
    }

    public void cancel() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._Warnings;
    }

    public void clearWarnings() throws SQLException {
        this._Warnings = null;
    }

    public void setCursorName(String Name2) throws SQLException {
    }

    public boolean execute(String Sql) throws SQLException {
        if (this._escapeProcessing) {
            Sql = this._Escaper.escapeSQL(Sql);
        }
        if (Sql.indexOf("||") != -1) {
            Sql = EscapeProcessor.doConcat(Sql);
        }
        if (this._Results != null) {
            this._Results.close();
        }
        ResultSet RS = null;
        Object object = this._Conn.getMutex();
        synchronized (object) {
            String OldCatalog = null;
            if (!this._Conn.getCatalog().equals(this._Catalog)) {
                OldCatalog = this._Conn.getCatalog();
                this._Conn.setCatalog(this._Catalog);
            }
            if (this._Conn.useMaxRows()) {
                if (Sql.toUpperCase().indexOf("LIMIT") != -1) {
                    RS = this._Conn.execSQL(Sql, this._max_rows);
                } else {
                    if (this._max_rows <= 0) {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + 50000000, -1);
                    } else {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this._max_rows, -1);
                    }
                    RS = this._Conn.execSQL(Sql, -1);
                }
            } else {
                RS = this._Conn.execSQL(Sql, -1);
            }
            if (OldCatalog != null) {
                this._Conn.setCatalog(OldCatalog);
            }
        }
        this._last_insert_id = RS.getUpdateID();
        if (RS != null) {
            this._Results = RS;
        }
        RS.setConnection(this._Conn);
        return RS != null && RS.reallyResult();
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        if (this._Results != null && this._Results.reallyResult()) {
            return (java.sql.ResultSet)((Object)this._Results);
        }
        return null;
    }

    public int getUpdateCount() throws SQLException {
        if (this._Results == null) {
            return -1;
        }
        if (this._Results.reallyResult()) {
            return -1;
        }
        int truncated_update_count = 0;
        truncated_update_count = this._Results.getUpdateCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._Results.getUpdateCount();
        return truncated_update_count;
    }

    public long getLongUpdateCount() {
        if (this._Results == null) {
            return -1L;
        }
        if (this._Results.reallyResult()) {
            return -1L;
        }
        return this._update_count;
    }

    public long getLastInsertID() {
        return this._last_insert_id;
    }

    public boolean getMoreResults() throws SQLException {
        if (this._Results != null) {
            this._Results.close();
        }
        this._Results = this._NextResults;
        this._NextResults = null;
        return this._Results != null && this._Results.reallyResult();
    }

    public void setFetchDirection(int direction) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 0;
    }

    public void setFetchSize(int rows) throws SQLException {
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    public int getResultSetType() throws SQLException {
        return 0;
    }

    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void clearBatch() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int[] executeBatch() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public java.sql.Connection getConnection() throws SQLException {
        return (java.sql.Connection)((Object)this._Conn);
    }
}

